/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.updater;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.onionoo.updater.BandwidthStatusUpdater;
import org.torproject.onionoo.updater.ClientsStatusUpdater;
import org.torproject.onionoo.updater.LookupService;
import org.torproject.onionoo.updater.NodeDetailsStatusUpdater;
import org.torproject.onionoo.updater.ReverseDomainNameResolver;
import org.torproject.onionoo.updater.StatusUpdater;
import org.torproject.onionoo.updater.UptimeStatusUpdater;
import org.torproject.onionoo.updater.WeightsStatusUpdater;

public class StatusUpdateRunner {
    private static final Logger log = LoggerFactory.getLogger(StatusUpdateRunner.class);
    private LookupService ls = new LookupService(new File("geoip"));
    private ReverseDomainNameResolver rdnr = new ReverseDomainNameResolver();
    private StatusUpdater[] statusUpdaters;

    public StatusUpdateRunner() {
        NodeDetailsStatusUpdater ndsu = new NodeDetailsStatusUpdater(this.rdnr, this.ls);
        BandwidthStatusUpdater bsu = new BandwidthStatusUpdater();
        WeightsStatusUpdater wsu = new WeightsStatusUpdater();
        ClientsStatusUpdater csu = new ClientsStatusUpdater();
        UptimeStatusUpdater usu = new UptimeStatusUpdater();
        this.statusUpdaters = new StatusUpdater[]{ndsu, bsu, wsu, csu, usu};
    }

    public void updateStatuses() {
        for (StatusUpdater su : this.statusUpdaters) {
            log.debug("Begin update of " + su.getClass().getSimpleName());
            su.updateStatuses();
            log.info(su.getClass().getSimpleName() + " updated status files");
        }
    }

    public void logStatistics() {
        for (StatusUpdater su : this.statusUpdaters) {
            String statsString = su.getStatsString();
            if (statsString == null) continue;
            LoggerFactory.getLogger("statistics").info(su.getClass().getSimpleName() + "\n" + statsString);
        }
        LoggerFactory.getLogger("statistics").info("GeoIP lookup service\n" + this.ls.getStatsString());
        LoggerFactory.getLogger("statistics").info("Reverse domain name resolver\n" + this.rdnr.getStatsString());
    }
}

