/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.docs;

import java.util.Iterator;
import java.util.Scanner;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.onionoo.docs.Document;
import org.torproject.onionoo.docs.UptimeHistory;

public class UptimeStatus
extends Document {
    private static final Logger log = LoggerFactory.getLogger(UptimeStatus.class);
    private transient boolean isDirty = false;
    private SortedSet<UptimeHistory> relayHistory = new TreeSet<UptimeHistory>();
    private SortedSet<UptimeHistory> bridgeHistory = new TreeSet<UptimeHistory>();

    public boolean isDirty() {
        return this.isDirty;
    }

    public void clearDirty() {
        this.isDirty = false;
    }

    public SortedSet<UptimeHistory> getRelayHistory() {
        return this.relayHistory;
    }

    public SortedSet<UptimeHistory> getBridgeHistory() {
        return this.bridgeHistory;
    }

    @Override
    public void setFromDocumentString(String documentString) {
        try (Scanner s = new Scanner(documentString);){
            while (s.hasNextLine()) {
                String line = s.nextLine();
                UptimeHistory parsedLine = UptimeHistory.fromString(line);
                if (parsedLine != null) {
                    if (parsedLine.isRelay()) {
                        this.relayHistory.add(parsedLine);
                        continue;
                    }
                    this.bridgeHistory.add(parsedLine);
                    continue;
                }
                log.error("Could not parse uptime history line '" + line + "'.  Skipping.");
            }
        }
    }

    public void addToHistory(boolean relay, long startMillis, SortedSet<String> flags) {
        UptimeHistory prev;
        SortedSet<UptimeHistory> history = relay ? this.relayHistory : this.bridgeHistory;
        UptimeHistory interval = new UptimeHistory(relay, startMillis, 1, flags);
        TreeSet<UptimeHistory> existingIntervals = new TreeSet<UptimeHistory>(history.headSet(new UptimeHistory(relay, startMillis + 3600000L, 0, flags)));
        Iterator iterator = existingIntervals.descendingSet().iterator();
        if (iterator.hasNext() && (prev = (UptimeHistory)iterator.next()).isRelay() == interval.isRelay() && prev.getStartMillis() + 3600000L * (long)prev.getUptimeHours() > interval.getStartMillis()) {
            int hoursAfter;
            if (prev.getFlags() == interval.getFlags() || prev.getFlags() != null && interval.getFlags() != null && prev.getFlags().equals(interval.getFlags())) {
                return;
            }
            history.remove(prev);
            int hoursBefore = (int)((interval.getStartMillis() - prev.getStartMillis()) / 3600000L);
            if (hoursBefore > 0) {
                history.add(new UptimeHistory(relay, prev.getStartMillis(), hoursBefore, prev.getFlags()));
            }
            if ((hoursAfter = (int)(prev.getStartMillis() / 3600000L + (long)prev.getUptimeHours() - interval.getStartMillis() / 3600000L - 1L)) > 0) {
                history.add(new UptimeHistory(relay, interval.getStartMillis() + 3600000L, hoursAfter, prev.getFlags()));
            }
        }
        history.add(interval);
        this.isDirty = true;
    }

    public void compressHistory() {
        this.compressHistory(this.relayHistory);
        this.compressHistory(this.bridgeHistory);
    }

    private void compressHistory(SortedSet<UptimeHistory> history) {
        TreeSet<UptimeHistory> uncompressedHistory = new TreeSet<UptimeHistory>(history);
        history.clear();
        UptimeHistory lastInterval = null;
        for (UptimeHistory interval : uncompressedHistory) {
            if (lastInterval != null && lastInterval.getStartMillis() + 3600000L * (long)lastInterval.getUptimeHours() == interval.getStartMillis() && lastInterval.isRelay() == interval.isRelay() && (lastInterval.getFlags() == interval.getFlags() || lastInterval.getFlags() != null && interval.getFlags() != null && lastInterval.getFlags().equals(interval.getFlags()))) {
                lastInterval.addUptime(interval);
                continue;
            }
            if (lastInterval != null) {
                history.add(lastInterval);
            }
            lastInterval = interval;
        }
        if (lastInterval != null) {
            history.add(lastInterval);
        }
    }

    @Override
    public String toDocumentString() {
        StringBuilder sb = new StringBuilder();
        for (UptimeHistory interval : this.relayHistory) {
            sb.append(interval.toString() + "\n");
        }
        for (UptimeHistory interval : this.bridgeHistory) {
            sb.append(interval.toString() + "\n");
        }
        return sb.toString();
    }
}

