/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.writer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.onionoo.docs.ClientsDocument;
import org.torproject.onionoo.docs.ClientsGraphHistory;
import org.torproject.onionoo.docs.ClientsHistory;
import org.torproject.onionoo.docs.ClientsStatus;
import org.torproject.onionoo.docs.DocumentStore;
import org.torproject.onionoo.docs.DocumentStoreFactory;
import org.torproject.onionoo.docs.UpdateStatus;
import org.torproject.onionoo.util.FormattingUtils;
import org.torproject.onionoo.util.TimeFactory;
import org.torproject.onionoo.writer.DocumentWriter;

public class ClientsDocumentWriter
implements DocumentWriter {
    private static final Logger log = LoggerFactory.getLogger(ClientsDocumentWriter.class);
    private DocumentStore documentStore;
    private long now;
    private int writtenDocuments = 0;
    private String[] graphNames = new String[]{"1_week", "1_month", "3_months", "1_year", "5_years"};
    private long[] graphIntervals = new long[]{604800000L, 2678400000L, 7948800000L, 31622400000L, 158112000000L};
    private long[] dataPointIntervals = new long[]{86400000L, 86400000L, 86400000L, 172800000L, 864000000L};

    public ClientsDocumentWriter() {
        this.documentStore = DocumentStoreFactory.getDocumentStore();
        this.now = TimeFactory.getTime().currentTimeMillis();
    }

    @Override
    public void writeDocuments() {
        UpdateStatus updateStatus = this.documentStore.retrieve(UpdateStatus.class, true);
        long updatedMillis = updateStatus != null ? updateStatus.getUpdatedMillis() : 0L;
        SortedSet<String> updateDocuments = this.documentStore.list(ClientsStatus.class, updatedMillis);
        for (String hashedFingerprint : updateDocuments) {
            ClientsStatus clientsStatus = this.documentStore.retrieve(ClientsStatus.class, true, hashedFingerprint);
            if (clientsStatus == null) continue;
            SortedSet<ClientsHistory> history = clientsStatus.getHistory();
            ClientsDocument clientsDocument = this.compileClientsDocument(hashedFingerprint, history);
            this.documentStore.store(clientsDocument, hashedFingerprint);
            ++this.writtenDocuments;
        }
        log.info("Wrote clients document files");
    }

    private ClientsDocument compileClientsDocument(String hashedFingerprint, SortedSet<ClientsHistory> history) {
        ClientsDocument clientsDocument = new ClientsDocument();
        clientsDocument.setFingerprint(hashedFingerprint);
        LinkedHashMap<String, ClientsGraphHistory> averageClients = new LinkedHashMap<String, ClientsGraphHistory>();
        for (int graphIntervalIndex = 0; graphIntervalIndex < this.graphIntervals.length; ++graphIntervalIndex) {
            String graphName = this.graphNames[graphIntervalIndex];
            ClientsGraphHistory graphHistory = this.compileClientsHistory(graphIntervalIndex, history);
            if (graphHistory == null) continue;
            averageClients.put(graphName, graphHistory);
        }
        clientsDocument.setAverageClients(averageClients);
        return clientsDocument;
    }

    private ClientsGraphHistory compileClientsHistory(int graphIntervalIndex, SortedSet<ClientsHistory> history) {
        long graphInterval = this.graphIntervals[graphIntervalIndex];
        long dataPointInterval = this.dataPointIntervals[graphIntervalIndex];
        ArrayList<Double> dataPoints = new ArrayList<Double>();
        long intervalStartMillis = (this.now - graphInterval) / dataPointInterval * dataPointInterval;
        long millis = 0L;
        double responses = 0.0;
        double totalResponses = 0.0;
        TreeMap<String, Double> totalResponsesByCountry = new TreeMap<String, Double>();
        TreeMap<String, Double> totalResponsesByTransport = new TreeMap<String, Double>();
        TreeMap<String, Double> totalResponsesByVersion = new TreeMap<String, Double>();
        for (ClientsHistory hist : history) {
            if (hist.getEndMillis() < intervalStartMillis) continue;
            while (intervalStartMillis / dataPointInterval != hist.getEndMillis() / dataPointInterval) {
                dataPoints.add(millis * 2L < dataPointInterval ? -1.0 : responses * 8.64E7 / ((double)millis * 10.0));
                responses = 0.0;
                millis = 0L;
                intervalStartMillis += dataPointInterval;
            }
            responses += hist.getTotalResponses();
            totalResponses += hist.getTotalResponses();
            for (Map.Entry<String, Double> e : hist.getResponsesByCountry().entrySet()) {
                if (!totalResponsesByCountry.containsKey(e.getKey())) {
                    totalResponsesByCountry.put(e.getKey(), 0.0);
                }
                totalResponsesByCountry.put(e.getKey(), e.getValue() + (Double)totalResponsesByCountry.get(e.getKey()));
            }
            for (Map.Entry<String, Double> e : hist.getResponsesByTransport().entrySet()) {
                if (!totalResponsesByTransport.containsKey(e.getKey())) {
                    totalResponsesByTransport.put(e.getKey(), 0.0);
                }
                totalResponsesByTransport.put(e.getKey(), e.getValue() + (Double)totalResponsesByTransport.get(e.getKey()));
            }
            for (Map.Entry<String, Double> e : hist.getResponsesByVersion().entrySet()) {
                if (!totalResponsesByVersion.containsKey(e.getKey())) {
                    totalResponsesByVersion.put(e.getKey(), 0.0);
                }
                totalResponsesByVersion.put(e.getKey(), e.getValue() + (Double)totalResponsesByVersion.get(e.getKey()));
            }
            millis += hist.getEndMillis() - hist.getStartMillis();
        }
        dataPoints.add(millis * 2L < dataPointInterval ? -1.0 : responses * 8.64E7 / ((double)millis * 10.0));
        double maxValue = 0.0;
        int firstNonNullIndex = -1;
        int lastNonNullIndex = -1;
        for (int dataPointIndex = 0; dataPointIndex < dataPoints.size(); ++dataPointIndex) {
            double dataPoint = (Double)dataPoints.get(dataPointIndex);
            if (!(dataPoint >= 0.0)) continue;
            if (firstNonNullIndex < 0) {
                firstNonNullIndex = dataPointIndex;
            }
            lastNonNullIndex = dataPointIndex;
            if (!(dataPoint > maxValue)) continue;
            maxValue = dataPoint;
        }
        if (firstNonNullIndex < 0) {
            return null;
        }
        long firstDataPointMillis = ((this.now - graphInterval) / dataPointInterval + (long)firstNonNullIndex) * dataPointInterval + dataPointInterval / 2L;
        if (graphIntervalIndex > 0 && firstDataPointMillis >= this.now - this.graphIntervals[graphIntervalIndex - 1]) {
            return null;
        }
        long lastDataPointMillis = firstDataPointMillis + (long)(lastNonNullIndex - firstNonNullIndex) * dataPointInterval;
        double factor = maxValue / 999.0;
        int count = lastNonNullIndex - firstNonNullIndex + 1;
        ClientsGraphHistory graphHistory = new ClientsGraphHistory();
        graphHistory.setFirst(firstDataPointMillis);
        graphHistory.setLast(lastDataPointMillis);
        graphHistory.setInterval((int)(dataPointInterval / 1000L));
        graphHistory.setFactor(factor);
        graphHistory.setCount(count);
        int previousNonNullIndex = -2;
        boolean foundTwoAdjacentDataPoints = false;
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int dataPointIndex = firstNonNullIndex; dataPointIndex <= lastNonNullIndex; ++dataPointIndex) {
            double dataPoint = (Double)dataPoints.get(dataPointIndex);
            if (dataPoint >= 0.0) {
                if (dataPointIndex - previousNonNullIndex == 1) {
                    foundTwoAdjacentDataPoints = true;
                }
                previousNonNullIndex = dataPointIndex;
            }
            values.add(dataPoint < 0.0 ? null : Integer.valueOf((int)(dataPoint * 999.0 / maxValue)));
        }
        graphHistory.setValues(values);
        if (!totalResponsesByCountry.isEmpty()) {
            TreeMap<String, Float> countries = new TreeMap<String, Float>();
            for (Map.Entry e : totalResponsesByCountry.entrySet()) {
                if (!((Double)e.getValue() > totalResponses / 100.0)) continue;
                countries.put((String)e.getKey(), Float.valueOf((float)((Double)e.getValue() / totalResponses)));
            }
            graphHistory.setCountries(countries);
        }
        if (!totalResponsesByTransport.isEmpty()) {
            TreeMap<String, Float> transports = new TreeMap<String, Float>();
            for (Map.Entry e : totalResponsesByTransport.entrySet()) {
                if (!((Double)e.getValue() > totalResponses / 100.0)) continue;
                transports.put((String)e.getKey(), Float.valueOf((float)((Double)e.getValue() / totalResponses)));
            }
            graphHistory.setTransports(transports);
        }
        if (!totalResponsesByVersion.isEmpty()) {
            TreeMap<String, Float> versions = new TreeMap<String, Float>();
            for (Map.Entry e : totalResponsesByVersion.entrySet()) {
                if (!((Double)e.getValue() > totalResponses / 100.0)) continue;
                versions.put((String)e.getKey(), Float.valueOf((float)((Double)e.getValue() / totalResponses)));
            }
            graphHistory.setVersions(versions);
        }
        if (foundTwoAdjacentDataPoints) {
            return graphHistory;
        }
        return null;
    }

    @Override
    public String getStatsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    " + FormattingUtils.formatDecimalNumber(this.writtenDocuments) + " clients document files updated\n");
        return sb.toString();
    }
}

