/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.writer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.onionoo.docs.BandwidthDocument;
import org.torproject.onionoo.docs.BandwidthStatus;
import org.torproject.onionoo.docs.DocumentStore;
import org.torproject.onionoo.docs.DocumentStoreFactory;
import org.torproject.onionoo.docs.GraphHistory;
import org.torproject.onionoo.docs.UpdateStatus;
import org.torproject.onionoo.util.TimeFactory;
import org.torproject.onionoo.writer.DocumentWriter;

public class BandwidthDocumentWriter
implements DocumentWriter {
    private static final Logger log = LoggerFactory.getLogger(BandwidthDocumentWriter.class);
    private DocumentStore documentStore;
    private long now;
    private String[] graphNames = new String[]{"3_days", "1_week", "1_month", "3_months", "1_year", "5_years"};
    private long[] graphIntervals = new long[]{259200000L, 604800000L, 2678400000L, 7948800000L, 31622400000L, 158112000000L};
    private long[] dataPointIntervals = new long[]{900000L, 3600000L, 14400000L, 43200000L, 172800000L, 864000000L};

    public BandwidthDocumentWriter() {
        this.documentStore = DocumentStoreFactory.getDocumentStore();
        this.now = TimeFactory.getTime().currentTimeMillis();
    }

    @Override
    public void writeDocuments() {
        UpdateStatus updateStatus = this.documentStore.retrieve(UpdateStatus.class, true);
        long updatedMillis = updateStatus != null ? updateStatus.getUpdatedMillis() : 0L;
        SortedSet<String> updateBandwidthDocuments = this.documentStore.list(BandwidthStatus.class, updatedMillis);
        for (String fingerprint : updateBandwidthDocuments) {
            BandwidthStatus bandwidthStatus = this.documentStore.retrieve(BandwidthStatus.class, true, fingerprint);
            if (bandwidthStatus == null) continue;
            BandwidthDocument bandwidthDocument = this.compileBandwidthDocument(fingerprint, bandwidthStatus);
            this.documentStore.store(bandwidthDocument, fingerprint);
        }
        log.info("Wrote bandwidth document files");
    }

    private BandwidthDocument compileBandwidthDocument(String fingerprint, BandwidthStatus bandwidthStatus) {
        BandwidthDocument bandwidthDocument = new BandwidthDocument();
        bandwidthDocument.setFingerprint(fingerprint);
        bandwidthDocument.setWriteHistory(this.compileGraphType(bandwidthStatus.getWriteHistory()));
        bandwidthDocument.setReadHistory(this.compileGraphType(bandwidthStatus.getReadHistory()));
        return bandwidthDocument;
    }

    private Map<String, GraphHistory> compileGraphType(SortedMap<Long, long[]> history) {
        LinkedHashMap<String, GraphHistory> graphs = new LinkedHashMap<String, GraphHistory>();
        for (int i = 0; i < this.graphIntervals.length; ++i) {
            String graphName = this.graphNames[i];
            long graphInterval = this.graphIntervals[i];
            long dataPointInterval = this.dataPointIntervals[i];
            ArrayList<Long> dataPoints = new ArrayList<Long>();
            long intervalStartMillis = (this.now - graphInterval) / dataPointInterval * dataPointInterval;
            long totalMillis = 0L;
            long totalBandwidth = 0L;
            for (long[] v : history.values()) {
                long endMillis = v[1];
                if (endMillis < intervalStartMillis) continue;
                long startMillis = v[0];
                if (startMillis > this.now) break;
                if (endMillis - startMillis > dataPointInterval) continue;
                while (intervalStartMillis / dataPointInterval != endMillis / dataPointInterval) {
                    dataPoints.add(totalMillis * 5L < dataPointInterval ? -1L : totalBandwidth * 1000L / totalMillis);
                    totalBandwidth = 0L;
                    totalMillis = 0L;
                    intervalStartMillis += dataPointInterval;
                }
                long bandwidth = v[2];
                totalBandwidth += bandwidth;
                totalMillis += endMillis - startMillis;
            }
            dataPoints.add(totalMillis * 5L < dataPointInterval ? -1L : totalBandwidth * 1000L / totalMillis);
            long maxValue = 1L;
            int firstNonNullIndex = -1;
            int lastNonNullIndex = -1;
            for (int j = 0; j < dataPoints.size(); ++j) {
                long dataPoint = (Long)dataPoints.get(j);
                if (dataPoint < 0L) continue;
                if (firstNonNullIndex < 0) {
                    firstNonNullIndex = j;
                }
                lastNonNullIndex = j;
                if (dataPoint <= maxValue) continue;
                maxValue = dataPoint;
            }
            if (firstNonNullIndex < 0) continue;
            long firstDataPointMillis = ((this.now - graphInterval) / dataPointInterval + (long)firstNonNullIndex) * dataPointInterval + dataPointInterval / 2L;
            if (i > 0 && !graphs.isEmpty() && firstDataPointMillis >= this.now - this.graphIntervals[i - 1]) continue;
            long lastDataPointMillis = firstDataPointMillis + (long)(lastNonNullIndex - firstNonNullIndex) * dataPointInterval;
            double factor = (double)maxValue / 999.0;
            int count = lastNonNullIndex - firstNonNullIndex + 1;
            GraphHistory graphHistory = new GraphHistory();
            graphHistory.setFirst(firstDataPointMillis);
            graphHistory.setLast(lastDataPointMillis);
            graphHistory.setInterval((int)(dataPointInterval / 1000L));
            graphHistory.setFactor(factor);
            graphHistory.setCount(count);
            int previousNonNullIndex = -2;
            boolean foundTwoAdjacentDataPoints = false;
            ArrayList<Integer> values = new ArrayList<Integer>();
            for (int j = firstNonNullIndex; j <= lastNonNullIndex; ++j) {
                long dataPoint = (Long)dataPoints.get(j);
                if (dataPoint >= 0L) {
                    if (j - previousNonNullIndex == 1) {
                        foundTwoAdjacentDataPoints = true;
                    }
                    previousNonNullIndex = j;
                }
                values.add(dataPoint < 0L ? null : Integer.valueOf((int)(dataPoint * 999L / maxValue)));
            }
            graphHistory.setValues(values);
            if (!foundTwoAdjacentDataPoints) continue;
            graphs.put(graphName, graphHistory);
        }
        return graphs;
    }

    @Override
    public String getStatsString() {
        return null;
    }
}

