/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.updater;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.torproject.onionoo.updater.RdnsLookupWorker;
import org.torproject.onionoo.updater.ReverseDomainNameResolver;

class RdnsLookupRequest
extends Thread {
    private final ReverseDomainNameResolver reverseDomainNameResolver;
    private RdnsLookupWorker parent;
    private String address;
    private String hostName;
    private long lookupStartedMillis = -1L;
    private long lookupCompletedMillis = -1L;

    public RdnsLookupRequest(ReverseDomainNameResolver reverseDomainNameResolver, RdnsLookupWorker parent, String address) {
        this.reverseDomainNameResolver = reverseDomainNameResolver;
        this.parent = parent;
        this.address = address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.lookupStartedMillis = this.reverseDomainNameResolver.time.currentTimeMillis();
        try {
            String result = InetAddress.getByName(this.address).getHostName();
            RdnsLookupRequest rdnsLookupRequest = this;
            synchronized (rdnsLookupRequest) {
                this.hostName = result;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.lookupCompletedMillis = this.reverseDomainNameResolver.time.currentTimeMillis();
        this.parent.interrupt();
    }

    public synchronized String getHostName() {
        return this.hostName;
    }

    public synchronized long getLookupMillis() {
        return this.lookupCompletedMillis - this.lookupStartedMillis;
    }
}

