/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.updater;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.BridgeNetworkStatus;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.ExitList;
import org.torproject.descriptor.ExtraInfoDescriptor;
import org.torproject.descriptor.NetworkStatusEntry;
import org.torproject.descriptor.RelayNetworkStatusConsensus;
import org.torproject.descriptor.ServerDescriptor;
import org.torproject.onionoo.docs.DetailsStatus;
import org.torproject.onionoo.docs.DocumentStore;
import org.torproject.onionoo.docs.DocumentStoreFactory;
import org.torproject.onionoo.docs.NodeStatus;
import org.torproject.onionoo.updater.DescriptorListener;
import org.torproject.onionoo.updater.DescriptorSource;
import org.torproject.onionoo.updater.DescriptorSourceFactory;
import org.torproject.onionoo.updater.DescriptorType;
import org.torproject.onionoo.updater.LookupResult;
import org.torproject.onionoo.updater.LookupService;
import org.torproject.onionoo.updater.ReverseDomainNameResolver;
import org.torproject.onionoo.updater.StatusUpdater;
import org.torproject.onionoo.util.FormattingUtils;
import org.torproject.onionoo.util.TimeFactory;

public class NodeDetailsStatusUpdater
implements DescriptorListener,
StatusUpdater {
    private Logger log = LoggerFactory.getLogger(NodeDetailsStatusUpdater.class);
    private DescriptorSource descriptorSource;
    private ReverseDomainNameResolver reverseDomainNameResolver;
    private LookupService lookupService;
    private DocumentStore documentStore;
    private long now;
    private SortedMap<String, NodeStatus> knownNodes = new TreeMap<String, NodeStatus>();
    private long relaysLastValidAfterMillis = -1L;
    private long bridgesLastPublishedMillis = -1L;
    private SortedMap<String, Integer> lastBandwidthWeights = null;
    private int relayConsensusesProcessed = 0;
    private int bridgeStatusesProcessed = 0;
    private Map<String, SortedSet<String>> declaredFamilies = new HashMap<String, SortedSet<String>>();
    private Map<String, Map<String, Long>> exitListEntries = new HashMap<String, Map<String, Long>>();
    private Map<String, Long> lastSeenUnmeasured = new HashMap<String, Long>();
    private Map<String, Long> lastSeenMeasured = new HashMap<String, Long>();
    private SortedSet<String> currentRelays = new TreeSet<String>();
    private SortedSet<String> runningRelays = new TreeSet<String>();
    private SortedMap<String, LookupResult> geoIpLookupResults = new TreeMap<String, LookupResult>();
    private SortedMap<String, Float> consensusWeightFractions = new TreeMap<String, Float>();
    private SortedMap<String, Float> guardProbabilities = new TreeMap<String, Float>();
    private SortedMap<String, Float> middleProbabilities = new TreeMap<String, Float>();
    private SortedMap<String, Float> exitProbabilities = new TreeMap<String, Float>();
    private long startedRdnsLookups = -1L;
    private SortedMap<String, String> rdnsLookupResults = new TreeMap<String, String>();

    public NodeDetailsStatusUpdater(ReverseDomainNameResolver reverseDomainNameResolver, LookupService lookupService) {
        this.descriptorSource = DescriptorSourceFactory.getDescriptorSource();
        this.reverseDomainNameResolver = reverseDomainNameResolver;
        this.lookupService = lookupService;
        this.documentStore = DocumentStoreFactory.getDocumentStore();
        this.now = TimeFactory.getTime().currentTimeMillis();
        this.registerDescriptorListeners();
    }

    private void registerDescriptorListeners() {
        this.descriptorSource.registerDescriptorListener(this, DescriptorType.RELAY_CONSENSUSES);
        this.descriptorSource.registerDescriptorListener(this, DescriptorType.RELAY_SERVER_DESCRIPTORS);
        this.descriptorSource.registerDescriptorListener(this, DescriptorType.BRIDGE_STATUSES);
        this.descriptorSource.registerDescriptorListener(this, DescriptorType.BRIDGE_SERVER_DESCRIPTORS);
        this.descriptorSource.registerDescriptorListener(this, DescriptorType.BRIDGE_EXTRA_INFOS);
        this.descriptorSource.registerDescriptorListener(this, DescriptorType.EXIT_LISTS);
    }

    @Override
    public void processDescriptor(Descriptor descriptor, boolean relay) {
        if (descriptor instanceof ServerDescriptor && relay) {
            this.processRelayServerDescriptor((ServerDescriptor)descriptor);
        } else if (descriptor instanceof ExitList) {
            this.processExitList((ExitList)descriptor);
        } else if (descriptor instanceof RelayNetworkStatusConsensus) {
            this.processRelayNetworkStatusConsensus((RelayNetworkStatusConsensus)descriptor);
        } else if (descriptor instanceof ServerDescriptor && !relay) {
            this.processBridgeServerDescriptor((ServerDescriptor)descriptor);
        } else if (descriptor instanceof ExtraInfoDescriptor && !relay) {
            this.processBridgeExtraInfoDescriptor((ExtraInfoDescriptor)descriptor);
        } else if (descriptor instanceof BridgeNetworkStatus) {
            this.processBridgeNetworkStatus((BridgeNetworkStatus)descriptor);
        }
    }

    private void processRelayServerDescriptor(ServerDescriptor descriptor) {
        String fingerprint = descriptor.getFingerprint();
        DetailsStatus detailsStatus = this.documentStore.retrieve(DetailsStatus.class, true, fingerprint);
        if (detailsStatus == null) {
            detailsStatus = new DetailsStatus();
        } else if (detailsStatus.getDescPublished() != null && detailsStatus.getDescPublished() >= descriptor.getPublishedMillis()) {
            return;
        }
        long lastRestartedMillis = descriptor.getPublishedMillis() - descriptor.getUptime() * 1000L;
        int bandwidthRate = descriptor.getBandwidthRate();
        int bandwidthBurst = descriptor.getBandwidthBurst();
        int observedBandwidth = descriptor.getBandwidthObserved();
        int advertisedBandwidth = Math.min(bandwidthRate, Math.min(bandwidthBurst, observedBandwidth));
        detailsStatus.setDescPublished(descriptor.getPublishedMillis());
        detailsStatus.setLastRestarted(lastRestartedMillis);
        detailsStatus.setBandwidthRate(bandwidthRate);
        detailsStatus.setBandwidthBurst(bandwidthBurst);
        detailsStatus.setObservedBandwidth(observedBandwidth);
        detailsStatus.setAdvertisedBandwidth(advertisedBandwidth);
        detailsStatus.setExitPolicy(descriptor.getExitPolicyLines());
        detailsStatus.setContact(descriptor.getContact());
        detailsStatus.setPlatform(descriptor.getPlatform());
        if (descriptor.getFamilyEntries() != null) {
            TreeSet<String> declaredFamily = new TreeSet<String>();
            for (String familyMember : descriptor.getFamilyEntries()) {
                if (familyMember.startsWith("$") && familyMember.length() >= 41) {
                    declaredFamily.add(familyMember.substring(1, 41).toUpperCase());
                    continue;
                }
                declaredFamily.add(familyMember);
            }
            this.declaredFamilies.put(fingerprint, declaredFamily);
        }
        if (descriptor.getIpv6DefaultPolicy() != null && (descriptor.getIpv6DefaultPolicy().equals("accept") || descriptor.getIpv6DefaultPolicy().equals("reject")) && descriptor.getIpv6PortList() != null) {
            HashMap<String, List<String>> exitPolicyV6Summary = new HashMap<String, List<String>>();
            List<String> portsOrPortRanges = Arrays.asList(descriptor.getIpv6PortList().split(","));
            exitPolicyV6Summary.put(descriptor.getIpv6DefaultPolicy(), portsOrPortRanges);
            detailsStatus.setExitPolicyV6Summary(exitPolicyV6Summary);
        }
        detailsStatus.setHibernating(descriptor.isHibernating() ? Boolean.valueOf(true) : null);
        this.documentStore.store(detailsStatus, fingerprint);
    }

    private void processExitList(ExitList exitList) {
        for (ExitList.Entry exitListEntry : exitList.getEntries()) {
            String fingerprint = exitListEntry.getFingerprint();
            for (Map.Entry<String, Long> exitAddressScanMillis : exitListEntry.getExitAddresses().entrySet()) {
                long scanMillis = exitAddressScanMillis.getValue();
                if (scanMillis < this.now - 86400000L) continue;
                if (!this.exitListEntries.containsKey(fingerprint)) {
                    this.exitListEntries.put(fingerprint, new HashMap());
                }
                String exitAddress = exitAddressScanMillis.getKey();
                if (this.exitListEntries.get(fingerprint).containsKey(exitAddress) && this.exitListEntries.get(fingerprint).get(exitAddress) >= scanMillis) continue;
                this.exitListEntries.get(fingerprint).put(exitAddress, scanMillis);
            }
        }
    }

    private void processRelayNetworkStatusConsensus(RelayNetworkStatusConsensus consensus) {
        long validAfterMillis = consensus.getValidAfterMillis();
        if (validAfterMillis > this.relaysLastValidAfterMillis) {
            this.relaysLastValidAfterMillis = validAfterMillis;
        }
        HashSet<String> recommendedVersions = null;
        if (consensus.getRecommendedServerVersions() != null) {
            recommendedVersions = new HashSet<String>();
            for (String string : consensus.getRecommendedServerVersions()) {
                recommendedVersions.add("Tor " + string);
            }
        }
        for (Map.Entry entry : consensus.getStatusEntries().entrySet()) {
            String fingerprint = (String)entry.getKey();
            NetworkStatusEntry entry2 = (NetworkStatusEntry)entry.getValue();
            NodeStatus nodeStatus = (NodeStatus)this.knownNodes.get(fingerprint);
            if (nodeStatus == null) {
                nodeStatus = new NodeStatus(fingerprint);
                this.knownNodes.put(fingerprint, nodeStatus);
            }
            String address = entry2.getAddress();
            int orPort = entry2.getOrPort();
            int dirPort = entry2.getDirPort();
            TreeSet<String> orAddressesAndPorts = new TreeSet<String>(entry2.getOrAddresses());
            nodeStatus.addLastAddresses(validAfterMillis, address, orPort, dirPort, orAddressesAndPorts);
            if (nodeStatus.getFirstSeenMillis() == 0L || validAfterMillis < nodeStatus.getFirstSeenMillis()) {
                nodeStatus.setFirstSeenMillis(validAfterMillis);
            }
            if (validAfterMillis > nodeStatus.getLastSeenMillis()) {
                nodeStatus.setLastSeenMillis(validAfterMillis);
                nodeStatus.setRelay(true);
                nodeStatus.setNickname(entry2.getNickname());
                nodeStatus.setAddress(address);
                nodeStatus.setOrAddressesAndPorts(orAddressesAndPorts);
                nodeStatus.setOrPort(orPort);
                nodeStatus.setDirPort(dirPort);
                nodeStatus.setRelayFlags(entry2.getFlags());
                nodeStatus.setConsensusWeight(entry2.getBandwidth());
                nodeStatus.setDefaultPolicy(entry2.getDefaultPolicy());
                nodeStatus.setPortList(entry2.getPortList());
                nodeStatus.setRecommendedVersion(recommendedVersions == null || entry2.getVersion() == null ? null : Boolean.valueOf(recommendedVersions.contains(entry2.getVersion())));
            }
            if (entry2.getUnmeasured()) {
                if (this.lastSeenUnmeasured.containsKey(fingerprint) && this.lastSeenUnmeasured.get(fingerprint) >= validAfterMillis) continue;
                this.lastSeenUnmeasured.put(fingerprint, validAfterMillis);
                continue;
            }
            if (consensus.getConsensusMethod() < 17 || this.lastSeenMeasured.containsKey(fingerprint) && this.lastSeenMeasured.get(fingerprint) >= validAfterMillis) continue;
            this.lastSeenMeasured.put(fingerprint, validAfterMillis);
        }
        ++this.relayConsensusesProcessed;
        if (this.relaysLastValidAfterMillis == validAfterMillis) {
            this.lastBandwidthWeights = consensus.getBandwidthWeights();
        }
    }

    private void processBridgeServerDescriptor(ServerDescriptor descriptor) {
        String fingerprint = descriptor.getFingerprint();
        DetailsStatus detailsStatus = this.documentStore.retrieve(DetailsStatus.class, true, fingerprint);
        if (detailsStatus == null) {
            detailsStatus = new DetailsStatus();
        } else if (detailsStatus.getDescPublished() != null && detailsStatus.getDescPublished() >= descriptor.getPublishedMillis()) {
            return;
        }
        long lastRestartedMillis = descriptor.getPublishedMillis() - descriptor.getUptime() * 1000L;
        int advertisedBandwidth = Math.min(descriptor.getBandwidthRate(), Math.min(descriptor.getBandwidthBurst(), descriptor.getBandwidthObserved()));
        detailsStatus.setDescPublished(descriptor.getPublishedMillis());
        detailsStatus.setLastRestarted(lastRestartedMillis);
        detailsStatus.setAdvertisedBandwidth(advertisedBandwidth);
        detailsStatus.setPlatform(descriptor.getPlatform());
        this.documentStore.store(detailsStatus, fingerprint);
    }

    private void processBridgeExtraInfoDescriptor(ExtraInfoDescriptor descriptor) {
        String fingerprint = descriptor.getFingerprint();
        DetailsStatus detailsStatus = this.documentStore.retrieve(DetailsStatus.class, true, fingerprint);
        if (detailsStatus == null) {
            detailsStatus = new DetailsStatus();
        } else if (null == detailsStatus.getExtraInfoDescPublished() || descriptor.getPublishedMillis() > detailsStatus.getExtraInfoDescPublished()) {
            detailsStatus.setExtraInfoDescPublished(descriptor.getPublishedMillis());
            detailsStatus.setTransports(descriptor.getTransports());
            this.documentStore.store(detailsStatus, fingerprint);
        }
    }

    private void processBridgeNetworkStatus(BridgeNetworkStatus status) {
        long publishedMillis = status.getPublishedMillis();
        if (publishedMillis > this.bridgesLastPublishedMillis) {
            this.bridgesLastPublishedMillis = publishedMillis;
        }
        for (Map.Entry<String, NetworkStatusEntry> e : status.getStatusEntries().entrySet()) {
            String fingerprint = e.getKey();
            NetworkStatusEntry entry = e.getValue();
            NodeStatus nodeStatus = (NodeStatus)this.knownNodes.get(fingerprint);
            if (nodeStatus == null) {
                nodeStatus = new NodeStatus(fingerprint);
                this.knownNodes.put(fingerprint, nodeStatus);
            }
            if (nodeStatus.getFirstSeenMillis() == 0L || publishedMillis < nodeStatus.getFirstSeenMillis()) {
                nodeStatus.setFirstSeenMillis(publishedMillis);
            }
            if (publishedMillis <= nodeStatus.getLastSeenMillis()) continue;
            nodeStatus.setRelay(false);
            nodeStatus.setNickname(entry.getNickname());
            nodeStatus.setAddress(entry.getAddress());
            nodeStatus.setOrAddressesAndPorts(new TreeSet<String>(entry.getOrAddresses()));
            nodeStatus.setOrPort(entry.getOrPort());
            nodeStatus.setDirPort(entry.getDirPort());
            nodeStatus.setRelayFlags(entry.getFlags());
            nodeStatus.setLastSeenMillis(publishedMillis);
        }
        ++this.bridgeStatusesProcessed;
    }

    @Override
    public void updateStatuses() {
        this.readNodeStatuses();
        this.log.info("Read node statuses");
        this.startReverseDomainNameLookups();
        this.log.info("Started reverse domain name lookups");
        this.lookUpCitiesAndASes();
        this.log.info("Looked up cities and ASes");
        this.calculatePathSelectionProbabilities();
        this.log.info("Calculated path selection probabilities");
        this.computeEffectiveAndExtendedFamilies();
        this.log.info("Computed effective and extended families");
        this.finishReverseDomainNameLookups();
        this.log.info("Finished reverse domain name lookups");
        this.updateNodeDetailsStatuses();
        this.log.info("Updated node and details statuses");
    }

    private void readNodeStatuses() {
        NodeStatus nodeStatus;
        String fingerprint;
        SortedSet<String> previouslyKnownNodes = this.documentStore.list(NodeStatus.class);
        long previousRelaysLastValidAfterMillis = -1L;
        long previousBridgesLastValidAfterMillis = -1L;
        for (String fingerprint2 : previouslyKnownNodes) {
            NodeStatus nodeStatus2 = this.documentStore.retrieve(NodeStatus.class, true, fingerprint2);
            if (nodeStatus2.isRelay() && nodeStatus2.getLastSeenMillis() > previousRelaysLastValidAfterMillis) {
                previousRelaysLastValidAfterMillis = nodeStatus2.getLastSeenMillis();
                continue;
            }
            if (nodeStatus2.isRelay() || nodeStatus2.getLastSeenMillis() <= previousBridgesLastValidAfterMillis) continue;
            previousBridgesLastValidAfterMillis = nodeStatus2.getLastSeenMillis();
        }
        if (previousRelaysLastValidAfterMillis > this.relaysLastValidAfterMillis) {
            this.relaysLastValidAfterMillis = previousRelaysLastValidAfterMillis;
        }
        if (previousBridgesLastValidAfterMillis > this.bridgesLastPublishedMillis) {
            this.bridgesLastPublishedMillis = previousBridgesLastValidAfterMillis;
        }
        long cutoff = Math.max(this.relaysLastValidAfterMillis, this.bridgesLastPublishedMillis) - 604800000L;
        for (Map.Entry<String, NodeStatus> e : this.knownNodes.entrySet()) {
            fingerprint = e.getKey();
            nodeStatus = e.getValue();
            if (!nodeStatus.isRelay() || nodeStatus.getLastSeenMillis() < cutoff) continue;
            this.currentRelays.add(fingerprint);
            if (nodeStatus.getLastSeenMillis() != this.relaysLastValidAfterMillis) continue;
            this.runningRelays.add(fingerprint);
        }
        for (String fingerprint3 : previouslyKnownNodes) {
            NodeStatus nodeStatus3 = this.documentStore.retrieve(NodeStatus.class, true, fingerprint3);
            NodeStatus updatedNodeStatus = null;
            if (this.knownNodes.containsKey(fingerprint3)) {
                updatedNodeStatus = (NodeStatus)this.knownNodes.get(fingerprint3);
                String address = nodeStatus3.getAddress();
                if (address.equals(updatedNodeStatus.getAddress())) {
                    updatedNodeStatus.setLastRdnsLookup(nodeStatus3.getLastRdnsLookup());
                }
                int orPort = nodeStatus3.getOrPort();
                int dirPort = nodeStatus3.getDirPort();
                SortedSet<String> orAddressesAndPorts = nodeStatus3.getOrAddressesAndPorts();
                updatedNodeStatus.addLastAddresses(nodeStatus3.getLastChangedOrAddressOrPort(), address, orPort, dirPort, orAddressesAndPorts);
                if (nodeStatus3.getLastSeenMillis() > updatedNodeStatus.getLastSeenMillis()) {
                    updatedNodeStatus.setNickname(nodeStatus3.getNickname());
                    updatedNodeStatus.setAddress(address);
                    updatedNodeStatus.setOrAddressesAndPorts(orAddressesAndPorts);
                    updatedNodeStatus.setLastSeenMillis(nodeStatus3.getLastSeenMillis());
                    updatedNodeStatus.setOrPort(orPort);
                    updatedNodeStatus.setDirPort(dirPort);
                    updatedNodeStatus.setRelayFlags(nodeStatus3.getRelayFlags());
                    updatedNodeStatus.setConsensusWeight(nodeStatus3.getConsensusWeight());
                    updatedNodeStatus.setCountryCode(nodeStatus3.getCountryCode());
                    updatedNodeStatus.setDefaultPolicy(nodeStatus3.getDefaultPolicy());
                    updatedNodeStatus.setPortList(nodeStatus3.getPortList());
                    updatedNodeStatus.setAsNumber(nodeStatus3.getAsNumber());
                    updatedNodeStatus.setRecommendedVersion(nodeStatus3.getRecommendedVersion());
                }
                if (nodeStatus3.getFirstSeenMillis() < updatedNodeStatus.getFirstSeenMillis() && nodeStatus3.getFirstSeenMillis() > 0L) {
                    updatedNodeStatus.setFirstSeenMillis(nodeStatus3.getFirstSeenMillis());
                }
                updatedNodeStatus.setDeclaredFamily(nodeStatus3.getDeclaredFamily());
                updatedNodeStatus.setEffectiveFamily(nodeStatus3.getEffectiveFamily());
                updatedNodeStatus.setExtendedFamily(nodeStatus3.getExtendedFamily());
            } else {
                updatedNodeStatus = nodeStatus3;
                this.knownNodes.put(fingerprint3, nodeStatus3);
            }
            if (!updatedNodeStatus.isRelay() || updatedNodeStatus.getLastSeenMillis() < cutoff) continue;
            this.currentRelays.add(fingerprint3);
            if (updatedNodeStatus.getLastSeenMillis() != this.relaysLastValidAfterMillis) continue;
            this.runningRelays.add(fingerprint3);
        }
        for (Map.Entry<String, NodeStatus> e : this.knownNodes.entrySet()) {
            fingerprint = e.getKey();
            if (!this.declaredFamilies.containsKey(fingerprint)) continue;
            nodeStatus = e.getValue();
            nodeStatus.setDeclaredFamily(this.declaredFamilies.get(fingerprint));
        }
        this.declaredFamilies.clear();
    }

    private void startReverseDomainNameLookups() {
        HashMap<String, Long> addressLastLookupTimes = new HashMap<String, Long>();
        for (String fingerprint : this.currentRelays) {
            NodeStatus nodeStatus = (NodeStatus)this.knownNodes.get(fingerprint);
            addressLastLookupTimes.put(nodeStatus.getAddress(), nodeStatus.getLastRdnsLookup());
        }
        this.reverseDomainNameResolver.setAddresses(addressLastLookupTimes);
        this.reverseDomainNameResolver.startReverseDomainNameLookups();
    }

    private void lookUpCitiesAndASes() {
        TreeSet<String> addressStrings = new TreeSet<String>();
        for (String fingerprint : this.currentRelays) {
            NodeStatus nodeStatus = (NodeStatus)this.knownNodes.get(fingerprint);
            addressStrings.add(nodeStatus.getAddress());
        }
        if (addressStrings.isEmpty()) {
            this.log.error("No relay IP addresses to resolve to cities or ASN.");
            return;
        }
        SortedMap<String, LookupResult> lookupResults = this.lookupService.lookup(addressStrings);
        for (String fingerprint : this.currentRelays) {
            NodeStatus nodeStatus = (NodeStatus)this.knownNodes.get(fingerprint);
            LookupResult lookupResult = (LookupResult)lookupResults.get(nodeStatus.getAddress());
            if (lookupResult == null) continue;
            this.geoIpLookupResults.put(fingerprint, lookupResult);
        }
    }

    private void calculatePathSelectionProbabilities() {
        boolean consensusContainsBandwidthWeights = false;
        double wgg = 0.0;
        double wgd = 0.0;
        double wmg = 0.0;
        double wmm = 0.0;
        double wme = 0.0;
        double wmd = 0.0;
        double wee = 0.0;
        double wed = 0.0;
        if (this.lastBandwidthWeights != null) {
            TreeSet<String> weightKeys = new TreeSet<String>(Arrays.asList("Wgg,Wgd,Wmg,Wmm,Wme,Wmd,Wee,Wed".split(",")));
            weightKeys.removeAll(this.lastBandwidthWeights.keySet());
            if (weightKeys.isEmpty()) {
                consensusContainsBandwidthWeights = true;
                wgg = (double)((Integer)this.lastBandwidthWeights.get("Wgg")).intValue() / 10000.0;
                wgd = (double)((Integer)this.lastBandwidthWeights.get("Wgd")).intValue() / 10000.0;
                wmg = (double)((Integer)this.lastBandwidthWeights.get("Wmg")).intValue() / 10000.0;
                wmm = (double)((Integer)this.lastBandwidthWeights.get("Wmm")).intValue() / 10000.0;
                wme = (double)((Integer)this.lastBandwidthWeights.get("Wme")).intValue() / 10000.0;
                wmd = (double)((Integer)this.lastBandwidthWeights.get("Wmd")).intValue() / 10000.0;
                wee = (double)((Integer)this.lastBandwidthWeights.get("Wee")).intValue() / 10000.0;
                wed = (double)((Integer)this.lastBandwidthWeights.get("Wed")).intValue() / 10000.0;
            }
        } else {
            this.log.debug("Not calculating new path selection probabilities, because we could not determine most recent Wxx parameter values, probably because we didn't parse a consensus in this execution.");
            return;
        }
        TreeMap<String, Double> consensusWeights = new TreeMap<String, Double>();
        TreeMap<String, Double> guardWeights = new TreeMap<String, Double>();
        TreeMap<String, Double> middleWeights = new TreeMap<String, Double>();
        TreeMap<String, Double> exitWeights = new TreeMap<String, Double>();
        double totalConsensusWeight = 0.0;
        double totalGuardWeight = 0.0;
        double totalMiddleWeight = 0.0;
        double totalExitWeight = 0.0;
        for (String fingerprint : this.runningRelays) {
            NodeStatus nodeStatus = (NodeStatus)this.knownNodes.get(fingerprint);
            boolean isExit = nodeStatus.getRelayFlags().contains("Exit") && !nodeStatus.getRelayFlags().contains("BadExit");
            boolean isGuard = nodeStatus.getRelayFlags().contains("Guard");
            double consensusWeight = nodeStatus.getConsensusWeight();
            consensusWeights.put(fingerprint, consensusWeight);
            totalConsensusWeight += consensusWeight;
            if (!consensusContainsBandwidthWeights) continue;
            double guardWeight = consensusWeight;
            double middleWeight = consensusWeight;
            double exitWeight = consensusWeight;
            if (isGuard && isExit) {
                guardWeight *= wgd;
                middleWeight *= wmd;
                exitWeight *= wed;
            } else if (isGuard) {
                guardWeight *= wgg;
                middleWeight *= wmg;
                exitWeight = 0.0;
            } else if (isExit) {
                guardWeight = 0.0;
                middleWeight *= wme;
                exitWeight *= wee;
            } else {
                guardWeight = 0.0;
                middleWeight *= wmm;
                exitWeight = 0.0;
            }
            guardWeights.put(fingerprint, guardWeight);
            middleWeights.put(fingerprint, middleWeight);
            exitWeights.put(fingerprint, exitWeight);
            totalGuardWeight += guardWeight;
            totalMiddleWeight += middleWeight;
            totalExitWeight += exitWeight;
        }
        for (String fingerprint : this.runningRelays) {
            if (consensusWeights.containsKey(fingerprint)) {
                this.consensusWeightFractions.put(fingerprint, Float.valueOf((float)((Double)consensusWeights.get(fingerprint) / totalConsensusWeight)));
            }
            if (guardWeights.containsKey(fingerprint)) {
                this.guardProbabilities.put(fingerprint, Float.valueOf((float)((Double)guardWeights.get(fingerprint) / totalGuardWeight)));
            }
            if (middleWeights.containsKey(fingerprint)) {
                this.middleProbabilities.put(fingerprint, Float.valueOf((float)((Double)middleWeights.get(fingerprint) / totalMiddleWeight)));
            }
            if (!exitWeights.containsKey(fingerprint)) continue;
            this.exitProbabilities.put(fingerprint, Float.valueOf((float)((Double)exitWeights.get(fingerprint) / totalExitWeight)));
        }
    }

    private void computeEffectiveAndExtendedFamilies() {
        TreeMap<String, SortedSet<String>> declaredFamilies = new TreeMap<String, SortedSet<String>>();
        for (String string : this.currentRelays) {
            NodeStatus nodeStatus = (NodeStatus)this.knownNodes.get(string);
            if (nodeStatus == null || nodeStatus.getDeclaredFamily() == null || nodeStatus.getDeclaredFamily().isEmpty()) continue;
            declaredFamilies.put(string, nodeStatus.getDeclaredFamily());
        }
        TreeMap effectiveFamilies = new TreeMap();
        for (Map.Entry entry : declaredFamilies.entrySet()) {
            String fingerprint = (String)entry.getKey();
            SortedSet declaredFamily = (SortedSet)entry.getValue();
            TreeSet<String> effectiveFamily = new TreeSet<String>();
            for (String declaredFamilyMember : declaredFamily) {
                if (!declaredFamilies.containsKey(declaredFamilyMember) || !((SortedSet)declaredFamilies.get(declaredFamilyMember)).contains(fingerprint)) continue;
                effectiveFamily.add(declaredFamilyMember);
            }
            if (effectiveFamily.isEmpty()) continue;
            effectiveFamilies.put(fingerprint, effectiveFamily);
        }
        TreeMap treeMap = new TreeMap();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String fingerprint : effectiveFamilies.keySet()) {
            if (treeSet.contains(fingerprint)) continue;
            TreeSet<String> toVisit = new TreeSet<String>();
            toVisit.add(fingerprint);
            TreeSet<String> extendedFamily = new TreeSet<String>();
            while (!toVisit.isEmpty()) {
                String visiting = (String)toVisit.first();
                toVisit.remove(visiting);
                extendedFamily.add(visiting);
                SortedSet members = (SortedSet)effectiveFamilies.get(visiting);
                if (members != null) {
                    for (String member : members) {
                        if (toVisit.contains(member) || treeSet.contains(member)) continue;
                        toVisit.add(member);
                    }
                }
                treeSet.add(visiting);
            }
            if (extendedFamily.size() <= 1) continue;
            for (String member : extendedFamily) {
                TreeSet extendedFamilyWithoutMember = new TreeSet(extendedFamily);
                extendedFamilyWithoutMember.remove(member);
                treeMap.put(member, extendedFamilyWithoutMember);
            }
        }
        for (String fingerprint : this.currentRelays) {
            NodeStatus nodeStatus = (NodeStatus)this.knownNodes.get(fingerprint);
            if (effectiveFamilies.containsKey(fingerprint) || treeMap.containsKey(fingerprint)) {
                nodeStatus.setEffectiveFamily((SortedSet)effectiveFamilies.get(fingerprint));
                nodeStatus.setExtendedFamily((SortedSet)treeMap.get(fingerprint));
                continue;
            }
            if ((nodeStatus.getEffectiveFamily() == null || nodeStatus.getEffectiveFamily().isEmpty()) && (nodeStatus.getIndirectFamily() == null || nodeStatus.getIndirectFamily().isEmpty())) continue;
            nodeStatus.setEffectiveFamily(null);
            nodeStatus.setExtendedFamily(null);
        }
    }

    private void finishReverseDomainNameLookups() {
        this.reverseDomainNameResolver.finishReverseDomainNameLookups();
        this.startedRdnsLookups = this.reverseDomainNameResolver.getLookupStartMillis();
        Map<String, String> lookupResults = this.reverseDomainNameResolver.getLookupResults();
        for (String fingerprint : this.currentRelays) {
            NodeStatus nodeStatus = (NodeStatus)this.knownNodes.get(fingerprint);
            String hostName = lookupResults.get(nodeStatus.getAddress());
            if (hostName == null) continue;
            this.rdnsLookupResults.put(fingerprint, hostName);
        }
    }

    private void updateNodeDetailsStatuses() {
        for (Map.Entry<String, NodeStatus> entry : this.knownNodes.entrySet()) {
            String fingerprint = entry.getKey();
            NodeStatus nodeStatus = entry.getValue();
            DetailsStatus detailsStatus = this.documentStore.retrieve(DetailsStatus.class, true, fingerprint);
            if (detailsStatus == null) {
                detailsStatus = new DetailsStatus();
            }
            nodeStatus.setContact(detailsStatus.getContact());
            HashMap<String, Long> exitAddresses = new HashMap<String, Long>();
            if (detailsStatus.getExitAddresses() != null) {
                for (Map.Entry<String, Long> e : detailsStatus.getExitAddresses().entrySet()) {
                    if (e.getValue() < this.now - 86400000L) continue;
                    exitAddresses.put(e.getKey(), e.getValue());
                }
            }
            if (this.exitListEntries.containsKey(fingerprint)) {
                for (Map.Entry<String, Long> e : this.exitListEntries.get(fingerprint).entrySet()) {
                    String exitAddress = e.getKey();
                    long scanMillis = e.getValue();
                    if (exitAddresses.containsKey(exitAddress) && (Long)exitAddresses.get(exitAddress) >= scanMillis) continue;
                    exitAddresses.put(exitAddress, scanMillis);
                }
            }
            detailsStatus.setExitAddresses(exitAddresses);
            TreeSet<String> exitAddressesWithoutOrAddresses = new TreeSet<String>(exitAddresses.keySet());
            exitAddressesWithoutOrAddresses.removeAll(nodeStatus.getOrAddresses());
            nodeStatus.setExitAddresses(exitAddressesWithoutOrAddresses);
            detailsStatus.setAllegedFamily(nodeStatus.getAllegedFamily());
            detailsStatus.setEffectiveFamily(nodeStatus.getEffectiveFamily());
            detailsStatus.setIndirectFamily(nodeStatus.getIndirectFamily());
            if (this.geoIpLookupResults.containsKey(fingerprint)) {
                LookupResult lookupResult = (LookupResult)this.geoIpLookupResults.get(fingerprint);
                detailsStatus.setCountryCode(lookupResult.getCountryCode());
                detailsStatus.setCountryName(lookupResult.getCountryName());
                detailsStatus.setRegionName(lookupResult.getRegionName());
                detailsStatus.setCityName(lookupResult.getCityName());
                detailsStatus.setLatitude(lookupResult.getLatitude());
                detailsStatus.setLongitude(lookupResult.getLongitude());
                detailsStatus.setAsNumber(lookupResult.getAsNumber());
                detailsStatus.setAsName(lookupResult.getAsName());
                nodeStatus.setCountryCode(lookupResult.getCountryCode());
                nodeStatus.setAsNumber(lookupResult.getAsNumber());
            }
            if (this.consensusWeightFractions.containsKey(fingerprint)) {
                detailsStatus.setConsensusWeightFraction((Float)this.consensusWeightFractions.get(fingerprint));
            }
            if (this.guardProbabilities.containsKey(fingerprint)) {
                detailsStatus.setGuardProbability((Float)this.guardProbabilities.get(fingerprint));
            }
            if (this.middleProbabilities.containsKey(fingerprint)) {
                detailsStatus.setMiddleProbability((Float)this.middleProbabilities.get(fingerprint));
            }
            if (this.exitProbabilities.containsKey(fingerprint)) {
                detailsStatus.setExitProbability((Float)this.exitProbabilities.get(fingerprint));
            }
            if (this.rdnsLookupResults.containsKey(fingerprint)) {
                String hostName = (String)this.rdnsLookupResults.get(fingerprint);
                detailsStatus.setHostName(hostName);
                nodeStatus.setLastRdnsLookup(this.startedRdnsLookups);
            }
            if (detailsStatus.getLastSeenMillis() < nodeStatus.getLastSeenMillis()) {
                if (this.lastSeenMeasured.containsKey(fingerprint)) {
                    if (this.lastSeenUnmeasured.containsKey(fingerprint) && this.lastSeenUnmeasured.get(fingerprint) > this.lastSeenMeasured.get(fingerprint)) {
                        detailsStatus.setMeasured(false);
                    } else {
                        detailsStatus.setMeasured(true);
                    }
                } else if (this.lastSeenUnmeasured.containsKey(fingerprint)) {
                    detailsStatus.setMeasured(false);
                }
            }
            detailsStatus.setRelay(nodeStatus.isRelay());
            detailsStatus.setRunning(nodeStatus.getLastSeenMillis() == (nodeStatus.isRelay() ? this.relaysLastValidAfterMillis : this.bridgesLastPublishedMillis));
            detailsStatus.setNickname(nodeStatus.getNickname());
            detailsStatus.setAddress(nodeStatus.getAddress());
            detailsStatus.setOrAddressesAndPorts(nodeStatus.getOrAddressesAndPorts());
            detailsStatus.setFirstSeenMillis(nodeStatus.getFirstSeenMillis());
            detailsStatus.setLastSeenMillis(nodeStatus.getLastSeenMillis());
            detailsStatus.setOrPort(nodeStatus.getOrPort());
            detailsStatus.setDirPort(nodeStatus.getDirPort());
            detailsStatus.setRelayFlags(nodeStatus.getRelayFlags());
            detailsStatus.setConsensusWeight(nodeStatus.getConsensusWeight());
            detailsStatus.setDefaultPolicy(nodeStatus.getDefaultPolicy());
            detailsStatus.setPortList(nodeStatus.getPortList());
            detailsStatus.setRecommendedVersion(nodeStatus.getRecommendedVersion());
            detailsStatus.setLastChangedOrAddressOrPort(nodeStatus.getLastChangedOrAddressOrPort());
            this.documentStore.store(detailsStatus, fingerprint);
            this.documentStore.store(nodeStatus, fingerprint);
        }
    }

    @Override
    public String getStatsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    " + FormattingUtils.formatDecimalNumber(this.relayConsensusesProcessed) + " relay consensuses processed\n");
        sb.append("    " + FormattingUtils.formatDecimalNumber(this.bridgeStatusesProcessed) + " bridge statuses processed\n");
        return sb.toString();
    }
}

