/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.server;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.onionoo.docs.DocumentStore;
import org.torproject.onionoo.docs.DocumentStoreFactory;
import org.torproject.onionoo.docs.SummaryDocument;
import org.torproject.onionoo.docs.UpdateStatus;
import org.torproject.onionoo.server.NodeIndex;
import org.torproject.onionoo.server.NodeIndexerFactory;
import org.torproject.onionoo.util.Time;
import org.torproject.onionoo.util.TimeFactory;

public class NodeIndexer
implements ServletContextListener,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(NodeIndexer.class);
    private long lastIndexed = -1L;
    private NodeIndex latestNodeIndex = null;
    private Thread nodeIndexerThread = null;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_DAY = 86400000L;

    public void contextInitialized(ServletContextEvent contextEvent) {
        ServletContext servletContext = contextEvent.getServletContext();
        File outDir = new File(servletContext.getInitParameter("outDir"));
        if (!outDir.exists() || !outDir.isDirectory()) {
            log.error("\n\n\tOut-dir not found! Expected directory: " + outDir + "\n\tVerify the configuration in ./etc/web.xml.template");
            System.exit(1);
        }
        DocumentStore documentStore = DocumentStoreFactory.getDocumentStore();
        documentStore.setOutDir(outDir);
        NodeIndexerFactory.setNodeIndexer(this);
        this.startIndexing();
    }

    public void contextDestroyed(ServletContextEvent contextEvent) {
        this.stopIndexing();
    }

    public synchronized long getLastIndexed(long timeoutMillis) {
        if (this.lastIndexed == -1L && this.nodeIndexerThread != null && timeoutMillis > 0L) {
            try {
                this.wait(timeoutMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.lastIndexed;
    }

    public synchronized NodeIndex getLatestNodeIndex(long timeoutMillis) {
        if (this.latestNodeIndex == null && this.nodeIndexerThread != null && timeoutMillis > 0L) {
            try {
                this.wait(timeoutMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.latestNodeIndex;
    }

    public synchronized void startIndexing() {
        if (this.nodeIndexerThread == null) {
            this.nodeIndexerThread = new Thread(this);
            this.nodeIndexerThread.setDaemon(true);
            this.nodeIndexerThread.start();
        }
    }

    @Override
    public void run() {
        while (this.nodeIndexerThread != null) {
            this.indexNodeStatuses();
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void stopIndexing() {
        Thread indexerThread = this.nodeIndexerThread;
        this.nodeIndexerThread = null;
        indexerThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexNodeStatuses() {
        String flagLowerCase;
        String fingerprint;
        long updateStatusMillis = -1L;
        DocumentStore documentStore = DocumentStoreFactory.getDocumentStore();
        UpdateStatus updateStatus = documentStore.retrieve(UpdateStatus.class, true);
        if (updateStatus != null) {
            updateStatusMillis = updateStatus.getUpdatedMillis();
        }
        NodeIndexer nodeIndexer = this;
        synchronized (nodeIndexer) {
            if (updateStatusMillis <= this.lastIndexed) {
                return;
            }
        }
        documentStore.invalidateDocumentCache();
        HashMap<String, SummaryDocument> newRelayFingerprintSummaryLines = new HashMap<String, SummaryDocument>();
        HashMap<String, SummaryDocument> newBridgeFingerprintSummaryLines = new HashMap<String, SummaryDocument>();
        HashMap<String, Set<String>> newRelaysByCountryCode = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newRelaysByAsNumber = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newRelaysByFlag = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newBridgesByFlag = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newRelaysByContact = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newRelaysByFamily = new HashMap<String, Set<String>>();
        TreeMap<Integer, Set<String>> newRelaysByFirstSeenDays = new TreeMap<Integer, Set<String>>();
        TreeMap<Integer, Set<String>> newBridgesByFirstSeenDays = new TreeMap<Integer, Set<String>>();
        TreeMap<Integer, Set<String>> newRelaysByLastSeenDays = new TreeMap<Integer, Set<String>>();
        TreeMap<Integer, Set<String>> newBridgesByLastSeenDays = new TreeMap<Integer, Set<String>>();
        HashSet currentRelays = new HashSet();
        HashSet currentBridges = new HashSet();
        SortedSet<String> fingerprints = documentStore.list(SummaryDocument.class);
        long relaysLastValidAfterMillis = 0L;
        long bridgesLastPublishedMillis = 0L;
        for (String fingerprint2 : fingerprints) {
            SummaryDocument node = documentStore.retrieve(SummaryDocument.class, true, fingerprint2);
            if (node.isRelay()) {
                relaysLastValidAfterMillis = Math.max(relaysLastValidAfterMillis, node.getLastSeenMillis());
                currentRelays.add(node);
                continue;
            }
            bridgesLastPublishedMillis = Math.max(bridgesLastPublishedMillis, node.getLastSeenMillis());
            currentBridges.add(node);
        }
        Time time = TimeFactory.getTime();
        TreeMap<String, SortedSet<String>> computedEffectiveFamilies = new TreeMap<String, SortedSet<String>>();
        for (SummaryDocument nodeIndexer2 : currentRelays) {
            int daysSinceFirstSeen;
            fingerprint = nodeIndexer2.getFingerprint().toUpperCase();
            String hashedFingerprint = nodeIndexer2.getHashedFingerprint().toUpperCase();
            newRelayFingerprintSummaryLines.put(fingerprint, nodeIndexer2);
            newRelayFingerprintSummaryLines.put(hashedFingerprint, nodeIndexer2);
            if (nodeIndexer2.getCountryCode() != null) {
                String countryCode = nodeIndexer2.getCountryCode();
                if (!newRelaysByCountryCode.containsKey(countryCode)) {
                    newRelaysByCountryCode.put(countryCode, new HashSet());
                }
                ((Set)newRelaysByCountryCode.get(countryCode)).add(fingerprint);
                ((Set)newRelaysByCountryCode.get(countryCode)).add(hashedFingerprint);
            }
            if (nodeIndexer2.getAsNumber() != null) {
                String asNumber = nodeIndexer2.getAsNumber();
                if (!newRelaysByAsNumber.containsKey(asNumber)) {
                    newRelaysByAsNumber.put(asNumber, new HashSet());
                }
                ((Set)newRelaysByAsNumber.get(asNumber)).add(fingerprint);
                ((Set)newRelaysByAsNumber.get(asNumber)).add(hashedFingerprint);
            }
            for (String flag : nodeIndexer2.getRelayFlags()) {
                flagLowerCase = flag.toLowerCase();
                if (!newRelaysByFlag.containsKey(flagLowerCase)) {
                    newRelaysByFlag.put(flagLowerCase, new HashSet());
                }
                ((Set)newRelaysByFlag.get(flagLowerCase)).add(fingerprint);
                ((Set)newRelaysByFlag.get(flagLowerCase)).add(hashedFingerprint);
            }
            if (nodeIndexer2.getFamilyFingerprints() != null && !nodeIndexer2.getFamilyFingerprints().isEmpty()) {
                computedEffectiveFamilies.put(fingerprint, nodeIndexer2.getFamilyFingerprints());
            }
            if (nodeIndexer2.getEffectiveFamily() != null) {
                newRelaysByFamily.put(fingerprint, nodeIndexer2.getEffectiveFamily());
            }
            if (!newRelaysByFirstSeenDays.containsKey(daysSinceFirstSeen = (int)((time.currentTimeMillis() - nodeIndexer2.getFirstSeenMillis()) / 86400000L))) {
                newRelaysByFirstSeenDays.put(daysSinceFirstSeen, new HashSet());
            }
            ((Set)newRelaysByFirstSeenDays.get(daysSinceFirstSeen)).add(fingerprint);
            ((Set)newRelaysByFirstSeenDays.get(daysSinceFirstSeen)).add(hashedFingerprint);
            int daysSinceLastSeen = (int)((time.currentTimeMillis() - nodeIndexer2.getLastSeenMillis()) / 86400000L);
            if (!newRelaysByLastSeenDays.containsKey(daysSinceLastSeen)) {
                newRelaysByLastSeenDays.put(daysSinceLastSeen, new HashSet());
            }
            ((Set)newRelaysByLastSeenDays.get(daysSinceLastSeen)).add(fingerprint);
            ((Set)newRelaysByLastSeenDays.get(daysSinceLastSeen)).add(hashedFingerprint);
            String contact = nodeIndexer2.getContact();
            if (!newRelaysByContact.containsKey(contact)) {
                newRelaysByContact.put(contact, new HashSet());
            }
            ((Set)newRelaysByContact.get(contact)).add(fingerprint);
            ((Set)newRelaysByContact.get(contact)).add(hashedFingerprint);
        }
        for (Map.Entry entry : computedEffectiveFamilies.entrySet()) {
            fingerprint = (String)entry.getKey();
            HashSet<String> inMutualFamilyRelation = new HashSet<String>();
            for (String otherFingerprint : (Set)entry.getValue()) {
                if (!computedEffectiveFamilies.containsKey(otherFingerprint) || !((Set)computedEffectiveFamilies.get(otherFingerprint)).contains(fingerprint)) continue;
                inMutualFamilyRelation.add(otherFingerprint);
            }
            newRelaysByFamily.put(fingerprint, inMutualFamilyRelation);
        }
        for (SummaryDocument summaryDocument : currentBridges) {
            String hashedFingerprint = summaryDocument.getFingerprint().toUpperCase();
            String hashedHashedFingerprint = summaryDocument.getHashedFingerprint().toUpperCase();
            newBridgeFingerprintSummaryLines.put(hashedFingerprint, summaryDocument);
            newBridgeFingerprintSummaryLines.put(hashedHashedFingerprint, summaryDocument);
            for (String flag : summaryDocument.getRelayFlags()) {
                flagLowerCase = flag.toLowerCase();
                if (!newBridgesByFlag.containsKey(flagLowerCase)) {
                    newBridgesByFlag.put(flagLowerCase, new HashSet());
                }
                ((Set)newBridgesByFlag.get(flagLowerCase)).add(hashedFingerprint);
                ((Set)newBridgesByFlag.get(flagLowerCase)).add(hashedHashedFingerprint);
            }
            int daysSinceFirstSeen = (int)((time.currentTimeMillis() - summaryDocument.getFirstSeenMillis()) / 86400000L);
            if (!newBridgesByFirstSeenDays.containsKey(daysSinceFirstSeen)) {
                newBridgesByFirstSeenDays.put(daysSinceFirstSeen, new HashSet());
            }
            ((Set)newBridgesByFirstSeenDays.get(daysSinceFirstSeen)).add(hashedFingerprint);
            ((Set)newBridgesByFirstSeenDays.get(daysSinceFirstSeen)).add(hashedHashedFingerprint);
            int daysSinceLastSeen = (int)((time.currentTimeMillis() - summaryDocument.getLastSeenMillis()) / 86400000L);
            if (!newBridgesByLastSeenDays.containsKey(daysSinceLastSeen)) {
                newBridgesByLastSeenDays.put(daysSinceLastSeen, new HashSet());
            }
            ((Set)newBridgesByLastSeenDays.get(daysSinceLastSeen)).add(hashedFingerprint);
            ((Set)newBridgesByLastSeenDays.get(daysSinceLastSeen)).add(hashedHashedFingerprint);
        }
        NodeIndex newNodeIndex = new NodeIndex();
        newNodeIndex.setRelayFingerprintSummaryLines(newRelayFingerprintSummaryLines);
        newNodeIndex.setBridgeFingerprintSummaryLines(newBridgeFingerprintSummaryLines);
        newNodeIndex.setRelaysByCountryCode(newRelaysByCountryCode);
        newNodeIndex.setRelaysByAsNumber(newRelaysByAsNumber);
        newNodeIndex.setRelaysByFlag(newRelaysByFlag);
        newNodeIndex.setBridgesByFlag(newBridgesByFlag);
        newNodeIndex.setRelaysByContact(newRelaysByContact);
        newNodeIndex.setRelaysByFamily(newRelaysByFamily);
        newNodeIndex.setRelaysByFirstSeenDays(newRelaysByFirstSeenDays);
        newNodeIndex.setRelaysByLastSeenDays(newRelaysByLastSeenDays);
        newNodeIndex.setBridgesByFirstSeenDays(newBridgesByFirstSeenDays);
        newNodeIndex.setBridgesByLastSeenDays(newBridgesByLastSeenDays);
        newNodeIndex.setRelaysPublishedMillis(relaysLastValidAfterMillis);
        newNodeIndex.setBridgesPublishedMillis(bridgesLastPublishedMillis);
        NodeIndexer nodeIndexer2 = this;
        synchronized (nodeIndexer2) {
            this.lastIndexed = updateStatusMillis;
            this.latestNodeIndex = newNodeIndex;
            this.notifyAll();
        }
    }
}

