/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.server;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

class MostFrequentString {
    Map<String, Integer> stringFrequencies = new HashMap<String, Integer>();

    MostFrequentString() {
    }

    void addString(String string) {
        if (!this.stringFrequencies.containsKey(string)) {
            this.stringFrequencies.put(string, 1);
        } else {
            this.stringFrequencies.put(string, this.stringFrequencies.get(string) + 1);
        }
    }

    public String toString() {
        TreeMap sortedFrequencies = new TreeMap(Collections.reverseOrder());
        if (this.stringFrequencies.isEmpty()) {
            return "null (0)";
        }
        for (Map.Entry<String, Integer> e : this.stringFrequencies.entrySet()) {
            if (!sortedFrequencies.containsKey(e.getValue())) {
                sortedFrequencies.put(e.getValue(), new TreeSet<String>(Arrays.asList(e.getKey())));
                continue;
            }
            ((SortedSet)sortedFrequencies.get(e.getValue())).add(e.getKey());
        }
        StringBuilder sb = new StringBuilder();
        int stringsToAdd = 3;
        int written = 0;
        for (Map.Entry e : sortedFrequencies.entrySet()) {
            for (String string : (SortedSet)e.getValue()) {
                if (stringsToAdd-- <= 0) continue;
                sb.append((written++ > 0 ? ", " : "") + string + " (" + e.getKey() + ")");
            }
            if (stringsToAdd != 0) continue;
            break;
        }
        return sb.toString();
    }

    void clear() {
        this.stringFrequencies.clear();
    }
}

