/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.docs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.torproject.onionoo.docs.DateTimeHelper;
import org.torproject.onionoo.docs.Document;

public class SummaryDocument
extends Document {
    private boolean t;
    private String f;
    private transient String hashedFingerprint = null;
    private transient String base64Fingerprint = null;
    private transient String[] fingerprintSortedHexBlocks = null;
    private String n;
    private String[] ad;
    private String cc;
    private String as;
    private String fs;
    private String ls;
    private String[] rf;
    private long cw;
    private boolean r;
    private String c;
    private String[] ff;
    private String[] ef;

    public void setRelay(boolean isRelay) {
        this.t = isRelay;
    }

    public boolean isRelay() {
        return this.t;
    }

    public void setFingerprint(String fingerprint) {
        Pattern fingerprintPattern;
        if (fingerprint != null && !(fingerprintPattern = Pattern.compile("^[0-9a-fA-F]{40}$")).matcher(fingerprint).matches()) {
            throw new IllegalArgumentException("Fingerprint '" + fingerprint + "' is not a valid fingerprint.");
        }
        this.f = fingerprint;
        this.hashedFingerprint = null;
        this.base64Fingerprint = null;
        this.fingerprintSortedHexBlocks = null;
    }

    public String getFingerprint() {
        return this.f;
    }

    public String getHashedFingerprint() {
        if (this.hashedFingerprint == null && this.f != null) {
            try {
                this.hashedFingerprint = DigestUtils.sha1Hex(Hex.decodeHex(this.f.toCharArray())).toUpperCase();
            }
            catch (DecoderException decoderException) {
                // empty catch block
            }
        }
        return this.hashedFingerprint;
    }

    public String getBase64Fingerprint() {
        if (this.base64Fingerprint == null && this.f != null) {
            try {
                this.base64Fingerprint = Base64.encodeBase64String(Hex.decodeHex(this.f.toCharArray())).replaceAll("=", "");
            }
            catch (DecoderException decoderException) {
                // empty catch block
            }
        }
        return this.base64Fingerprint;
    }

    public String[] getFingerprintSortedHexBlocks() {
        if (this.fingerprintSortedHexBlocks == null && this.f != null) {
            String fingerprint = this.f.toUpperCase();
            Object[] fingerprintSortedHexBlocks = new String[fingerprint.length() / 4];
            for (int i = 0; i < fingerprint.length(); i += 4) {
                fingerprintSortedHexBlocks[i / 4] = fingerprint.substring(i, Math.min(i + 4, fingerprint.length()));
            }
            Arrays.sort(fingerprintSortedHexBlocks);
            this.fingerprintSortedHexBlocks = fingerprintSortedHexBlocks;
        }
        return this.fingerprintSortedHexBlocks;
    }

    public void setNickname(String nickname) {
        this.n = nickname == null || nickname.equals("Unnamed") ? null : nickname;
    }

    public String getNickname() {
        return this.n == null ? "Unnamed" : this.n;
    }

    public void setAddresses(List<String> addresses) {
        this.ad = this.collectionToStringArray(addresses);
    }

    public List<String> getAddresses() {
        return this.stringArrayToList(this.ad);
    }

    private String[] collectionToStringArray(Collection<String> collection) {
        String[] stringArray = null;
        if (collection != null && !collection.isEmpty()) {
            stringArray = new String[collection.size()];
            int index = 0;
            for (String string : collection) {
                stringArray[index++] = string;
            }
        }
        return stringArray;
    }

    private List<String> stringArrayToList(String[] stringArray) {
        List<String> list = stringArray == null ? new ArrayList<String>() : Arrays.asList(stringArray);
        return list;
    }

    private SortedSet<String> stringArrayToSortedSet(String[] stringArray) {
        TreeSet<String> sortedSet = new TreeSet<String>();
        if (stringArray != null) {
            sortedSet.addAll(Arrays.asList(stringArray));
        }
        return sortedSet;
    }

    public void setCountryCode(String countryCode) {
        this.cc = countryCode;
    }

    public String getCountryCode() {
        return this.cc;
    }

    public void setAsNumber(String asNumber) {
        this.as = asNumber;
    }

    public String getAsNumber() {
        return this.as;
    }

    public void setFirstSeenMillis(long firstSeenMillis) {
        this.fs = DateTimeHelper.format(firstSeenMillis);
    }

    public long getFirstSeenMillis() {
        return DateTimeHelper.parse(this.fs);
    }

    public void setLastSeenMillis(long lastSeenMillis) {
        this.ls = DateTimeHelper.format(lastSeenMillis);
    }

    public long getLastSeenMillis() {
        return DateTimeHelper.parse(this.ls);
    }

    public void setRelayFlags(SortedSet<String> relayFlags) {
        this.rf = this.collectionToStringArray(relayFlags);
    }

    public SortedSet<String> getRelayFlags() {
        return this.stringArrayToSortedSet(this.rf);
    }

    public void setConsensusWeight(long consensusWeight) {
        this.cw = consensusWeight;
    }

    public long getConsensusWeight() {
        return this.cw;
    }

    public void setRunning(boolean isRunning) {
        this.r = isRunning;
    }

    public boolean isRunning() {
        return this.r;
    }

    public void setContact(String contact) {
        this.c = contact != null && contact.length() == 0 ? null : contact;
    }

    public String getContact() {
        return this.c;
    }

    public void setFamilyFingerprints(SortedSet<String> familyFingerprints) {
        this.ff = this.collectionToStringArray(familyFingerprints);
    }

    public SortedSet<String> getFamilyFingerprints() {
        return this.stringArrayToSortedSet(this.ff);
    }

    public void setEffectiveFamily(SortedSet<String> effectiveFamily) {
        this.ef = this.collectionToStringArray(effectiveFamily);
    }

    public SortedSet<String> getEffectiveFamily() {
        return this.stringArrayToSortedSet(this.ef);
    }

    public SummaryDocument(boolean isRelay, String nickname, String fingerprint, List<String> addresses, long lastSeenMillis, boolean running, SortedSet<String> relayFlags, long consensusWeight, String countryCode, long firstSeenMillis, String asNumber, String contact, SortedSet<String> familyFingerprints, SortedSet<String> effectiveFamily) {
        this.setRelay(isRelay);
        this.setNickname(nickname);
        this.setFingerprint(fingerprint);
        this.setAddresses(addresses);
        this.setLastSeenMillis(lastSeenMillis);
        this.setRunning(running);
        this.setRelayFlags(relayFlags);
        this.setConsensusWeight(consensusWeight);
        this.setCountryCode(countryCode);
        this.setFirstSeenMillis(firstSeenMillis);
        this.setAsNumber(asNumber);
        this.setContact(contact);
        this.setFamilyFingerprints(familyFingerprints);
        this.setEffectiveFamily(effectiveFamily);
    }
}

