/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.updater;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.Descriptor;
import org.torproject.onionoo.updater.DescriptorDownloader;
import org.torproject.onionoo.updater.DescriptorHistory;
import org.torproject.onionoo.updater.DescriptorListener;
import org.torproject.onionoo.updater.DescriptorQueue;
import org.torproject.onionoo.updater.DescriptorType;
import org.torproject.onionoo.util.FormattingUtils;

public class DescriptorSource {
    private static final Logger log = LoggerFactory.getLogger(DescriptorSource.class);
    private final File inRecentDir = new File("in/recent");
    private final File inArchiveDir = new File("in/archive");
    private final File statusDir = new File("status");
    private List<DescriptorQueue> descriptorQueues = new ArrayList<DescriptorQueue>();
    private DescriptorQueue archiveDescriptorQueue;
    private Map<DescriptorType, Set<DescriptorListener>> descriptorListeners = new HashMap<DescriptorType, Set<DescriptorListener>>();
    private int localFilesBefore = 0;
    private int foundRemoteFiles = 0;
    private int downloadedFiles = 0;
    private int deletedLocalFiles = 0;

    private DescriptorQueue getDescriptorQueue(DescriptorType descriptorType, DescriptorHistory descriptorHistory) {
        DescriptorQueue descriptorQueue = new DescriptorQueue(this.inRecentDir, descriptorType, this.statusDir);
        if (descriptorHistory != null) {
            descriptorQueue.readHistoryFile(descriptorHistory);
        }
        this.descriptorQueues.add(descriptorQueue);
        return descriptorQueue;
    }

    public void registerDescriptorListener(DescriptorListener listener, DescriptorType descriptorType) {
        if (!this.descriptorListeners.containsKey((Object)descriptorType)) {
            this.descriptorListeners.put(descriptorType, new HashSet());
        }
        this.descriptorListeners.get((Object)descriptorType).add(listener);
    }

    public void downloadDescriptors() {
        for (DescriptorType descriptorType : DescriptorType.values()) {
            log.info("Loading: " + (Object)((Object)descriptorType));
            this.downloadDescriptors(descriptorType);
        }
    }

    private void downloadDescriptors(DescriptorType descriptorType) {
        DescriptorDownloader descriptorDownloader = new DescriptorDownloader(descriptorType);
        this.localFilesBefore += descriptorDownloader.statLocalFiles();
        this.foundRemoteFiles += descriptorDownloader.fetchRemoteDirectory();
        this.downloadedFiles += descriptorDownloader.fetchRemoteFiles();
        this.deletedLocalFiles += descriptorDownloader.deleteOldLocalFiles();
    }

    public void readDescriptors() {
        this.readArchivedDescriptors();
        log.debug("Reading recent " + (Object)((Object)DescriptorType.RELAY_SERVER_DESCRIPTORS) + " ...");
        this.readDescriptors(DescriptorType.RELAY_SERVER_DESCRIPTORS, DescriptorHistory.RELAY_SERVER_HISTORY, true);
        log.debug("Reading recent " + (Object)((Object)DescriptorType.RELAY_EXTRA_INFOS) + " ...");
        this.readDescriptors(DescriptorType.RELAY_EXTRA_INFOS, DescriptorHistory.RELAY_EXTRAINFO_HISTORY, true);
        log.debug("Reading recent " + (Object)((Object)DescriptorType.EXIT_LISTS) + " ...");
        this.readDescriptors(DescriptorType.EXIT_LISTS, DescriptorHistory.EXIT_LIST_HISTORY, true);
        log.debug("Reading recent " + (Object)((Object)DescriptorType.RELAY_CONSENSUSES) + " ...");
        this.readDescriptors(DescriptorType.RELAY_CONSENSUSES, DescriptorHistory.RELAY_CONSENSUS_HISTORY, true);
        log.debug("Reading recent " + (Object)((Object)DescriptorType.BRIDGE_SERVER_DESCRIPTORS) + " ...");
        this.readDescriptors(DescriptorType.BRIDGE_SERVER_DESCRIPTORS, DescriptorHistory.BRIDGE_SERVER_HISTORY, false);
        log.debug("Reading recent " + (Object)((Object)DescriptorType.BRIDGE_EXTRA_INFOS) + " ...");
        this.readDescriptors(DescriptorType.BRIDGE_EXTRA_INFOS, DescriptorHistory.BRIDGE_EXTRAINFO_HISTORY, false);
        log.debug("Reading recent " + (Object)((Object)DescriptorType.BRIDGE_STATUSES) + " ...");
        this.readDescriptors(DescriptorType.BRIDGE_STATUSES, DescriptorHistory.BRIDGE_STATUS_HISTORY, false);
    }

    private void readDescriptors(DescriptorType descriptorType, DescriptorHistory descriptorHistory, boolean relay) {
        Descriptor descriptor;
        if (!this.descriptorListeners.containsKey((Object)descriptorType)) {
            return;
        }
        Set<DescriptorListener> descriptorListeners = this.descriptorListeners.get((Object)descriptorType);
        DescriptorQueue descriptorQueue = this.getDescriptorQueue(descriptorType, descriptorHistory);
        while ((descriptor = descriptorQueue.nextDescriptor()) != null) {
            for (DescriptorListener descriptorListener : descriptorListeners) {
                descriptorListener.processDescriptor(descriptor, relay);
            }
        }
        switch (descriptorType) {
            case RELAY_CONSENSUSES: {
                log.info("Read recent relay network consensuses");
                break;
            }
            case RELAY_SERVER_DESCRIPTORS: {
                log.info("Read recent relay server descriptors");
                break;
            }
            case RELAY_EXTRA_INFOS: {
                log.info("Read recent relay extra-info descriptors");
                break;
            }
            case EXIT_LISTS: {
                log.info("Read recent exit lists");
                break;
            }
            case BRIDGE_STATUSES: {
                log.info("Read recent bridge network statuses");
                break;
            }
            case BRIDGE_SERVER_DESCRIPTORS: {
                log.info("Read recent bridge server descriptors");
                break;
            }
            case BRIDGE_EXTRA_INFOS: {
                log.info("Read recent bridge extra-info descriptors");
                break;
            }
            default: {
                log.info("Read recent descriptors of type " + (Object)((Object)descriptorType));
            }
        }
    }

    public void readArchivedDescriptors() {
        Descriptor descriptor;
        if (!this.inArchiveDir.exists()) {
            return;
        }
        log.info("Reading archived descriptors...");
        this.archiveDescriptorQueue = new DescriptorQueue(this.inArchiveDir, null, null);
        while ((descriptor = this.archiveDescriptorQueue.nextDescriptor()) != null) {
            DescriptorType descriptorType = null;
            boolean relay = false;
            for (String annotation : descriptor.getAnnotations()) {
                if (annotation.startsWith("@type network-status-consensus-3 1.")) {
                    descriptorType = DescriptorType.RELAY_CONSENSUSES;
                    relay = true;
                    continue;
                }
                if (annotation.startsWith("@type server-descriptor 1.")) {
                    descriptorType = DescriptorType.RELAY_SERVER_DESCRIPTORS;
                    relay = true;
                    continue;
                }
                if (annotation.startsWith("@type extra-info 1.")) {
                    descriptorType = DescriptorType.RELAY_EXTRA_INFOS;
                    relay = true;
                    continue;
                }
                if (annotation.startsWith("@type tordnsel 1.")) {
                    descriptorType = DescriptorType.EXIT_LISTS;
                    relay = true;
                    continue;
                }
                if (annotation.startsWith("@type bridge-network-status 1.")) {
                    descriptorType = DescriptorType.BRIDGE_STATUSES;
                    relay = false;
                    continue;
                }
                if (annotation.startsWith("@type bridge-server-descriptor 1.")) {
                    descriptorType = DescriptorType.BRIDGE_SERVER_DESCRIPTORS;
                    relay = false;
                    continue;
                }
                if (!annotation.startsWith("@type bridge-extra-info 1.")) continue;
                descriptorType = DescriptorType.BRIDGE_EXTRA_INFOS;
                relay = false;
            }
            if (descriptorType == null) {
                log.warn("Unrecognized descriptor in " + this.inArchiveDir.getAbsolutePath() + " with annotations " + descriptor.getAnnotations() + ".  Not reading any furtherarchived descriptors.");
                break;
            }
            for (DescriptorListener descriptorListener : this.descriptorListeners.get((Object)descriptorType)) {
                descriptorListener.processDescriptor(descriptor, relay);
            }
        }
        log.info("Read archived descriptors");
    }

    public void writeHistoryFiles() {
        log.debug("Writing parse histories for recent descriptors...");
        for (DescriptorQueue descriptorQueue : this.descriptorQueues) {
            descriptorQueue.writeHistoryFile();
        }
    }

    public String getStatsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    " + this.localFilesBefore + " recent descriptor files found locally\n");
        sb.append("    " + this.foundRemoteFiles + " recent descriptor files found remotely\n");
        sb.append("    " + this.downloadedFiles + " recent descriptor files downloaded from remote\n");
        sb.append("    " + this.deletedLocalFiles + " recent descriptor files deleted locally\n");
        sb.append("    " + this.descriptorQueues.size() + " descriptor queues created for recent descriptors\n");
        int historySizeBefore = 0;
        int historySizeAfter = 0;
        long descriptors = 0L;
        long bytes = 0L;
        for (DescriptorQueue descriptorQueue : this.descriptorQueues) {
            historySizeBefore += descriptorQueue.getHistorySizeBefore();
            historySizeAfter += descriptorQueue.getHistorySizeAfter();
            descriptors += descriptorQueue.getReturnedDescriptors();
            bytes += descriptorQueue.getReturnedBytes();
        }
        sb.append("    " + FormattingUtils.formatDecimalNumber(historySizeBefore) + " recent descriptors excluded from this execution\n");
        sb.append("    " + FormattingUtils.formatDecimalNumber(descriptors) + " recent descriptors provided\n");
        sb.append("    " + FormattingUtils.formatBytes(bytes) + " of recent descriptors provided\n");
        sb.append("    " + FormattingUtils.formatDecimalNumber(historySizeAfter) + " recent descriptors excluded from next execution\n");
        if (this.archiveDescriptorQueue != null) {
            sb.append("    " + FormattingUtils.formatDecimalNumber(this.archiveDescriptorQueue.getReturnedDescriptors()) + " archived descriptors provided\n");
            sb.append("    " + FormattingUtils.formatBytes(this.archiveDescriptorQueue.getReturnedBytes()) + " of archived descriptors provided\n");
        }
        return sb.toString();
    }
}

