/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.server;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.onionoo.server.Counter;
import org.torproject.onionoo.server.IntegerDistribution;
import org.torproject.onionoo.server.MostFrequentString;
import org.torproject.onionoo.util.Time;
import org.torproject.onionoo.util.TimeFactory;

public class PerformanceMetrics {
    private static final Logger log = LoggerFactory.getLogger(PerformanceMetrics.class);
    private static final Object lock = new Object();
    private static Time time;
    private static long lastLoggedMillis;
    private static final long LOG_INTERVAL_SECONDS = 3600L;
    private static final long LOG_INTERVAL_MILLIS = 3600000L;
    private static Counter totalProcessedRequests;
    private static MostFrequentString requestsByResourceType;
    private static MostFrequentString requestsByParameters;
    private static IntegerDistribution matchingRelayDocuments;
    private static IntegerDistribution matchingBridgeDocuments;
    private static IntegerDistribution writtenChars;
    private static IntegerDistribution handleRequestMillis;
    private static IntegerDistribution buildResponseMillis;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logStatistics(long receivedRequestMillis, String resourceType, Collection<String> parameterKeys, long parsedRequestMillis, int relayDocumentsWritten, int bridgeDocumentsWritten, int charsWritten, long writtenResponseMillis) {
        Object object = lock;
        synchronized (object) {
            if (time == null) {
                time = TimeFactory.getTime();
            }
            if (lastLoggedMillis < 0L) {
                lastLoggedMillis = time.currentTimeMillis();
            } else if (receivedRequestMillis - lastLoggedMillis > 3600000L) {
                SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                log.info("Request statistics (" + dateTimeFormat.format(lastLoggedMillis + 3600000L) + ", " + 3600L + " s):");
                log.info("  Total processed requests: " + totalProcessedRequests);
                log.info("  Most frequently requested resource: " + requestsByResourceType);
                log.info("  Most frequently requested parameter combinations: " + requestsByParameters);
                log.info("  Matching relays per request: " + matchingRelayDocuments);
                log.info("  Matching bridges per request: " + matchingBridgeDocuments);
                log.info("  Written characters per response: " + writtenChars);
                log.info("  Milliseconds to handle request: " + handleRequestMillis);
                log.info("  Milliseconds to build response: " + buildResponseMillis);
                totalProcessedRequests.clear();
                requestsByResourceType.clear();
                requestsByParameters.clear();
                matchingRelayDocuments.clear();
                matchingBridgeDocuments.clear();
                writtenChars.clear();
                handleRequestMillis.clear();
                buildResponseMillis.clear();
                while (receivedRequestMillis - (lastLoggedMillis += 3600000L) > 3600000L) {
                }
            }
            totalProcessedRequests.increment();
            long handlingTime = parsedRequestMillis - receivedRequestMillis;
            if (handlingTime > 1000L) {
                log.warn("longer request handling: " + handlingTime + " ms for " + resourceType + " params: " + parameterKeys + " and " + charsWritten + " chars.");
            }
            handleRequestMillis.addLong(handlingTime);
            requestsByResourceType.addString(resourceType);
            requestsByParameters.addString(parameterKeys.toString());
            matchingRelayDocuments.addLong(relayDocumentsWritten);
            matchingBridgeDocuments.addLong(bridgeDocumentsWritten);
            writtenChars.addLong(charsWritten);
            long responseTime = writtenResponseMillis - parsedRequestMillis;
            if (responseTime > 1000L) {
                log.warn("longer response building: " + responseTime + " ms for " + resourceType + " params: " + parameterKeys + " and " + charsWritten + " chars.");
            }
            buildResponseMillis.addLong(responseTime);
        }
    }

    static {
        lastLoggedMillis = -1L;
        totalProcessedRequests = new Counter();
        requestsByResourceType = new MostFrequentString();
        requestsByParameters = new MostFrequentString();
        matchingRelayDocuments = new IntegerDistribution();
        matchingBridgeDocuments = new IntegerDistribution();
        writtenChars = new IntegerDistribution();
        handleRequestMillis = new IntegerDistribution();
        buildResponseMillis = new IntegerDistribution();
    }
}

