/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.onionoo.docs.DocumentStore;
import org.torproject.onionoo.docs.DocumentStoreFactory;
import org.torproject.onionoo.docs.SummaryDocument;
import org.torproject.onionoo.docs.UpdateStatus;
import org.torproject.onionoo.server.NodeIndex;
import org.torproject.onionoo.server.NodeIndexerFactory;
import org.torproject.onionoo.util.Time;
import org.torproject.onionoo.util.TimeFactory;

public class NodeIndexer
implements ServletContextListener,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(NodeIndexer.class);
    private long lastIndexed = -1L;
    private NodeIndex latestNodeIndex = null;
    private Thread nodeIndexerThread = null;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_DAY = 86400000L;

    public void contextInitialized(ServletContextEvent contextEvent) {
        ServletContext servletContext = contextEvent.getServletContext();
        File outDir = new File(servletContext.getInitParameter("outDir"));
        if (!outDir.exists() || !outDir.isDirectory()) {
            log.error("\n\n\tOut-dir not found! Expected directory: " + outDir + "\n\tVerify the configuration in ./etc/web.xml.template");
            System.exit(1);
        }
        DocumentStore documentStore = DocumentStoreFactory.getDocumentStore();
        documentStore.setOutDir(outDir);
        NodeIndexerFactory.setNodeIndexer(this);
        this.startIndexing();
    }

    public void contextDestroyed(ServletContextEvent contextEvent) {
        this.stopIndexing();
    }

    public synchronized long getLastIndexed(long timeoutMillis) {
        if (this.lastIndexed == -1L && this.nodeIndexerThread != null && timeoutMillis > 0L) {
            try {
                this.wait(timeoutMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.lastIndexed;
    }

    public synchronized NodeIndex getLatestNodeIndex(long timeoutMillis) {
        if (this.latestNodeIndex == null && this.nodeIndexerThread != null && timeoutMillis > 0L) {
            try {
                this.wait(timeoutMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.latestNodeIndex;
    }

    public synchronized void startIndexing() {
        if (this.nodeIndexerThread == null) {
            this.nodeIndexerThread = new Thread(this);
            this.nodeIndexerThread.setDaemon(true);
            this.nodeIndexerThread.start();
        }
    }

    @Override
    public void run() {
        while (this.nodeIndexerThread != null) {
            this.indexNodeStatuses();
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void stopIndexing() {
        Thread indexerThread = this.nodeIndexerThread;
        this.nodeIndexerThread = null;
        indexerThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexNodeStatuses() {
        String hashedFingerprint;
        long updateStatusMillis = -1L;
        DocumentStore documentStore = DocumentStoreFactory.getDocumentStore();
        UpdateStatus updateStatus = documentStore.retrieve(UpdateStatus.class, true);
        if (updateStatus != null) {
            updateStatusMillis = updateStatus.getUpdatedMillis();
        }
        NodeIndexer nodeIndexer = this;
        synchronized (nodeIndexer) {
            if (updateStatusMillis <= this.lastIndexed) {
                return;
            }
        }
        documentStore.invalidateDocumentCache();
        HashMap<String, SummaryDocument> newRelayFingerprintSummaryLines = new HashMap<String, SummaryDocument>();
        HashMap<String, SummaryDocument> newBridgeFingerprintSummaryLines = new HashMap<String, SummaryDocument>();
        HashMap<String, Set<String>> newRelaysByCountryCode = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newRelaysByAsNumber = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newRelaysByFlag = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newBridgesByFlag = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newRelaysByContact = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newRelaysByFamily = new HashMap<String, Set<String>>();
        TreeMap<Integer, Set<String>> newRelaysByFirstSeenDays = new TreeMap<Integer, Set<String>>();
        TreeMap<Integer, Set<String>> newBridgesByFirstSeenDays = new TreeMap<Integer, Set<String>>();
        TreeMap<Integer, Set<String>> newRelaysByLastSeenDays = new TreeMap<Integer, Set<String>>();
        TreeMap<Integer, Set<String>> newBridgesByLastSeenDays = new TreeMap<Integer, Set<String>>();
        HashSet<SummaryDocument> currentRelays = new HashSet<SummaryDocument>();
        HashSet<SummaryDocument> currentBridges = new HashSet<SummaryDocument>();
        SortedSet<String> fingerprints = documentStore.list(SummaryDocument.class);
        long relaysLastValidAfterMillis = 0L;
        long bridgesLastPublishedMillis = 0L;
        for (String fingerprint : fingerprints) {
            SummaryDocument node = documentStore.retrieve(SummaryDocument.class, true, fingerprint);
            if (node.isRelay()) {
                relaysLastValidAfterMillis = Math.max(relaysLastValidAfterMillis, node.getLastSeenMillis());
                currentRelays.add(node);
                continue;
            }
            bridgesLastPublishedMillis = Math.max(bridgesLastPublishedMillis, node.getLastSeenMillis());
            currentBridges.add(node);
        }
        Time time = TimeFactory.getTime();
        ArrayList<String> orderRelaysByConsensusWeight = new ArrayList<String>();
        TreeMap<String, SortedSet<String>> computedEffectiveFamilies = new TreeMap<String, SortedSet<String>>();
        for (SummaryDocument summaryDocument : currentRelays) {
            int daysSinceFirstSeen;
            String fingerprint = summaryDocument.getFingerprint().toUpperCase();
            hashedFingerprint = summaryDocument.getHashedFingerprint().toUpperCase();
            newRelayFingerprintSummaryLines.put(fingerprint, summaryDocument);
            newRelayFingerprintSummaryLines.put(hashedFingerprint, summaryDocument);
            long consensusWeight = summaryDocument.getConsensusWeight();
            orderRelaysByConsensusWeight.add(String.format("%020d %s", consensusWeight, fingerprint));
            orderRelaysByConsensusWeight.add(String.format("%020d %s", consensusWeight, hashedFingerprint));
            if (summaryDocument.getCountryCode() != null) {
                String countryCode = summaryDocument.getCountryCode();
                if (!newRelaysByCountryCode.containsKey(countryCode)) {
                    newRelaysByCountryCode.put(countryCode, new HashSet());
                }
                ((Set)newRelaysByCountryCode.get(countryCode)).add(fingerprint);
                ((Set)newRelaysByCountryCode.get(countryCode)).add(hashedFingerprint);
            }
            if (summaryDocument.getAsNumber() != null) {
                String asNumber = summaryDocument.getAsNumber();
                if (!newRelaysByAsNumber.containsKey(asNumber)) {
                    newRelaysByAsNumber.put(asNumber, new HashSet());
                }
                ((Set)newRelaysByAsNumber.get(asNumber)).add(fingerprint);
                ((Set)newRelaysByAsNumber.get(asNumber)).add(hashedFingerprint);
            }
            for (String flag : summaryDocument.getRelayFlags()) {
                String flagLowerCase = flag.toLowerCase();
                if (!newRelaysByFlag.containsKey(flagLowerCase)) {
                    newRelaysByFlag.put(flagLowerCase, new HashSet());
                }
                ((Set)newRelaysByFlag.get(flagLowerCase)).add(fingerprint);
                ((Set)newRelaysByFlag.get(flagLowerCase)).add(hashedFingerprint);
            }
            if (summaryDocument.getFamilyFingerprints() != null && !summaryDocument.getFamilyFingerprints().isEmpty()) {
                computedEffectiveFamilies.put(fingerprint, summaryDocument.getFamilyFingerprints());
            }
            if (summaryDocument.getEffectiveFamily() != null) {
                newRelaysByFamily.put(fingerprint, summaryDocument.getEffectiveFamily());
            }
            if (!newRelaysByFirstSeenDays.containsKey(daysSinceFirstSeen = (int)((time.currentTimeMillis() - summaryDocument.getFirstSeenMillis()) / 86400000L))) {
                newRelaysByFirstSeenDays.put(daysSinceFirstSeen, new HashSet());
            }
            ((Set)newRelaysByFirstSeenDays.get(daysSinceFirstSeen)).add(fingerprint);
            ((Set)newRelaysByFirstSeenDays.get(daysSinceFirstSeen)).add(hashedFingerprint);
            int daysSinceLastSeen = (int)((time.currentTimeMillis() - summaryDocument.getLastSeenMillis()) / 86400000L);
            if (!newRelaysByLastSeenDays.containsKey(daysSinceLastSeen)) {
                newRelaysByLastSeenDays.put(daysSinceLastSeen, new HashSet());
            }
            ((Set)newRelaysByLastSeenDays.get(daysSinceLastSeen)).add(fingerprint);
            ((Set)newRelaysByLastSeenDays.get(daysSinceLastSeen)).add(hashedFingerprint);
            String contact = summaryDocument.getContact();
            if (!newRelaysByContact.containsKey(contact)) {
                newRelaysByContact.put(contact, new HashSet());
            }
            ((Set)newRelaysByContact.get(contact)).add(fingerprint);
            ((Set)newRelaysByContact.get(contact)).add(hashedFingerprint);
        }
        Collections.sort(orderRelaysByConsensusWeight);
        ArrayList<String> newRelaysByConsensusWeight = new ArrayList<String>();
        for (String relay : orderRelaysByConsensusWeight) {
            newRelaysByConsensusWeight.add(relay.split(" ")[1]);
        }
        for (Map.Entry e : computedEffectiveFamilies.entrySet()) {
            String fingerprint = (String)e.getKey();
            HashSet<String> inMutualFamilyRelation = new HashSet<String>();
            for (String otherFingerprint : (Set)e.getValue()) {
                if (!computedEffectiveFamilies.containsKey(otherFingerprint) || !((Set)computedEffectiveFamilies.get(otherFingerprint)).contains(fingerprint)) continue;
                inMutualFamilyRelation.add(otherFingerprint);
            }
            newRelaysByFamily.put(fingerprint, inMutualFamilyRelation);
        }
        for (SummaryDocument entry : currentBridges) {
            hashedFingerprint = entry.getFingerprint().toUpperCase();
            String hashedHashedFingerprint = entry.getHashedFingerprint().toUpperCase();
            newBridgeFingerprintSummaryLines.put(hashedFingerprint, entry);
            newBridgeFingerprintSummaryLines.put(hashedHashedFingerprint, entry);
            for (String flag : entry.getRelayFlags()) {
                String flagLowerCase = flag.toLowerCase();
                if (!newBridgesByFlag.containsKey(flagLowerCase)) {
                    newBridgesByFlag.put(flagLowerCase, new HashSet());
                }
                ((Set)newBridgesByFlag.get(flagLowerCase)).add(hashedFingerprint);
                ((Set)newBridgesByFlag.get(flagLowerCase)).add(hashedHashedFingerprint);
            }
            int daysSinceFirstSeen = (int)((time.currentTimeMillis() - entry.getFirstSeenMillis()) / 86400000L);
            if (!newBridgesByFirstSeenDays.containsKey(daysSinceFirstSeen)) {
                newBridgesByFirstSeenDays.put(daysSinceFirstSeen, new HashSet());
            }
            ((Set)newBridgesByFirstSeenDays.get(daysSinceFirstSeen)).add(hashedFingerprint);
            ((Set)newBridgesByFirstSeenDays.get(daysSinceFirstSeen)).add(hashedHashedFingerprint);
            int daysSinceLastSeen = (int)((time.currentTimeMillis() - entry.getLastSeenMillis()) / 86400000L);
            if (!newBridgesByLastSeenDays.containsKey(daysSinceLastSeen)) {
                newBridgesByLastSeenDays.put(daysSinceLastSeen, new HashSet());
            }
            ((Set)newBridgesByLastSeenDays.get(daysSinceLastSeen)).add(hashedFingerprint);
            ((Set)newBridgesByLastSeenDays.get(daysSinceLastSeen)).add(hashedHashedFingerprint);
        }
        NodeIndex nodeIndex = new NodeIndex();
        nodeIndex.setRelaysByConsensusWeight(newRelaysByConsensusWeight);
        nodeIndex.setRelayFingerprintSummaryLines(newRelayFingerprintSummaryLines);
        nodeIndex.setBridgeFingerprintSummaryLines(newBridgeFingerprintSummaryLines);
        nodeIndex.setRelaysByCountryCode(newRelaysByCountryCode);
        nodeIndex.setRelaysByAsNumber(newRelaysByAsNumber);
        nodeIndex.setRelaysByFlag(newRelaysByFlag);
        nodeIndex.setBridgesByFlag(newBridgesByFlag);
        nodeIndex.setRelaysByContact(newRelaysByContact);
        nodeIndex.setRelaysByFamily(newRelaysByFamily);
        nodeIndex.setRelaysByFirstSeenDays(newRelaysByFirstSeenDays);
        nodeIndex.setRelaysByLastSeenDays(newRelaysByLastSeenDays);
        nodeIndex.setBridgesByFirstSeenDays(newBridgesByFirstSeenDays);
        nodeIndex.setBridgesByLastSeenDays(newBridgesByLastSeenDays);
        nodeIndex.setRelaysPublishedMillis(relaysLastValidAfterMillis);
        nodeIndex.setBridgesPublishedMillis(bridgesLastPublishedMillis);
        NodeIndexer nodeIndexer2 = this;
        synchronized (nodeIndexer2) {
            this.lastIndexed = updateStatusMillis;
            this.latestNodeIndex = nodeIndex;
            this.notifyAll();
        }
    }
}

