/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.docs;

import java.util.Scanner;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.onionoo.docs.ClientsHistory;
import org.torproject.onionoo.docs.DateTimeHelper;
import org.torproject.onionoo.docs.Document;
import org.torproject.onionoo.util.TimeFactory;

public class ClientsStatus
extends Document {
    private static Logger log = LoggerFactory.getLogger(ClientsStatus.class);
    private transient boolean isDirty = false;
    private SortedSet<ClientsHistory> history = new TreeSet<ClientsHistory>();

    public boolean isDirty() {
        return this.isDirty;
    }

    public void clearDirty() {
        this.isDirty = false;
    }

    public void setHistory(SortedSet<ClientsHistory> history) {
        this.history = history;
    }

    public SortedSet<ClientsHistory> getHistory() {
        return this.history;
    }

    @Override
    public void setFromDocumentString(String documentString) {
        try (Scanner s = new Scanner(documentString);){
            while (s.hasNextLine()) {
                String line = s.nextLine();
                ClientsHistory parsedLine = ClientsHistory.fromString(line);
                if (parsedLine != null) {
                    this.history.add(parsedLine);
                    continue;
                }
                log.error("Could not parse clients history line '" + line + "'.  Skipping.");
            }
        }
    }

    public void addToHistory(SortedSet<ClientsHistory> newIntervals) {
        for (ClientsHistory interval : newIntervals) {
            if (!this.history.headSet(interval).isEmpty() && this.history.headSet(interval).last().getEndMillis() > interval.getStartMillis() || !this.history.tailSet(interval).isEmpty() && this.history.tailSet(interval).first().getStartMillis() < interval.getEndMillis()) continue;
            this.history.add(interval);
            this.isDirty = true;
        }
    }

    public void compressHistory() {
        TreeSet<ClientsHistory> uncompressedHistory = new TreeSet<ClientsHistory>(this.history);
        this.history.clear();
        ClientsHistory lastResponses = null;
        String lastMonthString = "1970-01";
        long now = TimeFactory.getTime().currentTimeMillis();
        for (ClientsHistory responses : uncompressedHistory) {
            long intervalLengthMillis = now - responses.getEndMillis() <= 7948800000L ? 86400000L : (now - responses.getEndMillis() <= 31622400000L ? 172800000L : 864000000L);
            String monthString = DateTimeHelper.format(responses.getStartMillis(), "yyyy-MM");
            if (lastResponses != null && lastResponses.getEndMillis() == responses.getStartMillis() && (lastResponses.getEndMillis() - 1L) / intervalLengthMillis == (responses.getEndMillis() - 1L) / intervalLengthMillis && lastMonthString.equals(monthString)) {
                lastResponses.addResponses(responses);
            } else {
                if (lastResponses != null) {
                    this.history.add(lastResponses);
                }
                lastResponses = responses;
            }
            lastMonthString = monthString;
        }
        if (lastResponses != null) {
            this.history.add(lastResponses);
        }
    }

    @Override
    public String toDocumentString() {
        StringBuilder sb = new StringBuilder();
        for (ClientsHistory interval : this.history) {
            sb.append(interval.toString() + "\n");
        }
        return sb.toString();
    }
}

