import json
import re
import urllib.request

response = urllib.request.urlopen("https://gitweb.torproject.org/tor.git/plain/src/app/config/fallback_dirs.inc")
lines = [x.decode("ascii") for x in response.readlines()]

fingerprints = []
for line in lines:
    if line.startswith("\""):
        m = re.search('(?<=id=)\w+', line)
        if m:
            fingerprints.append(m.group(0))

print("""

/*
This file is generated by src/main/python/fallback_dir.py.

To update run:

ant update-fallback-dir-list
*/

var fallbackDirs = %s;

function IsFallbackDir(fingerprint) {
  return $.inArray(fingerprint, fallbackDirs) > -1;
}
""" % (json.dumps(fingerprints)))

