/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.assign.primitive;

import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.Removal;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackManipulation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.assign.Assigner;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.DefaultValue;

public class VoidAwareAssigner
implements Assigner {
    private final Assigner chained;

    public VoidAwareAssigner(Assigner chained) {
        this.chained = chained;
    }

    @Override
    public StackManipulation assign(TypeDescription.Generic source, TypeDescription.Generic target, Assigner.Typing typing) {
        if (source.represents(Void.TYPE) && target.represents(Void.TYPE)) {
            return StackManipulation.Trivial.INSTANCE;
        }
        if (source.represents(Void.TYPE)) {
            return typing.isDynamic() ? DefaultValue.of(target) : StackManipulation.Illegal.INSTANCE;
        }
        if (target.represents(Void.TYPE)) {
            return Removal.pop(source);
        }
        return this.chained.assign(source, target, typing);
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.chained.equals(((VoidAwareAssigner)other).chained);
    }

    public int hashCode() {
        return this.chained.hashCode();
    }

    public String toString() {
        return "VoidAwareAssigner{chained=" + this.chained + '}';
    }
}

