/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.rolling.RolloverChecker;
import ch.qos.logback.core.util.Compare;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;

public class DefaultRolloverChecker
implements RolloverChecker {
    final String testId;
    final boolean withCompression;
    final String compressionSuffix;

    public DefaultRolloverChecker(String testId, boolean withCompression, String compressionSuffix) {
        this.testId = testId;
        this.withCompression = withCompression;
        this.compressionSuffix = compressionSuffix;
    }

    @Override
    public void check(List<String> expectedFilenameList) throws IOException {
        int i = 0;
        for (String fn : expectedFilenameList) {
            String suffix = this.withCompression ? this.addGZIfNotLast(expectedFilenameList, i, this.compressionSuffix) : "";
            String witnessFileName = "src/test/witness/rolling/tbr-" + this.testId + "." + i + suffix;
            Assert.assertTrue((boolean)Compare.compare(fn, witnessFileName));
            ++i;
        }
    }

    String addGZIfNotLast(List<String> expectedFilenameList, int i, String suff) {
        int lastIndex = expectedFilenameList.size() - 1;
        return i != lastIndex ? suff : "";
    }
}

