/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.hidserv;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.stats.hidserv.Aggregator;
import org.torproject.metrics.stats.hidserv.ComputedNetworkFractions;
import org.torproject.metrics.stats.hidserv.DocumentStore;
import org.torproject.metrics.stats.hidserv.ExtrapolatedHidServStats;
import org.torproject.metrics.stats.hidserv.Extrapolator;
import org.torproject.metrics.stats.hidserv.Parser;
import org.torproject.metrics.stats.hidserv.ReportedHidServStats;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);
    private static final File baseDir = new File(org.torproject.metrics.stats.main.Main.modulesDir, "hidserv");

    public static void main(String[] args) {
        Aggregator aggregator;
        File[] inDirectories = new File[]{new File(org.torproject.metrics.stats.main.Main.descriptorsDir, "recent/relay-descriptors/consensuses"), new File(org.torproject.metrics.stats.main.Main.descriptorsDir, "recent/relay-descriptors/extra-infos")};
        File statusDirectory = new File(baseDir, "status");
        logger.info("Initializing parser and reading parse history...");
        DocumentStore<ReportedHidServStats> reportedHidServStatsStore = new DocumentStore<ReportedHidServStats>(ReportedHidServStats.class);
        DocumentStore<ReportedHidServStats> reportedV3HidServStatsStore = new DocumentStore<ReportedHidServStats>(ReportedHidServStats.class);
        DocumentStore<ComputedNetworkFractions> computedNetworkFractionsStore = new DocumentStore<ComputedNetworkFractions>(ComputedNetworkFractions.class);
        Parser parser = new Parser(inDirectories, statusDirectory, reportedHidServStatsStore, reportedV3HidServStatsStore, computedNetworkFractionsStore);
        parser.readParseHistory();
        logger.info("Parsing descriptors...");
        parser.parseDescriptors();
        logger.info("Writing parse history...");
        parser.writeParseHistory();
        logger.info("Extrapolating statistics...");
        DocumentStore<ExtrapolatedHidServStats> extrapolatedHidServStatsStore = new DocumentStore<ExtrapolatedHidServStats>(ExtrapolatedHidServStats.class);
        DocumentStore<ExtrapolatedHidServStats> extrapolatedV3HidServStatsStore = new DocumentStore<ExtrapolatedHidServStats>(ExtrapolatedHidServStats.class);
        Extrapolator extrapolator = new Extrapolator(statusDirectory, reportedHidServStatsStore, reportedV3HidServStatsStore, computedNetworkFractionsStore, extrapolatedHidServStatsStore, extrapolatedV3HidServStatsStore);
        if (!extrapolator.extrapolateHidServStats()) {
            logger.warn("Could not extrapolate statistics. Terminating.");
        } else {
            logger.info("Aggregating v2 statistics...");
            File hidservStatsExtrapolatedCsvFile = new File(baseDir, "stats/hidserv.csv");
            aggregator = new Aggregator(statusDirectory, extrapolatedHidServStatsStore, hidservStatsExtrapolatedCsvFile, "extrapolated-hidserv-stats");
            aggregator.aggregateHidServStats();
        }
        if (!extrapolator.extrapolateV3HidServStats()) {
            logger.warn("Could not extrapolate v3 statistics. Terminating.");
        } else {
            logger.info("Aggregating v3 statistics...");
            File v3hidservStatsExtrapolatedCsvFile = new File(baseDir, "stats/v3hidserv.csv");
            aggregator = new Aggregator(statusDirectory, extrapolatedV3HidServStatsStore, v3hidservStatsExtrapolatedCsvFile, "extrapolated-v3hidserv-stats");
            aggregator.aggregateHidServStats();
        }
        logger.info("Terminating.");
    }
}

