/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.hidserv;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.stats.hidserv.ComputedNetworkFractions;
import org.torproject.metrics.stats.hidserv.DateTimeHelper;
import org.torproject.metrics.stats.hidserv.DocumentStore;
import org.torproject.metrics.stats.hidserv.ExtrapolatedHidServStats;
import org.torproject.metrics.stats.hidserv.ReportedHidServStats;

public class Extrapolator {
    private static final Logger logger = LoggerFactory.getLogger(Extrapolator.class);
    private File reportedHidServStatsFile;
    private DocumentStore<ReportedHidServStats> reportedHidServStatsStore;
    private File computedNetworkFractionsDirectory;
    private DocumentStore<ComputedNetworkFractions> computedNetworkFractionsStore;
    private File extrapolatedHidServStatsFile;
    private DocumentStore<ExtrapolatedHidServStats> extrapolatedHidServStatsStore;
    private File reportedV3HidServStatsFile;
    private DocumentStore<ReportedHidServStats> reportedV3HidServStatsStore;
    private File extrapolatedV3HidServStatsFile;
    private DocumentStore<ExtrapolatedHidServStats> extrapolatedV3HidServStatsStore;

    public Extrapolator(File statusDirectory, DocumentStore<ReportedHidServStats> reportedHidServStatsStore, DocumentStore<ReportedHidServStats> reportedV3HidServStatsStore, DocumentStore<ComputedNetworkFractions> computedNetworkFractionsStore, DocumentStore<ExtrapolatedHidServStats> extrapolatedHidServStatsStore, DocumentStore<ExtrapolatedHidServStats> extrapolatedV3HidServStatsStore) {
        this.reportedHidServStatsFile = new File(statusDirectory, "reported-hidserv-stats");
        this.computedNetworkFractionsDirectory = new File(statusDirectory, "computed-network-fractions");
        this.extrapolatedHidServStatsFile = new File(statusDirectory, "extrapolated-hidserv-stats");
        this.reportedV3HidServStatsFile = new File(statusDirectory, "reported-v3hidserv-stats");
        this.extrapolatedV3HidServStatsFile = new File(statusDirectory, "extrapolated-v3hidserv-stats");
        this.reportedHidServStatsStore = reportedHidServStatsStore;
        this.computedNetworkFractionsStore = computedNetworkFractionsStore;
        this.extrapolatedHidServStatsStore = extrapolatedHidServStatsStore;
        this.reportedV3HidServStatsStore = reportedV3HidServStatsStore;
        this.extrapolatedV3HidServStatsStore = extrapolatedV3HidServStatsStore;
    }

    public boolean extrapolateHidServStats() {
        Set<ExtrapolatedHidServStats> extrapolatedStats = this.extrapolatedHidServStatsStore.retrieve(this.extrapolatedHidServStatsFile);
        Set<ReportedHidServStats> reportedStats = this.reportedHidServStatsStore.retrieve(this.reportedHidServStatsFile);
        Set<ExtrapolatedHidServStats> computedStats = this.computeExtrapolatedStats(extrapolatedStats, reportedStats, "v2");
        return this.extrapolatedHidServStatsStore.store(this.extrapolatedHidServStatsFile, computedStats);
    }

    public boolean extrapolateV3HidServStats() {
        Set<ExtrapolatedHidServStats> extrapolatedStats = this.extrapolatedV3HidServStatsStore.retrieve(this.extrapolatedV3HidServStatsFile);
        Set<ReportedHidServStats> reportedStats = this.reportedV3HidServStatsStore.retrieve(this.reportedV3HidServStatsFile);
        Set<ExtrapolatedHidServStats> computedStats = this.computeExtrapolatedStats(extrapolatedStats, reportedStats, "v3");
        return this.extrapolatedV3HidServStatsStore.store(this.extrapolatedV3HidServStatsFile, computedStats);
    }

    private Set<ExtrapolatedHidServStats> computeExtrapolatedStats(Set<ExtrapolatedHidServStats> extrapolatedStats, Set<ReportedHidServStats> reportedStats, String version) {
        String fingerprint;
        if (extrapolatedStats == null || reportedStats == null) {
            logger.warn("Could not read previously parsed or extrapolated stats files. Skipping.");
            return null;
        }
        TreeMap parsedStatsByFingerprint = new TreeMap();
        for (ReportedHidServStats reportedHidServStats : reportedStats) {
            fingerprint = reportedHidServStats.getFingerprint();
            parsedStatsByFingerprint.putIfAbsent(fingerprint, new HashSet());
            ((Set)parsedStatsByFingerprint.get(fingerprint)).add(reportedHidServStats);
        }
        for (Map.Entry entry : parsedStatsByFingerprint.entrySet()) {
            fingerprint = (String)entry.getKey();
            HashSet<ReportedHidServStats> newReportedStats = new HashSet<ReportedHidServStats>();
            TreeSet<String> retrieveFractionDates = new TreeSet<String>();
            for (ReportedHidServStats stats : (Set)entry.getValue()) {
                long statsStartMillis;
                long statsDateMillis = stats.getStatsEndMillis() / 86400000L * 86400000L;
                if (extrapolatedStats.contains(new ExtrapolatedHidServStats(statsDateMillis, fingerprint))) continue;
                newReportedStats.add(stats);
                long statsEndMillis = stats.getStatsEndMillis();
                for (long millis = statsStartMillis = statsEndMillis - stats.getStatsIntervalSeconds() * 1000L; millis <= statsEndMillis; millis += 86400000L) {
                    String date = DateTimeHelper.format(millis, "yyyy-MM-dd");
                    retrieveFractionDates.add(date);
                }
            }
            TreeSet<Long> knownConsensuses = new TreeSet<Long>();
            TreeMap<Long, ComputedNetworkFractions> computedNetworkFractions = new TreeMap<Long, ComputedNetworkFractions>();
            for (String date : retrieveFractionDates) {
                File documentFile = new File(this.computedNetworkFractionsDirectory, date);
                Set<ComputedNetworkFractions> fractions = this.computedNetworkFractionsStore.retrieve(documentFile, fingerprint);
                for (ComputedNetworkFractions fraction : fractions) {
                    knownConsensuses.add(fraction.getValidAfterMillis());
                    if (!fraction.getFingerprint().equals(fingerprint)) continue;
                    computedNetworkFractions.put(fraction.getValidAfterMillis(), fraction);
                }
            }
            for (ReportedHidServStats stats : newReportedStats) {
                long statsEndMillis = stats.getStatsEndMillis();
                long statsDateMillis = statsEndMillis / 86400000L * 86400000L;
                long statsStartMillis = statsEndMillis - stats.getStatsIntervalSeconds() * 1000L;
                double sumFractionRendRelayedCells = 0.0;
                double sumFractionDirOnionsSeen = 0.0;
                int consensuses = 0;
                Iterator iterator = knownConsensuses.iterator();
                while (iterator.hasNext()) {
                    long validAfterMillis = (Long)iterator.next();
                    if (statsStartMillis > validAfterMillis || validAfterMillis >= statsEndMillis) continue;
                    if (computedNetworkFractions.containsKey(validAfterMillis)) {
                        ComputedNetworkFractions frac = (ComputedNetworkFractions)computedNetworkFractions.get(validAfterMillis);
                        sumFractionRendRelayedCells += frac.getFractionRendRelayedCells();
                        sumFractionDirOnionsSeen += frac.getFractionDirOnionsSeen();
                    }
                    ++consensuses;
                }
                double fractionRendRelayedCells = consensuses == 0 ? 0.0 : sumFractionRendRelayedCells / (double)consensuses;
                double fractionDirOnionsSeen = consensuses == 0 ? 0.0 : sumFractionDirOnionsSeen / (double)consensuses;
                ExtrapolatedHidServStats extrapolated = new ExtrapolatedHidServStats(statsDateMillis, fingerprint);
                if (fractionRendRelayedCells > 0.0) {
                    extrapolated.setFractionRendRelayedCells(fractionRendRelayedCells);
                    double extrapolatedRendRelayedCells = (double)stats.getRendRelayedCells() / fractionRendRelayedCells;
                    extrapolated.setExtrapolatedRendRelayedCells(extrapolatedRendRelayedCells);
                }
                if (fractionDirOnionsSeen > 0.0) {
                    extrapolated.setFractionDirOnionsSeen(fractionDirOnionsSeen);
                    double extrapolatedDirOnionsSeen = 0.0;
                    if (version == "v2") {
                        extrapolatedDirOnionsSeen = (double)stats.getDirOnionsSeen() / (12.0 * fractionDirOnionsSeen);
                    } else if (version == "v3") {
                        extrapolatedDirOnionsSeen = (double)stats.getDirOnionsSeen() / (24.0 * fractionDirOnionsSeen);
                    }
                    extrapolated.setExtrapolatedDirOnionsSeen(extrapolatedDirOnionsSeen);
                }
                extrapolatedStats.add(extrapolated);
            }
        }
        return extrapolatedStats;
    }
}

