/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.web;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.torproject.metrics.web.ContentProvider;
import org.torproject.metrics.web.Metric;

public class TableParameterChecker {
    private static TableParameterChecker instance = new TableParameterChecker();
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private Map<String, String[]> availableTables = new HashMap<String, String[]>();

    public static TableParameterChecker getInstance() {
        return instance;
    }

    public TableParameterChecker() {
        for (Metric metric : ContentProvider.getInstance().getMetricsList()) {
            if (!"Table".equals(metric.getType())) continue;
            this.availableTables.put(metric.getId(), metric.getParameters());
        }
    }

    public Map<String, String[]> checkParameters(String tableType, Map<String, String[]> requestParameters) {
        if (tableType == null || !this.availableTables.containsKey(tableType)) {
            return null;
        }
        HashSet<Object> supportedTableParameters = new HashSet<Object>(Arrays.asList((Object[])this.availableTables.get(tableType)));
        HashMap<String, String[]> recognizedTableParameters = new HashMap<String, String[]>();
        if (supportedTableParameters.contains("start") || supportedTableParameters.contains("end")) {
            String[] startParameter = null;
            String[] endParameter = null;
            if (requestParameters != null) {
                startParameter = requestParameters.get("start");
                endParameter = requestParameters.get("end");
            }
            long endTimestamp = System.currentTimeMillis();
            if (endParameter != null && endParameter.length > 0 && endParameter[0].length() > 0) {
                try {
                    endTimestamp = this.dateFormat.parse(endParameter[0]).getTime();
                }
                catch (ParseException e) {
                    return null;
                }
                if (!endParameter[0].startsWith("20")) {
                    return null;
                }
            }
            endParameter = new String[]{this.dateFormat.format(endTimestamp)};
            long startTimestamp = endTimestamp - 7776000000L;
            if (startParameter != null && startParameter.length > 0 && startParameter[0].length() > 0) {
                try {
                    startTimestamp = this.dateFormat.parse(startParameter[0]).getTime();
                }
                catch (ParseException e) {
                    return null;
                }
                if (!startParameter[0].startsWith("20")) {
                    return null;
                }
            }
            startParameter = new String[]{this.dateFormat.format(startTimestamp)};
            if (startTimestamp > endTimestamp) {
                return null;
            }
            recognizedTableParameters.put("start", startParameter);
            recognizedTableParameters.put("end", endParameter);
        }
        return recognizedTableParameters;
    }
}

