/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.servers;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.torproject.metrics.stats.servers.Ipv6NetworkStatus;
import org.torproject.metrics.stats.servers.Ipv6ServerDescriptor;

class Database
implements AutoCloseable {
    private static final String jdbcString = String.format("jdbc:postgresql://localhost/ipv6servers?user=%s&password=%s", System.getProperty("metrics.dbuser", "metrics"), System.getProperty("metrics.dbpass", "password"));
    private Connection connection;
    private Map<String, Integer> platformsCache = new HashMap<String, Integer>();
    private Map<String, Integer> versionsCache = new HashMap<String, Integer>();
    private Set<String> recommendedVersions = new HashSet<String>();
    private Map<String, Integer> flagsCache = new HashMap<String, Integer>();
    private PreparedStatement psPlatformsInsert;
    private PreparedStatement psVersionsInsert;
    private PreparedStatement psVersionsUpdate;
    private PreparedStatement psFlagsInsert;
    private PreparedStatement psServerDescriptorsSelect;
    private PreparedStatement psServerDescriptorsInsert;
    private PreparedStatement psStatusesSelect;
    private PreparedStatement psStatusesInsert;
    private PreparedStatement psStatusEntriesInsert;

    Database() throws SQLException {
        this.connect();
        this.prepareStatements();
        this.initializeCaches();
    }

    private void connect() throws SQLException {
        this.connection = DriverManager.getConnection(jdbcString);
        this.connection.setAutoCommit(false);
    }

    private void prepareStatements() throws SQLException {
        this.psPlatformsInsert = this.connection.prepareStatement("INSERT INTO platforms (platform_string) VALUES (?)", 1);
        this.psVersionsInsert = this.connection.prepareStatement("INSERT INTO versions (version_string, recommended) VALUES (?, ?)", 1);
        this.psVersionsUpdate = this.connection.prepareStatement("UPDATE versions SET recommended = TRUE WHERE version_id = ?");
        this.psFlagsInsert = this.connection.prepareStatement("INSERT INTO flags (flag_id, flag_string) VALUES (?, ?)");
        this.psServerDescriptorsSelect = this.connection.prepareStatement("SELECT EXISTS (SELECT 1 FROM server_descriptors WHERE descriptor_digest_sha1 = decode(?, 'hex'))");
        this.psServerDescriptorsInsert = this.connection.prepareStatement("INSERT INTO server_descriptors (descriptor_digest_sha1, platform_id, version_id, advertised_bandwidth_bytes, announced_ipv6, exiting_ipv6_relay) VALUES (decode(?, 'hex'), ?, ?, ?, ?, ?)");
        this.psStatusesSelect = this.connection.prepareStatement("SELECT EXISTS (SELECT 1 FROM statuses WHERE server = CAST(? AS server_enum) AND valid_after = ?)");
        this.psStatusesInsert = this.connection.prepareStatement("INSERT INTO statuses (server, valid_after, running_count, consensus_weight_sum, guard_weight_sum, middle_weight_sum, exit_weight_sum) VALUES (CAST(? AS server_enum), ?, ?, ?, ?, ?, ?)", 1);
        this.psStatusEntriesInsert = this.connection.prepareStatement("INSERT INTO status_entries (status_id, descriptor_digest_sha1, flags, reachable_ipv6_relay, consensus_weight, guard_weight, middle_weight, exit_weight) VALUES (?, decode(?, 'hex'), ?, ?, ?, ?, ?, ?)");
    }

    private void initializeCaches() throws SQLException {
        Statement st = this.connection.createStatement();
        String queryString = "SELECT platform_id, platform_string FROM platforms";
        try (ResultSet rs = st.executeQuery(queryString);){
            while (rs.next()) {
                this.platformsCache.put(rs.getString("platform_string"), rs.getInt("platform_id"));
            }
        }
        st = this.connection.createStatement();
        queryString = "SELECT version_id, version_string, recommended FROM versions";
        rs = st.executeQuery(queryString);
        var4_4 = null;
        try {
            while (rs.next()) {
                String version = rs.getString("version_string");
                int versionId = rs.getInt("version_id");
                boolean recommended = rs.getBoolean("recommended");
                this.versionsCache.put(version, versionId);
                if (!recommended) continue;
                this.recommendedVersions.add(version);
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (rs != null) {
                if (var4_4 != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    rs.close();
                }
            }
        }
        st = this.connection.createStatement();
        queryString = "SELECT flag_id, flag_string FROM flags";
        rs = st.executeQuery(queryString);
        var4_4 = null;
        try {
            while (rs.next()) {
                this.flagsCache.put(rs.getString("flag_string"), rs.getInt("flag_id"));
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (rs != null) {
                if (var4_4 != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    rs.close();
                }
            }
        }
    }

    void insertServerDescriptor(Ipv6ServerDescriptor serverDescriptor) throws SQLException {
        this.psServerDescriptorsSelect.clearParameters();
        this.psServerDescriptorsSelect.setString(1, serverDescriptor.digest);
        try (ResultSet rs = this.psServerDescriptorsSelect.executeQuery();){
            if (rs.next() && rs.getBoolean(1)) {
                return;
            }
        }
        this.psServerDescriptorsInsert.clearParameters();
        this.psServerDescriptorsInsert.setString(1, serverDescriptor.digest);
        if (null != serverDescriptor.platform) {
            this.psServerDescriptorsInsert.setInt(2, this.selectOrInsertPlatform(serverDescriptor.platform));
        } else {
            this.psServerDescriptorsInsert.setNull(2, 4);
        }
        if (null != serverDescriptor.version) {
            this.psServerDescriptorsInsert.setInt(3, this.selectOrInsertVersion(serverDescriptor.version, false));
        } else {
            this.psServerDescriptorsInsert.setNull(3, 4);
        }
        this.psServerDescriptorsInsert.setInt(4, serverDescriptor.advertisedBandwidth);
        this.psServerDescriptorsInsert.setBoolean(5, serverDescriptor.announced);
        this.psServerDescriptorsInsert.setBoolean(6, serverDescriptor.exiting);
        this.psServerDescriptorsInsert.execute();
    }

    int selectOrInsertPlatform(String platform) throws SQLException {
        if (!this.platformsCache.containsKey(platform)) {
            int platformId = -1;
            this.psPlatformsInsert.clearParameters();
            this.psPlatformsInsert.setString(1, platform);
            this.psPlatformsInsert.execute();
            try (ResultSet rs = this.psPlatformsInsert.getGeneratedKeys();){
                if (rs.next()) {
                    platformId = rs.getInt(1);
                }
            }
            if (platformId < 0) {
                throw new SQLException("Could not retrieve auto-generated key for new platforms entry.");
            }
            this.platformsCache.put(platform, platformId);
        }
        return this.platformsCache.get(platform);
    }

    int selectOrInsertVersion(String version, boolean recommended) throws SQLException {
        int versionId;
        if (!this.versionsCache.containsKey(version)) {
            versionId = -1;
            this.psVersionsInsert.clearParameters();
            this.psVersionsInsert.setString(1, version);
            this.psVersionsInsert.setBoolean(2, recommended);
            this.psVersionsInsert.execute();
            try (ResultSet rs = this.psVersionsInsert.getGeneratedKeys();){
                if (rs.next()) {
                    versionId = rs.getInt(1);
                }
            }
            if (versionId < 0) {
                throw new SQLException("Could not retrieve auto-generated key for new versions entry.");
            }
            this.versionsCache.put(version, versionId);
            if (recommended) {
                this.recommendedVersions.add(version);
            }
        }
        if (recommended && !this.recommendedVersions.contains(version)) {
            versionId = this.versionsCache.get(version);
            this.psVersionsUpdate.clearParameters();
            this.psVersionsUpdate.setInt(1, versionId);
            this.psVersionsUpdate.execute();
            this.recommendedVersions.add(version);
        }
        return this.versionsCache.get(version);
    }

    void insertStatus(Ipv6NetworkStatus networkStatus) throws SQLException {
        this.insertRecommendedVersions(networkStatus.recommendedVersions);
        this.psStatusesSelect.clearParameters();
        this.psStatusesSelect.setString(1, networkStatus.isRelay ? "relay" : "bridge");
        this.psStatusesSelect.setTimestamp(2, Timestamp.from(ZonedDateTime.of(networkStatus.timestamp, ZoneId.of("UTC")).toInstant()));
        ResultSet rs = this.psStatusesSelect.executeQuery();
        Object object = null;
        try {
            if (rs.next() && rs.getBoolean(1)) {
                return;
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (rs != null) {
                if (object != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    rs.close();
                }
            }
        }
        int statusId = -1;
        this.psStatusesInsert.clearParameters();
        this.psStatusesInsert.setString(1, networkStatus.isRelay ? "relay" : "bridge");
        this.psStatusesInsert.setTimestamp(2, Timestamp.from(ZonedDateTime.of(networkStatus.timestamp, ZoneId.of("UTC")).toInstant()));
        this.psStatusesInsert.setInt(3, networkStatus.running);
        if (null != networkStatus.totalConsensusWeight) {
            this.psStatusesInsert.setFloat(4, networkStatus.totalConsensusWeight.floatValue());
        } else {
            this.psStatusesInsert.setNull(4, 6);
        }
        if (null != networkStatus.totalGuardWeight) {
            this.psStatusesInsert.setFloat(5, networkStatus.totalGuardWeight.floatValue());
        } else {
            this.psStatusesInsert.setNull(5, 6);
        }
        if (null != networkStatus.totalMiddleWeight) {
            this.psStatusesInsert.setFloat(6, networkStatus.totalMiddleWeight.floatValue());
        } else {
            this.psStatusesInsert.setNull(6, 6);
        }
        if (null != networkStatus.totalExitWeight) {
            this.psStatusesInsert.setFloat(7, networkStatus.totalExitWeight.floatValue());
        } else {
            this.psStatusesInsert.setNull(7, 6);
        }
        this.psStatusesInsert.execute();
        try (ResultSet rs2 = this.psStatusesInsert.getGeneratedKeys();){
            if (rs2.next()) {
                statusId = rs2.getInt(1);
            }
        }
        if (statusId < 0) {
            throw new SQLException("Could not retrieve auto-generated key for new statuses entry.");
        }
        for (Ipv6NetworkStatus.Entry entry : networkStatus.entries) {
            this.insertStatusEntry(statusId, entry);
        }
        this.psStatusEntriesInsert.executeBatch();
    }

    void insertRecommendedVersions(List<String> versions) throws SQLException {
        if (null != versions && !this.versionsCache.keySet().containsAll(versions)) {
            for (String version : versions) {
                this.selectOrInsertVersion(version, true);
            }
        }
    }

    void insertStatusEntry(int statusId, Ipv6NetworkStatus.Entry entry) throws SQLException {
        this.insertFlags(entry.flags);
        int flags = 0;
        if (null != entry.flags) {
            for (String flag : entry.flags) {
                int flagId = this.flagsCache.get(flag);
                flags |= 1 << flagId;
            }
        }
        this.psStatusEntriesInsert.clearParameters();
        this.psStatusEntriesInsert.setInt(1, statusId);
        this.psStatusEntriesInsert.setString(2, entry.digest);
        this.psStatusEntriesInsert.setInt(3, flags);
        this.psStatusEntriesInsert.setBoolean(4, entry.reachable);
        if (null != entry.consensusWeight) {
            this.psStatusEntriesInsert.setFloat(5, entry.consensusWeight.floatValue());
        } else {
            this.psStatusEntriesInsert.setNull(5, 6);
        }
        if (null != entry.guardWeight) {
            this.psStatusEntriesInsert.setFloat(6, entry.guardWeight.floatValue());
        } else {
            this.psStatusEntriesInsert.setNull(6, 6);
        }
        if (null != entry.middleWeight) {
            this.psStatusEntriesInsert.setFloat(7, entry.middleWeight.floatValue());
        } else {
            this.psStatusEntriesInsert.setNull(7, 6);
        }
        if (null != entry.exitWeight) {
            this.psStatusEntriesInsert.setFloat(8, entry.exitWeight.floatValue());
        } else {
            this.psStatusEntriesInsert.setNull(8, 6);
        }
        this.psStatusEntriesInsert.addBatch();
    }

    void insertFlags(SortedSet<String> flags) throws SQLException {
        if (null != flags && !this.flagsCache.keySet().containsAll(flags)) {
            for (String flag : flags) {
                if (this.flagsCache.containsKey(flag)) continue;
                int flagId = this.flagsCache.size();
                this.psFlagsInsert.clearParameters();
                this.psFlagsInsert.setInt(1, flagId);
                this.psFlagsInsert.setString(2, flag);
                this.psFlagsInsert.execute();
                this.flagsCache.put(flag, flagId);
            }
        }
    }

    void aggregate() throws SQLException {
        Statement st = this.connection.createStatement();
        st.executeQuery("SELECT aggregate()");
    }

    void rollback() throws SQLException {
        this.connection.rollback();
    }

    void commit() throws SQLException {
        this.connection.commit();
    }

    List<String[]> queryServersIpv6() throws SQLException {
        ArrayList<String[]> statistics = new ArrayList<String[]>();
        String columns = "valid_after_date, server, guard_relay, exit_relay, announced_ipv6, exiting_ipv6_relay, reachable_ipv6_relay, server_count_sum_avg, advertised_bandwidth_bytes_sum_avg";
        statistics.add(columns.split(", "));
        Statement st = this.connection.createStatement();
        String queryString = "SELECT " + columns + " FROM ipv6servers";
        try (ResultSet rs = st.executeQuery(queryString);){
            while (rs.next()) {
                String[] outputLine = new String[]{rs.getDate("valid_after_date").toLocalDate().toString(), rs.getString("server"), rs.getString("guard_relay"), rs.getString("exit_relay"), rs.getString("announced_ipv6"), rs.getString("exiting_ipv6_relay"), rs.getString("reachable_ipv6_relay"), Database.getLongFromResultSet(rs, "server_count_sum_avg"), Database.getLongFromResultSet(rs, "advertised_bandwidth_bytes_sum_avg")};
                statistics.add(outputLine);
            }
        }
        return statistics;
    }

    List<String[]> queryAdvbw() throws SQLException {
        ArrayList<String[]> statistics = new ArrayList<String[]>();
        String columns = "date, isexit, isguard, advbw";
        statistics.add(columns.split(", "));
        Statement st = this.connection.createStatement();
        String queryString = "SELECT " + columns + " FROM bandwidth_advbw";
        try (ResultSet rs = st.executeQuery(queryString);){
            while (rs.next()) {
                String[] outputLine = new String[]{rs.getDate("date").toLocalDate().toString(), rs.getString("isexit"), rs.getString("isguard"), Database.getLongFromResultSet(rs, "advbw")};
                statistics.add(outputLine);
            }
        }
        return statistics;
    }

    List<String[]> queryNetworksize() throws SQLException {
        ArrayList<String[]> statistics = new ArrayList<String[]>();
        String columns = "date, relays, bridges";
        statistics.add(columns.split(", "));
        Statement st = this.connection.createStatement();
        String queryString = "SELECT " + columns + " FROM servers_networksize";
        try (ResultSet rs = st.executeQuery(queryString);){
            while (rs.next()) {
                String[] outputLine = new String[]{rs.getDate("date").toLocalDate().toString(), Database.getLongFromResultSet(rs, "relays"), Database.getLongFromResultSet(rs, "bridges")};
                statistics.add(outputLine);
            }
        }
        return statistics;
    }

    List<String[]> queryRelayflags() throws SQLException {
        ArrayList<String[]> statistics = new ArrayList<String[]>();
        String columns = "date, flag, relays";
        statistics.add(columns.split(", "));
        Statement st = this.connection.createStatement();
        String queryString = "SELECT " + columns + " FROM servers_relayflags";
        try (ResultSet rs = st.executeQuery(queryString);){
            while (rs.next()) {
                String[] outputLine = new String[]{rs.getDate("date").toLocalDate().toString(), rs.getString("flag"), Database.getLongFromResultSet(rs, "relays")};
                statistics.add(outputLine);
            }
        }
        return statistics;
    }

    List<String[]> queryVersions() throws SQLException {
        ArrayList<String[]> statistics = new ArrayList<String[]>();
        String columns = "date, version, relays";
        statistics.add(columns.split(", "));
        Statement st = this.connection.createStatement();
        String queryString = "SELECT " + columns + " FROM servers_versions";
        try (ResultSet rs = st.executeQuery(queryString);){
            while (rs.next()) {
                String[] outputLine = new String[]{rs.getDate("date").toLocalDate().toString(), rs.getString("version"), Database.getLongFromResultSet(rs, "relays")};
                statistics.add(outputLine);
            }
        }
        return statistics;
    }

    List<String[]> queryPlatforms() throws SQLException {
        ArrayList<String[]> statistics = new ArrayList<String[]>();
        String columns = "date, platform, relays";
        statistics.add(columns.split(", "));
        Statement st = this.connection.createStatement();
        String queryString = "SELECT " + columns + " FROM servers_platforms";
        try (ResultSet rs = st.executeQuery(queryString);){
            while (rs.next()) {
                String[] outputLine = new String[]{rs.getDate("date").toLocalDate().toString(), rs.getString("platform"), Database.getLongFromResultSet(rs, "relays")};
                statistics.add(outputLine);
            }
        }
        return statistics;
    }

    private static String getLongFromResultSet(ResultSet rs, String columnLabel) throws SQLException {
        long result = rs.getLong(columnLabel);
        return rs.wasNull() ? null : String.valueOf(result);
    }

    @Override
    public void close() throws SQLException {
        this.connection.close();
    }
}

