/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.FileStoreOutputStream;
import org.h2.store.fs.FileSystem;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueLob;

public class ValueLob2
extends Value {
    public static final int TABLE_ID_SESSION_VARIABLE = -1;
    private final int type;
    private long precision;
    private DataHandler handler;
    private int tableId;
    private long lobId;
    private String fileName;
    private boolean linked;
    private byte[] small;
    private int hash;
    private boolean compression;
    private FileStore tempFile;

    private ValueLob2(int n, DataHandler dataHandler, String string, int n2, long l, boolean bl, long l2, boolean bl2) {
        this.type = n;
        this.handler = dataHandler;
        this.fileName = string;
        this.tableId = n2;
        this.lobId = l;
        this.linked = bl;
        this.precision = l2;
        this.compression = bl2;
    }

    private ValueLob2(int n, byte[] byArray) {
        this.type = n;
        this.small = byArray;
        if (byArray != null) {
            this.precision = n == 15 ? (long)byArray.length : (long)this.getString().length();
        }
    }

    private static ValueLob2 copy(ValueLob2 valueLob2) {
        ValueLob2 valueLob22 = new ValueLob2(valueLob2.type, valueLob2.handler, valueLob2.fileName, valueLob2.tableId, valueLob2.lobId, valueLob2.linked, valueLob2.precision, valueLob2.compression);
        valueLob22.small = valueLob2.small;
        valueLob22.hash = valueLob2.hash;
        return valueLob22;
    }

    public static ValueLob2 createSmallLob(int n, byte[] byArray) {
        return new ValueLob2(n, byArray);
    }

    private static String getFileName(DataHandler dataHandler, int n, long l) {
        if (SysProperties.CHECK && n == 0 && l == 0L) {
            DbException.throwInternalError("0 LOB");
        }
        String string = n < 0 ? ".temp" : ".t" + n;
        return ValueLob2.getFileNamePrefix(dataHandler.getDatabasePath(), l) + string + ".lob.db";
    }

    public static ValueLob2 open(int n, DataHandler dataHandler, int n2, int n3, long l, boolean bl) {
        String string = ValueLob2.getFileName(dataHandler, n2, n3);
        return new ValueLob2(n, dataHandler, string, n2, n3, true, l, bl);
    }

    public static ValueLob2 createClob(Reader reader, long l, DataHandler dataHandler) {
        try {
            char[] cArray;
            Object object;
            int n;
            boolean bl = dataHandler.getLobCompressionAlgorithm(16) != null;
            long l2 = Long.MAX_VALUE;
            if (l >= 0L && l < l2) {
                l2 = l;
            }
            if ((n = ValueLob2.getBufferSize(dataHandler, bl, l2)) >= Integer.MAX_VALUE) {
                object = IOUtils.readStringAndClose(reader, -1);
                cArray = ((String)object).toCharArray();
                n = cArray.length;
            } else {
                cArray = new char[n];
                int n2 = n = (n = IOUtils.readFully(reader, cArray, n)) < 0 ? 0 : n;
            }
            if (n <= dataHandler.getMaxLengthInplaceLob()) {
                object = StringUtils.utf8Encode(new String(cArray, 0, n));
                return ValueLob2.createSmallLob(16, (byte[])object);
            }
            object = new ValueLob2(16, null);
            super.createFromReader(cArray, n, reader, l2, dataHandler);
            return object;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    private static int getBufferSize(DataHandler dataHandler, boolean bl, long l) {
        long l2;
        long l3;
        if (l < 0L || l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        if ((l3 = (long)dataHandler.getMaxLengthInplaceLob()) >= Integer.MAX_VALUE) {
            l3 = l;
        }
        long l4 = l2 = bl ? 131072L : 4096L;
        if (l2 < l && l2 <= l3) {
            l2 = Math.min(l, l3 + 1L);
            l2 = MathUtils.roundUpLong(l2, 4096L);
        }
        l2 = Math.min(l, l2);
        if ((l2 = (long)MathUtils.convertLongToInt(l2)) < 0L) {
            l2 = Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFromReader(char[] cArray, int n, Reader reader, long l, DataHandler dataHandler) {
        try {
            FileStoreOutputStream fileStoreOutputStream = this.initLarge(dataHandler);
            boolean bl = dataHandler.getLobCompressionAlgorithm(16) != null;
            try {
                do {
                    this.precision += (long)n;
                    byte[] byArray = StringUtils.utf8Encode(new String(cArray, 0, n));
                    fileStoreOutputStream.write(byArray, 0, byArray.length);
                    if ((l -= (long)n) <= 0L) {
                        break;
                    }
                    n = ValueLob2.getBufferSize(dataHandler, bl, l);
                } while ((n = IOUtils.readFully(reader, cArray, n)) > 0);
            }
            finally {
                fileStoreOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    private static String getFileNamePrefix(String string, long l) {
        return IOUtils.normalize(string + l);
    }

    public static ValueLob2 createBlob(InputStream inputStream, long l, DataHandler dataHandler) {
        try {
            byte[] byArray;
            int n;
            boolean bl;
            long l2 = Long.MAX_VALUE;
            boolean bl2 = bl = dataHandler.getLobCompressionAlgorithm(15) != null;
            if (l >= 0L && l < l2) {
                l2 = l;
            }
            if ((n = ValueLob2.getBufferSize(dataHandler, bl, l2)) >= Integer.MAX_VALUE) {
                byArray = IOUtils.readBytesAndClose(inputStream, -1);
                n = byArray.length;
            } else {
                byArray = Utils.newBytes(n);
                n = IOUtils.readFully(inputStream, byArray, 0, n);
            }
            if (n <= dataHandler.getMaxLengthInplaceLob()) {
                byte[] byArray2 = Utils.newBytes(n);
                System.arraycopy(byArray, 0, byArray2, 0, n);
                return ValueLob2.createSmallLob(15, byArray2);
            }
            ValueLob2 valueLob2 = new ValueLob2(15, null);
            valueLob2.createFromStream(byArray, n, inputStream, l2, dataHandler);
            return valueLob2;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileStoreOutputStream initLarge(DataHandler dataHandler) {
        this.handler = dataHandler;
        this.tableId = 0;
        this.linked = false;
        this.precision = 0L;
        this.small = null;
        this.hash = 0;
        String string = dataHandler.getLobCompressionAlgorithm(this.type);
        this.compression = string != null;
        Object object = dataHandler;
        synchronized (object) {
            this.lobId = this.getNewObjectId(dataHandler);
            this.fileName = ValueLob2.getFileNamePrefix(dataHandler.getDatabasePath(), this.lobId) + ".temp.db";
            this.tempFile = dataHandler.openFile(this.fileName, "rw", false);
            this.tempFile.autoDelete();
        }
        object = new FileStoreOutputStream(this.tempFile, dataHandler, string);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFromStream(byte[] byArray, int n, InputStream inputStream, long l, DataHandler dataHandler) {
        try {
            FileStoreOutputStream fileStoreOutputStream = this.initLarge(dataHandler);
            boolean bl = dataHandler.getLobCompressionAlgorithm(15) != null;
            try {
                do {
                    this.precision += (long)n;
                    fileStoreOutputStream.write(byArray, 0, n);
                    if ((l -= (long)n) <= 0L) {
                        break;
                    }
                    n = ValueLob2.getBufferSize(dataHandler, bl, l);
                } while ((n = IOUtils.readFully(inputStream, byArray, 0, n)) > 0);
            }
            finally {
                fileStoreOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    public Value convertTo(int n) {
        if (n == this.type) {
            return this;
        }
        if (n == 16) {
            ValueLob2 valueLob2 = ValueLob2.createClob(this.getReader(), -1L, this.handler);
            return valueLob2;
        }
        if (n == 15) {
            ValueLob2 valueLob2 = ValueLob2.createBlob(this.getInputStream(), -1L, this.handler);
            return valueLob2;
        }
        return super.convertTo(n);
    }

    public boolean isLinked() {
        return this.linked;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void close() {
        if (this.fileName != null) {
            if (this.tempFile != null) {
                this.tempFile.stopAutoDelete();
            }
            ValueLob2.deleteFile(this.handler, this.fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlink() {
        if (this.linked && this.fileName != null) {
            DataHandler dataHandler = this.handler;
            synchronized (dataHandler) {
                String string = ValueLob2.getFileName(this.handler, -1, this.lobId);
                ValueLob2.deleteFile(this.handler, string);
                ValueLob2.renameFile(this.handler, this.fileName, string);
                this.tempFile = FileStore.open(this.handler, string, "rw");
                this.tempFile.autoDelete();
                this.tempFile.closeSilently();
                this.fileName = string;
                this.linked = false;
            }
        }
    }

    public Value link(DataHandler dataHandler, int n) {
        if (this.fileName == null) {
            this.tableId = n;
            return this;
        }
        if (this.linked) {
            ValueLob2 valueLob2 = ValueLob2.copy(this);
            valueLob2.lobId = this.getNewObjectId(dataHandler);
            valueLob2.tableId = n;
            String string = ValueLob2.getFileName(dataHandler, valueLob2.tableId, valueLob2.lobId);
            this.copyFileTo(dataHandler, this.fileName, string);
            valueLob2.fileName = string;
            valueLob2.linked = true;
            return valueLob2;
        }
        if (!this.linked) {
            this.tableId = n;
            String string = ValueLob2.getFileName(dataHandler, this.tableId, this.lobId);
            if (this.tempFile != null) {
                this.tempFile.stopAutoDelete();
                this.tempFile = null;
            }
            ValueLob2.renameFile(dataHandler, this.fileName, string);
            this.fileName = string;
            this.linked = true;
        }
        return this;
    }

    private int getNewObjectId(DataHandler dataHandler) {
        return 0;
    }

    public int getTableId() {
        return this.tableId;
    }

    public int getType() {
        return this.type;
    }

    public long getPrecision() {
        return this.precision;
    }

    public String getString() {
        int n = this.precision > Integer.MAX_VALUE || this.precision == 0L ? Integer.MAX_VALUE : (int)this.precision;
        try {
            if (this.type == 16) {
                if (this.small != null) {
                    return StringUtils.utf8Decode(this.small);
                }
                return IOUtils.readStringAndClose(this.getReader(), n);
            }
            byte[] byArray = this.small != null ? this.small : IOUtils.readBytesAndClose(this.getInputStream(), n);
            return Utils.convertBytesToString(byArray);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.fileName);
        }
    }

    public byte[] getBytes() {
        if (this.type == 16) {
            return super.getBytes();
        }
        byte[] byArray = this.getBytesNoCopy();
        return Utils.cloneByteArray(byArray);
    }

    public byte[] getBytesNoCopy() {
        if (this.type == 16) {
            return super.getBytesNoCopy();
        }
        if (this.small != null) {
            return this.small;
        }
        try {
            return IOUtils.readBytesAndClose(this.getInputStream(), Integer.MAX_VALUE);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.fileName);
        }
    }

    public int hashCode() {
        if (this.hash == 0) {
            if (this.precision > 4096L) {
                return (int)(this.precision ^ this.precision >>> 32);
            }
            this.hash = this.type == 16 ? this.getString().hashCode() : Utils.getByteArrayHash(this.getBytes());
        }
        return this.hash;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        if (this.type == 16) {
            return Integer.signum(this.getString().compareTo(value.getString()));
        }
        byte[] byArray = value.getBytesNoCopy();
        return Utils.compareNotNull(this.getBytes(), byArray);
    }

    public Object getObject() {
        if (this.type == 16) {
            return this.getReader();
        }
        return this.getInputStream();
    }

    public Reader getReader() {
        return IOUtils.getReader(this.getInputStream());
    }

    public InputStream getInputStream() {
        if (this.fileName == null) {
            return new ByteArrayInputStream(this.small);
        }
        FileStore fileStore = this.handler.openFile(this.fileName, "r", true);
        boolean bl = SysProperties.lobCloseBetweenReads;
        return new BufferedInputStream(new FileStoreInputStream(fileStore, this.handler, this.compression, bl), 4096);
    }

    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        long l = this.getPrecision();
        if (l > Integer.MAX_VALUE || l <= 0L) {
            l = -1L;
        }
        if (this.type == 15) {
            preparedStatement.setBinaryStream(n, this.getInputStream(), (int)l);
        } else {
            preparedStatement.setCharacterStream(n, this.getReader(), (int)l);
        }
    }

    public String getSQL() {
        if (this.type == 16) {
            String string = this.getString();
            return StringUtils.quoteStringSQL(string);
        }
        byte[] byArray = this.getBytes();
        String string = Utils.convertBytesToString(byArray);
        return "X'" + string + "'";
    }

    public String getTraceSQL() {
        if (this.small != null && this.getPrecision() <= SysProperties.MAX_TRACE_DATA_LENGTH) {
            return this.getSQL();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.type == 16) {
            stringBuilder.append("SPACE(").append(this.getPrecision());
        } else {
            stringBuilder.append("CAST(REPEAT('00', ").append(this.getPrecision()).append(") AS BINARY");
        }
        stringBuilder.append(" /* ").append(this.fileName).append(" */)");
        return stringBuilder.toString();
    }

    public byte[] getSmall() {
        return this.small;
    }

    public int getDisplaySize() {
        return MathUtils.convertLongToInt(this.getPrecision());
    }

    public boolean equals(Object object) {
        return object instanceof ValueLob && this.compareSecure((Value)object, null) == 0;
    }

    public void convertToFileIfRequired(DataHandler dataHandler) {
        if (this.small != null && this.small.length > dataHandler.getMaxLengthInplaceLob()) {
            boolean bl = dataHandler.getLobCompressionAlgorithm(this.type) != null;
            int n = ValueLob2.getBufferSize(dataHandler, bl, Long.MAX_VALUE);
            int n2 = this.tableId;
            if (this.type == 15) {
                this.createFromStream(Utils.newBytes(n), 0, this.getInputStream(), Long.MAX_VALUE, dataHandler);
            } else {
                this.createFromReader(new char[n], 0, this.getReader(), Long.MAX_VALUE, dataHandler);
            }
            Value value = this.link(dataHandler, n2);
            if (SysProperties.CHECK && value != this) {
                DbException.throwInternalError();
            }
        }
    }

    public static void removeAllForTable(DataHandler dataHandler, int n) {
        String string = ValueLob2.getFileNamePrefix(dataHandler.getDatabasePath(), 0L);
        ValueLob2.removeAllForTable(dataHandler, string, n);
    }

    private static void removeAllForTable(DataHandler dataHandler, String string, int n) {
        for (String string2 : IOUtils.listFiles(string)) {
            if (IOUtils.isDirectory(string2)) {
                ValueLob2.removeAllForTable(dataHandler, string2, n);
                continue;
            }
            if (!string2.endsWith(".t" + n + ".lob.db")) continue;
            ValueLob2.deleteFile(dataHandler, string2);
        }
    }

    public boolean useCompression() {
        return this.compression;
    }

    public boolean isFileBased() {
        return this.fileName != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void deleteFile(DataHandler dataHandler, String string) {
        Object object = dataHandler.getLobSyncObject();
        synchronized (object) {
            IOUtils.delete(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void renameFile(DataHandler dataHandler, String string, String string2) {
        Object object = dataHandler.getLobSyncObject();
        synchronized (object) {
            IOUtils.rename(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileTo(DataHandler dataHandler, String string, String string2) {
        Object object = dataHandler.getLobSyncObject();
        synchronized (object) {
            FileSystem.getInstance(string).copy(string, string2);
        }
    }

    public void setFileName(String string, boolean bl) {
        this.fileName = string;
        this.linked = bl;
    }

    public int getMemory() {
        if (this.small != null) {
            return this.small.length + 32;
        }
        return 128;
    }

    public ValueLob2 copyToTemp() {
        ValueLob2 valueLob2 = this.type == 16 ? ValueLob2.createClob(this.getReader(), this.precision, this.handler) : ValueLob2.createBlob(this.getInputStream(), this.precision, this.handler);
        return valueLob2;
    }

    public long getLobId() {
        return this.lobId;
    }
}

