/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;

public class SynchronizedHistogram
extends Histogram {
    private LongBuffer cachedDstLongBuffer = null;
    private ByteBuffer cachedDstByteBuffer = null;
    private int cachedDstByteBufferPosition = 0;

    @Override
    synchronized long getCountAtIndex(int index) {
        return this.counts[this.normalizeIndex(index, this.normalizingIndexOffset)];
    }

    @Override
    synchronized long getCountAtNormalizedIndex(int index) {
        return this.counts[index];
    }

    @Override
    synchronized void incrementCountAtIndex(int index) {
        int n = this.normalizeIndex(index, this.normalizingIndexOffset);
        this.counts[n] = this.counts[n] + 1L;
    }

    @Override
    synchronized void addToCountAtIndex(int index, long value) {
        int n = this.normalizeIndex(index, this.normalizingIndexOffset);
        this.counts[n] = this.counts[n] + value;
    }

    @Override
    synchronized void setCountAtIndex(int index, long value) {
        this.counts[this.normalizeIndex((int)index, (int)this.normalizingIndexOffset)] = value;
    }

    @Override
    synchronized void setCountAtNormalizedIndex(int index, long value) {
        this.counts[index] = value;
    }

    @Override
    synchronized int getNormalizingIndexOffset() {
        return this.normalizingIndexOffset;
    }

    @Override
    synchronized void setNormalizingIndexOffset(int normalizingIndexOffset) {
        this.normalizingIndexOffset = normalizingIndexOffset;
    }

    @Override
    synchronized void shiftNormalizingIndexByOffset(int offsetToAdd, boolean lowestHalfBucketPopulated) {
        this.nonConcurrentNormalizingIndexShift(offsetToAdd, lowestHalfBucketPopulated);
    }

    @Override
    synchronized void clearCounts() {
        Arrays.fill(this.counts, 0L);
        this.totalCount = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(AbstractHistogram otherHistogram) {
        if (this.identity < otherHistogram.identity) {
            SynchronizedHistogram synchronizedHistogram = this;
            synchronized (synchronizedHistogram) {
                AbstractHistogram abstractHistogram = otherHistogram;
                synchronized (abstractHistogram) {
                    super.add(otherHistogram);
                }
            }
        }
        AbstractHistogram abstractHistogram = otherHistogram;
        synchronized (abstractHistogram) {
            SynchronizedHistogram synchronizedHistogram = this;
            synchronized (synchronizedHistogram) {
                super.add(otherHistogram);
            }
        }
    }

    @Override
    public synchronized void shiftValuesLeft(int numberOfBinaryOrdersOfMagnitude) {
        super.shiftValuesLeft(numberOfBinaryOrdersOfMagnitude);
    }

    @Override
    public synchronized void shiftValuesRight(int numberOfBinaryOrdersOfMagnitude) {
        super.shiftValuesRight(numberOfBinaryOrdersOfMagnitude);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedHistogram copy() {
        SynchronizedHistogram copy;
        SynchronizedHistogram synchronizedHistogram = this;
        synchronized (synchronizedHistogram) {
            copy = new SynchronizedHistogram(this);
        }
        copy.add(this);
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedHistogram copyCorrectedForCoordinatedOmission(long expectedIntervalBetweenValueSamples) {
        SynchronizedHistogram synchronizedHistogram = this;
        synchronized (synchronizedHistogram) {
            SynchronizedHistogram toHistogram = new SynchronizedHistogram(this);
            toHistogram.addWhileCorrectingForCoordinatedOmission(this, expectedIntervalBetweenValueSamples);
            return toHistogram;
        }
    }

    @Override
    public long getTotalCount() {
        return this.totalCount;
    }

    @Override
    synchronized void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    @Override
    synchronized void incrementTotalCount() {
        ++this.totalCount;
    }

    @Override
    synchronized void addToTotalCount(long value) {
        this.totalCount += value;
    }

    @Override
    synchronized void updatedMaxValue(long maxValue) {
        if (maxValue > this.getMaxValue()) {
            super.updatedMaxValue(maxValue);
        }
    }

    @Override
    synchronized void updateMinNonZeroValue(long minNonZeroValue) {
        if (minNonZeroValue < this.getMinNonZeroValue()) {
            super.updateMinNonZeroValue(minNonZeroValue);
        }
    }

    @Override
    synchronized int _getEstimatedFootprintInBytes() {
        return 512 + 8 * this.counts.length;
    }

    @Override
    synchronized void resize(long newHighestTrackableValue) {
        int oldNormalizedZeroIndex = this.normalizeIndex(0, this.normalizingIndexOffset);
        this.establishSize(newHighestTrackableValue);
        int countsDelta = this.countsArrayLength - this.counts.length;
        this.counts = Arrays.copyOf(this.counts, this.countsArrayLength);
        if (oldNormalizedZeroIndex != 0) {
            int newNormalizedZeroIndex = oldNormalizedZeroIndex + countsDelta;
            int lengthToCopy = this.countsArrayLength - countsDelta - oldNormalizedZeroIndex;
            System.arraycopy(this.counts, oldNormalizedZeroIndex, this.counts, newNormalizedZeroIndex, lengthToCopy);
        }
    }

    public SynchronizedHistogram(int numberOfSignificantValueDigits) {
        this(1L, 2L, numberOfSignificantValueDigits);
        this.setAutoResize(true);
    }

    public SynchronizedHistogram(long highestTrackableValue, int numberOfSignificantValueDigits) {
        this(1L, highestTrackableValue, numberOfSignificantValueDigits);
    }

    public SynchronizedHistogram(long lowestDiscernibleValue, long highestTrackableValue, int numberOfSignificantValueDigits) {
        super(lowestDiscernibleValue, highestTrackableValue, numberOfSignificantValueDigits);
    }

    public SynchronizedHistogram(AbstractHistogram source) {
        super(source);
    }

    public static SynchronizedHistogram decodeFromByteBuffer(ByteBuffer buffer, long minBarForHighestTrackableValue) {
        return (SynchronizedHistogram)SynchronizedHistogram.decodeFromByteBuffer(buffer, SynchronizedHistogram.class, minBarForHighestTrackableValue);
    }

    public static SynchronizedHistogram decodeFromCompressedByteBuffer(ByteBuffer buffer, long minBarForHighestTrackableValue) throws DataFormatException {
        return (SynchronizedHistogram)SynchronizedHistogram.decodeFromCompressedByteBuffer(buffer, SynchronizedHistogram.class, minBarForHighestTrackableValue);
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        o.defaultReadObject();
    }

    @Override
    synchronized void fillCountsArrayFromBuffer(ByteBuffer buffer, int length) {
        buffer.asLongBuffer().get(this.counts, 0, length);
    }

    @Override
    synchronized void fillBufferFromCountsArray(ByteBuffer buffer, int length) {
        if (this.cachedDstLongBuffer == null || buffer != this.cachedDstByteBuffer || buffer.position() != this.cachedDstByteBufferPosition) {
            this.cachedDstByteBuffer = buffer;
            this.cachedDstByteBufferPosition = buffer.position();
            this.cachedDstLongBuffer = buffer.asLongBuffer();
        }
        this.cachedDstLongBuffer.rewind();
        int zeroIndex = this.normalizeIndex(0, this.getNormalizingIndexOffset());
        int lengthFromZeroIndexToEnd = Math.min(length, this.countsArrayLength - zeroIndex);
        int remainingLengthFromNormalizedZeroIndex = length - lengthFromZeroIndexToEnd;
        this.cachedDstLongBuffer.put(this.counts, zeroIndex, lengthFromZeroIndexToEnd);
        this.cachedDstLongBuffer.put(this.counts, 0, remainingLengthFromNormalizedZeroIndex);
    }
}

