/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.bridgedb;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.BridgedbMetrics;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorSourceFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);
    private static final Path bridgedbStatsCsvFile = org.torproject.metrics.stats.main.Main.modulesDir.toPath().resolve("bridgedb/stats/bridgedb-stats.csv");
    private static File[] descriptorsDirectories = new File[]{new File(org.torproject.metrics.stats.main.Main.descriptorsDir, "archive/bridgedb-metrics"), new File(org.torproject.metrics.stats.main.Main.descriptorsDir, "recent/bridgedb-metrics")};

    public static void main(String[] args) throws IOException {
        SortedMap<String, Long> previousStatistics = Main.readBridgedbStatsFile(bridgedbStatsCsvFile);
        SortedMap<String, Long> currentStatistics = Main.parseStatistics(previousStatistics, descriptorsDirectories);
        Main.writeBridgedbStatsFile(bridgedbStatsCsvFile, currentStatistics);
    }

    static SortedMap<String, Long> readBridgedbStatsFile(Path bridgedbStatsCsvFile) throws IOException {
        TreeMap<String, Long> readStatistics = new TreeMap<String, Long>();
        if (Files.exists(bridgedbStatsCsvFile, new LinkOption[0])) {
            for (String line : Files.readAllLines(bridgedbStatsCsvFile)) {
                if (line.startsWith("date")) continue;
                String[] lineParts = line.split(",");
                if (lineParts.length != 4) {
                    logger.warn("Skipping unrecognized line '{}' in {}.", (Object)line, (Object)bridgedbStatsCsvFile.toAbsolutePath());
                    continue;
                }
                String key = String.format("%s,%s,%s", lineParts[0], lineParts[1], lineParts[2]);
                long value = Long.parseLong(lineParts[3]);
                readStatistics.put(key, value);
            }
            logger.debug("Read {} containing {} non-header lines.", (Object)bridgedbStatsCsvFile, (Object)readStatistics.size());
        }
        return readStatistics;
    }

    static SortedMap<String, Long> parseStatistics(SortedMap<String, Long> previousStatistics, File[] descriptorsDirectories) {
        TreeMap<String, Long> currentStatistics = new TreeMap<String, Long>(previousStatistics);
        for (Descriptor descriptor : DescriptorSourceFactory.createDescriptorReader().readDescriptors(descriptorsDirectories)) {
            if (!(descriptor instanceof BridgedbMetrics)) continue;
            BridgedbMetrics bridgedbMetrics = (BridgedbMetrics)descriptor;
            if (!bridgedbMetrics.bridgedbMetricsVersion().startsWith("1") && !bridgedbMetrics.bridgedbMetricsVersion().startsWith("2")) {
                logger.warn("Unable to process BridgeDB metrics version {} > 2.", (Object)bridgedbMetrics.bridgedbMetricsVersion());
                continue;
            }
            if (!bridgedbMetrics.bridgedbMetricCounts().isPresent()) continue;
            String bridgedbMetricsEndDate = bridgedbMetrics.bridgedbMetricsEnd().toLocalDate().toString();
            TreeMap<String, Long> parsedStatistics = new TreeMap<String, Long>();
            for (Map.Entry bridgedbMetricCount : ((Map)bridgedbMetrics.bridgedbMetricCounts().get()).entrySet()) {
                String distributor;
                String[] keyParts = ((String)bridgedbMetricCount.getKey()).split("\\.");
                if (keyParts.length < 3 || (distributor = keyParts[0]).equals("internal")) continue;
                if ((Long)bridgedbMetricCount.getValue() < 10L) {
                    logger.warn("Skipping too small BridgeDB metric count {} < 10 in {}.", bridgedbMetricCount.getValue(), (Object)descriptor.getDescriptorFile().getAbsolutePath());
                    continue;
                }
                String transport = keyParts[1];
                String ccOrEmail = keyParts[2];
                if (ccOrEmail.equals("zz")) continue;
                String key = String.format("%s,%s,%s", bridgedbMetricsEndDate, distributor, transport);
                long countsSoFar = parsedStatistics.getOrDefault(key, 0L);
                parsedStatistics.put(key, countsSoFar += (Long)bridgedbMetricCount.getValue() - 5L);
            }
            if (!Collections.disjoint(currentStatistics.keySet(), parsedStatistics.keySet())) continue;
            currentStatistics.putAll(parsedStatistics);
        }
        return currentStatistics;
    }

    static void writeBridgedbStatsFile(Path bridgedbStatsCsvFile, SortedMap<String, Long> currentStatistics) throws IOException {
        if (!Files.exists(bridgedbStatsCsvFile.getParent(), new LinkOption[0])) {
            Files.createDirectories(bridgedbStatsCsvFile.getParent(), new FileAttribute[0]);
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("date,distributor,transport,requests");
        for (Map.Entry<String, Long> statistic : currentStatistics.entrySet()) {
            lines.add(String.format("%s,%d", statistic.getKey(), statistic.getValue()));
        }
        Files.write(bridgedbStatsCsvFile, lines, StandardOpenOption.CREATE);
        logger.debug("Wrote {} containing {} non-header lines.", (Object)bridgedbStatsCsvFile, (Object)(lines.size() - 1));
    }
}

