/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.ByteCodeElement;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.ModifierReviewable;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.NamedElement;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.annotation.AnnotatedCodeElement;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.annotation.AnnotationDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.annotation.AnnotationList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDefinition;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackSize;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatcher;

public interface ParameterDescription
extends AnnotatedCodeElement,
NamedElement.WithRuntimeName,
ModifierReviewable,
ByteCodeElement.TypeDependant<InDefinedShape, Token> {
    public static final String NAME_PREFIX = "arg";

    public TypeDescription.Generic getType();

    public MethodDescription getDeclaringMethod();

    public int getIndex();

    public boolean isNamed();

    public boolean hasModifiers();

    public int getOffset();

    public static class Token
    implements ByteCodeElement.Token<Token> {
        public static final String NO_NAME = null;
        public static final Integer NO_MODIFIERS = null;
        private final TypeDescription.Generic type;
        private final List<? extends AnnotationDescription> annotations;
        private final String name;
        private final Integer modifiers;

        public Token(TypeDescription.Generic type) {
            this(type, Collections.emptyList());
        }

        public Token(TypeDescription.Generic type, List<? extends AnnotationDescription> annotations) {
            this(type, annotations, NO_NAME, NO_MODIFIERS);
        }

        public Token(TypeDescription.Generic type, String name, Integer modifiers) {
            this(type, Collections.emptyList(), name, modifiers);
        }

        public Token(TypeDescription.Generic type, List<? extends AnnotationDescription> annotations, String name, Integer modifiers) {
            this.type = type;
            this.annotations = annotations;
            this.name = name;
            this.modifiers = modifiers;
        }

        public TypeDescription.Generic getType() {
            return this.type;
        }

        public AnnotationList getAnnotations() {
            return new AnnotationList.Explicit(this.annotations);
        }

        public String getName() {
            return this.name;
        }

        public Integer getModifiers() {
            return this.modifiers;
        }

        @Override
        public Token accept(TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor) {
            return new Token(this.type.accept(visitor), this.annotations, this.name, this.modifiers);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Token token = (Token)other;
            return this.type.equals(token.type) && this.annotations.equals(token.annotations) && (this.name != null ? this.name.equals(token.name) : token.name == null) && (this.modifiers != null ? this.modifiers.equals(token.modifiers) : token.modifiers == null);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.annotations.hashCode();
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.modifiers != null ? this.modifiers.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ParameterDescription.Token{type=" + this.type + ", annotations=" + this.annotations + ", name=" + (this.name == null ? null : "'" + this.name + '\'') + ", modifiers=" + this.modifiers + '}';
        }

        public static class TypeList
        extends AbstractList<Token> {
            private final List<? extends TypeDefinition> typeDescriptions;

            public TypeList(List<? extends TypeDefinition> typeDescriptions) {
                this.typeDescriptions = typeDescriptions;
            }

            @Override
            public Token get(int index) {
                return new Token(this.typeDescriptions.get(index).asGenericType());
            }

            @Override
            public int size() {
                return this.typeDescriptions.size();
            }
        }
    }

    public static class TypeSubstituting
    extends AbstractBase
    implements InGenericShape {
        private final MethodDescription.InGenericShape declaringMethod;
        private final ParameterDescription parameterDescription;
        private final TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor;

        public TypeSubstituting(MethodDescription.InGenericShape declaringMethod, ParameterDescription parameterDescription, TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor) {
            this.declaringMethod = declaringMethod;
            this.parameterDescription = parameterDescription;
            this.visitor = visitor;
        }

        @Override
        public TypeDescription.Generic getType() {
            return this.parameterDescription.getType().accept(this.visitor);
        }

        @Override
        public MethodDescription.InGenericShape getDeclaringMethod() {
            return this.declaringMethod;
        }

        @Override
        public int getIndex() {
            return this.parameterDescription.getIndex();
        }

        @Override
        public boolean isNamed() {
            return this.parameterDescription.isNamed();
        }

        @Override
        public boolean hasModifiers() {
            return this.parameterDescription.hasModifiers();
        }

        @Override
        public int getOffset() {
            return this.parameterDescription.getOffset();
        }

        @Override
        public String getName() {
            return this.parameterDescription.getName();
        }

        @Override
        public int getModifiers() {
            return this.parameterDescription.getModifiers();
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return this.parameterDescription.getDeclaredAnnotations();
        }

        @Override
        public InDefinedShape asDefined() {
            return (InDefinedShape)this.parameterDescription.asDefined();
        }
    }

    public static class Latent
    extends InDefinedShape.AbstractBase {
        private final MethodDescription.InDefinedShape declaringMethod;
        private final TypeDescription.Generic parameterType;
        private final List<? extends AnnotationDescription> declaredAnnotations;
        private final String name;
        private final Integer modifiers;
        private final int index;
        private final int offset;

        public Latent(MethodDescription.InDefinedShape declaringMethod, Token token, int index, int offset) {
            this(declaringMethod, token.getType(), token.getAnnotations(), token.getName(), token.getModifiers(), index, offset);
        }

        public Latent(MethodDescription.InDefinedShape declaringMethod, TypeDescription.Generic parameterType, int index, int offset) {
            this(declaringMethod, parameterType, Collections.emptyList(), Token.NO_NAME, Token.NO_MODIFIERS, index, offset);
        }

        public Latent(MethodDescription.InDefinedShape declaringMethod, TypeDescription.Generic parameterType, List<? extends AnnotationDescription> declaredAnnotations, String name, Integer modifiers, int index, int offset) {
            this.declaringMethod = declaringMethod;
            this.parameterType = parameterType;
            this.declaredAnnotations = declaredAnnotations;
            this.name = name;
            this.modifiers = modifiers;
            this.index = index;
            this.offset = offset;
        }

        @Override
        public TypeDescription.Generic getType() {
            return this.parameterType.accept(TypeDescription.Generic.Visitor.Substitutor.ForAttachment.of(this));
        }

        @Override
        public MethodDescription.InDefinedShape getDeclaringMethod() {
            return this.declaringMethod;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public boolean isNamed() {
            return this.name != null;
        }

        @Override
        public boolean hasModifiers() {
            return this.modifiers != null;
        }

        @Override
        public String getName() {
            return this.isNamed() ? this.name : super.getName();
        }

        @Override
        public int getModifiers() {
            return this.hasModifiers() ? this.modifiers.intValue() : super.getModifiers();
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Explicit(this.declaredAnnotations);
        }
    }

    public static abstract class ForLoadedParameter<T extends AccessibleObject>
    extends InDefinedShape.AbstractBase {
        private static final Dispatcher DISPATCHER;
        protected final T executable;
        protected final int index;

        protected ForLoadedParameter(T executable, int index) {
            this.executable = executable;
            this.index = index;
        }

        @Override
        public String getName() {
            return DISPATCHER.getName((AccessibleObject)this.executable, this.index);
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public boolean isNamed() {
            return DISPATCHER.isNamePresent((AccessibleObject)this.executable, this.index);
        }

        @Override
        public int getModifiers() {
            return DISPATCHER.getModifiers((AccessibleObject)this.executable, this.index);
        }

        @Override
        public boolean hasModifiers() {
            return this.isNamed() || this.getModifiers() != 0;
        }

        static {
            Dispatcher dispatcher;
            try {
                Class<?> executableType = Class.forName("java.lang.reflect.Executable");
                Class<?> parameterType = Class.forName("java.lang.reflect.Parameter");
                dispatcher = new Dispatcher.ForJava8CapableVm(executableType.getDeclaredMethod("getParameters", new Class[0]), parameterType.getDeclaredMethod("getName", new Class[0]), parameterType.getDeclaredMethod("isNamePresent", new Class[0]), parameterType.getDeclaredMethod("getModifiers", new Class[0]));
            }
            catch (RuntimeException exception) {
                throw exception;
            }
            catch (Exception ignored) {
                dispatcher = Dispatcher.ForLegacyVm.INSTANCE;
            }
            DISPATCHER = dispatcher;
        }

        protected static class OfLegacyVmConstructor
        extends InDefinedShape.AbstractBase {
            private final Constructor<?> constructor;
            private final int index;
            private final Class<?>[] parameterType;
            private final Annotation[][] parameterAnnotation;

            protected OfLegacyVmConstructor(Constructor<?> constructor, int index, Class<?>[] parameterType, Annotation[][] parameterAnnotation) {
                this.constructor = constructor;
                this.index = index;
                this.parameterType = parameterType;
                this.parameterAnnotation = parameterAnnotation;
            }

            @Override
            public TypeDescription.Generic getType() {
                return new TypeDescription.Generic.LazyProjection.OfConstructorParameter(this.constructor, this.index, this.parameterType);
            }

            @Override
            public MethodDescription.InDefinedShape getDeclaringMethod() {
                return new MethodDescription.ForLoadedConstructor(this.constructor);
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public boolean isNamed() {
                return false;
            }

            @Override
            public boolean hasModifiers() {
                return false;
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return new AnnotationList.ForLoadedAnnotations(this.parameterAnnotation[this.index]);
            }
        }

        protected static class OfLegacyVmMethod
        extends InDefinedShape.AbstractBase {
            private final Method method;
            private final int index;
            private final Class<?>[] parameterType;
            private final Annotation[][] parameterAnnotation;

            protected OfLegacyVmMethod(Method method, int index, Class<?>[] parameterType, Annotation[][] parameterAnnotation) {
                this.method = method;
                this.index = index;
                this.parameterType = parameterType;
                this.parameterAnnotation = parameterAnnotation;
            }

            @Override
            public TypeDescription.Generic getType() {
                return new TypeDescription.Generic.LazyProjection.OfMethodParameter(this.method, this.index, this.parameterType);
            }

            @Override
            public MethodDescription.InDefinedShape getDeclaringMethod() {
                return new MethodDescription.ForLoadedMethod(this.method);
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public boolean isNamed() {
                return false;
            }

            @Override
            public boolean hasModifiers() {
                return false;
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return new AnnotationList.ForLoadedAnnotations(this.parameterAnnotation[this.index]);
            }
        }

        protected static class OfConstructor
        extends ForLoadedParameter<Constructor<?>> {
            protected OfConstructor(Constructor<?> constructor, int index) {
                super(constructor, index);
            }

            @Override
            @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The implicit field type casting is not understood by findbugs")
            public MethodDescription.InDefinedShape getDeclaringMethod() {
                return new MethodDescription.ForLoadedConstructor((Constructor)this.executable);
            }

            @Override
            @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The implicit field type casting is not understood by findbugs")
            public TypeDescription.Generic getType() {
                return new TypeDescription.Generic.LazyProjection.OfConstructorParameter((Constructor)this.executable, this.index, ((Constructor)this.executable).getParameterTypes());
            }

            @Override
            @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The implicit field type casting is not understood by findbugs")
            public AnnotationList getDeclaredAnnotations() {
                return new AnnotationList.ForLoadedAnnotations(((Constructor)this.executable).getParameterAnnotations()[this.index]);
            }
        }

        protected static class OfMethod
        extends ForLoadedParameter<Method> {
            protected OfMethod(Method method, int index) {
                super(method, index);
            }

            @Override
            @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The implicit field type casting is not understood by findbugs")
            public MethodDescription.InDefinedShape getDeclaringMethod() {
                return new MethodDescription.ForLoadedMethod((Method)this.executable);
            }

            @Override
            @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The implicit field type casting is not understood by findbugs")
            public TypeDescription.Generic getType() {
                return new TypeDescription.Generic.LazyProjection.OfMethodParameter((Method)this.executable, this.index, ((Method)this.executable).getParameterTypes());
            }

            @Override
            @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The implicit field type casting is not understood by findbugs")
            public AnnotationList getDeclaredAnnotations() {
                return new AnnotationList.ForLoadedAnnotations(((Method)this.executable).getParameterAnnotations()[this.index]);
            }
        }

        protected static interface Dispatcher {
            public int getModifiers(AccessibleObject var1, int var2);

            public boolean isNamePresent(AccessibleObject var1, int var2);

            public String getName(AccessibleObject var1, int var2);

            public static enum ForLegacyVm implements Dispatcher
            {
                INSTANCE;


                @Override
                public int getModifiers(AccessibleObject executable, int index) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.reflect.Parameter");
                }

                @Override
                public boolean isNamePresent(AccessibleObject executable, int index) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.reflect.Parameter");
                }

                @Override
                public String getName(AccessibleObject executable, int index) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.reflect.Parameter");
                }

                public String toString() {
                    return "ParameterDescription.ForLoadedParameter.Dispatcher.ForLegacyVm." + this.name();
                }
            }

            public static class ForJava8CapableVm
            implements Dispatcher {
                private final Method getParameters;
                private final Method getName;
                private final Method isNamePresent;
                private final Method getModifiers;

                protected ForJava8CapableVm(Method getParameters, Method getName, Method isNamePresent, Method getModifiers) {
                    this.getParameters = getParameters;
                    this.getName = getName;
                    this.isNamePresent = isNamePresent;
                    this.getModifiers = getModifiers;
                }

                @Override
                public int getModifiers(AccessibleObject executable, int index) {
                    try {
                        return (Integer)this.getModifiers.invoke(this.getParameter(executable, index), new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.Parameter#getModifiers", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.Parameter#getModifiers", exception.getCause());
                    }
                }

                @Override
                public boolean isNamePresent(AccessibleObject executable, int index) {
                    try {
                        return (Boolean)this.isNamePresent.invoke(this.getParameter(executable, index), new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.Parameter#isNamePresent", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.Parameter#isNamePresent", exception.getCause());
                    }
                }

                @Override
                public String getName(AccessibleObject executable, int index) {
                    try {
                        return (String)this.getName.invoke(this.getParameter(executable, index), new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.Parameter#getName", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.Parameter#getName", exception.getCause());
                    }
                }

                private Object getParameter(AccessibleObject executable, int index) {
                    try {
                        return Array.get(this.getParameters.invoke((Object)executable, new Object[0]), index);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.Executable#getParameters", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.Executable#getParameters", exception.getCause());
                    }
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    ForJava8CapableVm legal = (ForJava8CapableVm)other;
                    return this.getParameters.equals(legal.getParameters) && this.getName.equals(legal.getName) && this.isNamePresent.equals(legal.isNamePresent) && this.getModifiers.equals(legal.getModifiers);
                }

                public int hashCode() {
                    int result = this.getParameters.hashCode();
                    result = 31 * result + this.getName.hashCode();
                    result = 31 * result + this.isNamePresent.hashCode();
                    result = 31 * result + this.getModifiers.hashCode();
                    return result;
                }

                public String toString() {
                    return "ParameterDescription.ForLoadedParameter.Dispatcher.ForJava8CapableVm{getParameters=" + this.getParameters + ", getName=" + this.getName + ", isNamePresent=" + this.isNamePresent + ", getModifiers=" + this.getModifiers + '}';
                }
            }
        }
    }

    public static abstract class AbstractBase
    extends ModifierReviewable.AbstractBase
    implements ParameterDescription {
        @Override
        public String getName() {
            return ParameterDescription.NAME_PREFIX.concat(String.valueOf(this.getIndex()));
        }

        @Override
        public String getInternalName() {
            return this.getName();
        }

        @Override
        public String getSourceCodeName() {
            return this.isNamed() ? this.getName() : "";
        }

        @Override
        public int getModifiers() {
            return 0;
        }

        @Override
        public int getOffset() {
            TypeList parameterType = this.getDeclaringMethod().getParameters().asTypeList().asErasures();
            int offset = this.getDeclaringMethod().isStatic() ? StackSize.ZERO.getSize() : StackSize.SINGLE.getSize();
            for (int i = 0; i < this.getIndex(); ++i) {
                offset += ((TypeDescription)parameterType.get(i)).getStackSize().getSize();
            }
            return offset;
        }

        @Override
        public Token asToken(ElementMatcher<? super TypeDescription> matcher) {
            return new Token(this.getType().accept(new TypeDescription.Generic.Visitor.Substitutor.ForDetachment(matcher)), this.getDeclaredAnnotations(), this.isNamed() ? this.getName() : Token.NO_NAME, this.hasModifiers() ? Integer.valueOf(this.getModifiers()) : Token.NO_MODIFIERS);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParameterDescription)) {
                return false;
            }
            ParameterDescription parameterDescription = (ParameterDescription)other;
            return this.getDeclaringMethod().equals(parameterDescription.getDeclaringMethod()) && this.getIndex() == parameterDescription.getIndex();
        }

        public int hashCode() {
            return this.getDeclaringMethod().hashCode() ^ this.getIndex();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(Modifier.toString(this.getModifiers()));
            if (this.getModifiers() != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.isVarArgs() ? this.getType().asErasure().getName().replaceFirst("\\[\\]$", "...") : this.getType().asErasure().getName());
            return stringBuilder.append(' ').append(this.getName()).toString();
        }
    }

    public static interface InDefinedShape
    extends ParameterDescription {
        @Override
        public MethodDescription.InDefinedShape getDeclaringMethod();

        public static abstract class AbstractBase
        extends nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.ParameterDescription$AbstractBase
        implements InDefinedShape {
            @Override
            public InDefinedShape asDefined() {
                return this;
            }
        }
    }

    public static interface InGenericShape
    extends ParameterDescription {
        @Override
        public MethodDescription.InGenericShape getDeclaringMethod();
    }
}

