var CountryCodes = {
  "ad" : "Andorra",
  "ae" : "United Arab Emirates",
  "af" : "Afghanistan",
  "ag" : "Antigua and Barbuda",
  "ai" : "Anguilla",
  "al" : "Albania",
  "am" : "Armenia",
  "an" : "Netherlands Antilles",
  "ao" : "Angola",
  "aq" : "Antarctica",
  "ar" : "Argentina",
  "as" : "American Samoa",
  "at" : "Austria",
  "au" : "Australia",
  "aw" : "Aruba",
  "ax" : "Aland Islands",
  "az" : "Azerbaijan",
  "ba" : "Bosnia and Herzegovina",
  "bb" : "Barbados",
  "bd" : "Bangladesh",
  "be" : "Belgium",
  "bf" : "Burkina Faso",
  "bg" : "Bulgaria",
  "bh" : "Bahrain",
  "bi" : "Burundi",
  "bj" : "Benin",
  "bl" : "Saint Bartelemey",
  "bm" : "Bermuda",
  "bn" : "Brunei",
  "bo" : "Bolivia",
  "br" : "Brazil",
  "bs" : "Bahamas",
  "bt" : "Bhutan",
  "bv" : "Bouvet Island",
  "bw" : "Botswana",
  "by" : "Belarus",
  "bz" : "Belize",
  "ca" : "Canada",
  "cc" : "Cocos (Keeling) Islands",
  "cd" : "Democratic Republic of the Congo",
  "cf" : "Central African Republic",
  "cg" : "Congo",
  "ch" : "Switzerland",
  "ci" : "C&#244;te d'Ivoire",
  "ck" : "Cook Islands",
  "cl" : "Chile",
  "cm" : "Cameroon",
  "cn" : "China",
  "co" : "Colombia",
  "cr" : "Costa Rica",
  "cu" : "Cuba",
  "cv" : "Cape Verde",
  "cx" : "Christmas Island",
  "cy" : "Cyprus",
  "cz" : "Czech Republic",
  "de" : "Germany",
  "dj" : "Djibouti",
  "dk" : "Denmark",
  "dm" : "Dominica",
  "do" : "Dominican Republic",
  "dz" : "Algeria",
  "ec" : "Ecuador",
  "ee" : "Estonia",
  "eg" : "Egypt",
  "eh" : "Western Sahara",
  "er" : "Eritrea",
  "es" : "Spain",
  "et" : "Ethiopia",
  "fi" : "Finland",
  "fj" : "Fiji",
  "fk" : "Falkland Islands (Malvinas)",
  "fm" : "Federated States of Micronesia",
  "fo" : "Faroe Islands",
  "fr" : "France",
  "fx" : "Metropolitan France",
  "ga" : "Gabon",
  "gb" : "United Kingdom",
  "gd" : "Grenada",
  "ge" : "Georgia",
  "gf" : "French Guiana",
  "gg" : "Guernsey",
  "gh" : "Ghana",
  "gi" : "Gibraltar",
  "gl" : "Greenland",
  "gm" : "Gambia",
  "gn" : "Guinea",
  "gp" : "Guadeloupe",
  "gq" : "Equatorial Guinea",
  "gr" : "Greece",
  "gs" : "South Georgia and the South Sandwich Islands",
  "gt" : "Guatemala",
  "gu" : "Guam",
  "gw" : "Guinea-Bissau",
  "gy" : "Guyana",
  "hk" : "Hong Kong",
  "hm" : "Heard Island and McDonald Islands",
  "hn" : "Honduras",
  "hr" : "Croatia",
  "ht" : "Haiti",
  "hu" : "Hungary",
  "id" : "Indonesia",
  "ie" : "Ireland",
  "il" : "Israel",
  "im" : "Isle of Man",
  "in" : "India",
  "io" : "British Indian Ocean Territory",
  "iq" : "Iraq",
  "ir" : "Iran",
  "is" : "Iceland",
  "it" : "Italy",
  "je" : "Jersey",
  "jm" : "Jamaica",
  "jo" : "Jordan",
  "jp" : "Japan",
  "ke" : "Kenya",
  "kg" : "Kyrgyzstan",
  "kh" : "Cambodia",
  "ki" : "Kiribati",
  "km" : "Comoros",
  "kn" : "Saint Kitts and Nevis",
  "kp" : "North Korea",
  "kr" : "Republic of Korea",
  "kw" : "Kuwait",
  "ky" : "Cayman Islands",
  "kz" : "Kazakhstan",
  "la" : "Laos",
  "lb" : "Lebanon",
  "lc" : "Saint Lucia",
  "li" : "Liechtenstein",
  "lk" : "Sri Lanka",
  "lr" : "Liberia",
  "ls" : "Lesotho",
  "lt" : "Lithuania",
  "lu" : "Luxembourg",
  "lv" : "Latvia",
  "ly" : "Libya",
  "ma" : "Morocco",
  "mc" : "Monaco",
  "md" : "Republic of Moldova",
  "me" : "Montenegro",
  "mf" : "Saint Martin",
  "mg" : "Madagascar",
  "mh" : "Marshall Islands",
  "mk" : "Macedonia",
  "ml" : "Mali",
  "mm" : "Burma",
  "mn" : "Mongolia",
  "mo" : "Macau",
  "mp" : "Northern Mariana Islands",
  "mq" : "Martinique",
  "mr" : "Mauritania",
  "ms" : "Montserrat",
  "mt" : "Malta",
  "mu" : "Mauritius",
  "mv" : "Maldives",
  "mw" : "Malawi",
  "mx" : "Mexico",
  "my" : "Malaysia",
  "mz" : "Mozambique",
  "na" : "Namibia",
  "nc" : "New Caledonia",
  "ne" : "Niger",
  "nf" : "Norfolk Island",
  "ng" : "Nigeria",
  "ni" : "Nicaragua",
  "nl" : "Netherlands",
  "no" : "Norway",
  "np" : "Nepal",
  "nr" : "Nauru",
  "nu" : "Niue",
  "nz" : "New Zealand",
  "om" : "Oman",
  "pa" : "Panama",
  "pe" : "Peru",
  "pf" : "French Polynesia",
  "pg" : "Papua New Guinea",
  "ph" : "Philippines",
  "pk" : "Pakistan",
  "pl" : "Poland",
  "pm" : "Saint Pierre and Miquelon",
  "pn" : "Pitcairn Islands",
  "pr" : "Puerto Rico",
  "ps" : "Palestinian Territory",
  "pt" : "Portugal",
  "pw" : "Palau",
  "py" : "Paraguay",
  "qa" : "Qatar",
  "re" : "Reunion",
  "ro" : "Romania",
  "rs" : "Serbia",
  "ru" : "Russia",
  "rw" : "Rwanda",
  "sa" : "Saudi Arabia",
  "sb" : "Solomon Islands",
  "sc" : "Seychelles",
  "sd" : "Sudan",
  "se" : "Sweden",
  "sg" : "Singapore",
  "sh" : "Saint Helena",
  "si" : "Slovenia",
  "sj" : "Svalbard and Jan Mayen",
  "sk" : "Slovakia",
  "sl" : "Sierra Leone",
  "sm" : "San Marino",
  "sn" : "Senegal",
  "so" : "Somalia",
  "sr" : "Suriname",
  "ss" : "South Sudan",
  "st" : "S&#227;o Tom&#233; and Pr&#237;ncipe",
  "sv" : "El Salvador",
  "sy" : "Syrian Arab Republic",
  "sz" : "Swaziland",
  "tc" : "Turks and Caicos Islands",
  "td" : "Chad",
  "tf" : "French Southern Territories",
  "tg" : "Togo",
  "th" : "Thailand",
  "tj" : "Tajikistan",
  "tk" : "Tokelau",
  "tl" : "East Timor",
  "tm" : "Turkmenistan",
  "tn" : "Tunisia",
  "to" : "Tonga",
  "tr" : "Turkey",
  "tt" : "Trinidad and Tobago",
  "tv" : "Tuvalu",
  "tw" : "Taiwan",
  "tz" : "United Republic of Tanzania",
  "ua" : "Ukraine",
  "ug" : "Uganda",
  "um" : "United States Minor Outlying Islands",
  "us" : "United States",
  "uy" : "Uruguay",
  "uz" : "Uzbekistan",
  "va" : "Vatican City",
  "vc" : "Saint Vincent and the Grenadines",
  "ve" : "Venezuela",
  "vg" : "British Virgin Islands",
  "vi" : "United States Virgin Islands",
  "vn" : "Vietnam",
  "vu" : "Vanuatu",
  "wf" : "Wallis and Futuna",
  "ws" : "Samoa",
  "xz" : "Unknown",
  "ye" : "Yemen",
  "yt" : "Mayotte",
  "za" : "South Africa",
  "zm" : "Zambia",
  "zw" : "Zimbabwe"
}

function hrBandwidth(bw) {
    var bw_k = bw/1024;
    var bw_m = bw_k/1024;

    if (bw_m >= 1) {
        return Math.round(bw_m * 100) / 100 + " MiB/s";
    } else if (bw_k >= 1) {
        return Math.round(bw_k * 100) / 100 + " KiB/s";
    }

    return bw + " B/s";
}

function checkIfDataIsUpToDate(lastModifiedHeader) {
    // check if onionoo document is up to date:
    var lastModified = new Date(Date.parse(lastModifiedHeader));
    var currentTime = new Date();
    var hoursSinceLastUpdate =  (currentTime.getTime() - lastModified.getTime()) / (1000 * 60 * 60);
    if (hoursSinceLastUpdate > 24 && $("#outdatedData").length==0) {
        $('<div id="outdatedData" class="alert alert-danger"><strong>Outdated data!</strong><p>The Relay Search data source (Onionoo) was last updated: '+lastModified+'. This issue should be resolved soon, please try again later for more recent information.</p></div>').insertAfter(".container > h1");
    }
}

window.onhashchange = function(){
    // close mobile menu on hash change
    if ($('.nav-collapse').height()>50) {
        $('.btn-navbar').click();
    }
}

Object.defineProperty(Array.prototype, 'chunk', {
    value: function(chunkSize) {
        var R = [];
        for (var i=0; i<this.length; i+=chunkSize)
            R.push(this.slice(i,i+chunkSize));
        return R;
    }
});
