/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.command;

import java.io.IOException;
import org.subethamail.smtp.command.AuthCommand;
import org.subethamail.smtp.server.BaseCommand;
import org.subethamail.smtp.server.ConnectionContext;
import org.subethamail.smtp.server.SMTPServer;
import org.subethamail.smtp.server.Session;

public class EhloCommand
extends BaseCommand {
    public EhloCommand() {
        super("EHLO", "Introduce yourself.", "<hostname>");
    }

    public void execute(String commandString, ConnectionContext context) throws IOException {
        String[] args = this.getArgs(commandString);
        if (args.length < 2) {
            context.sendResponse("501 Syntax: EHLO hostname");
            return;
        }
        Session session = context.getSession();
        StringBuilder response = new StringBuilder();
        if (!session.getHasSeenHelo()) {
            session.setHasSeenHelo(true);
            response.append("250-");
            response.append(context.getSMTPServer().getHostName());
            response.append("\r\n");
            response.append("250-8BITMIME");
            SMTPServer server = context.getSMTPServer();
            if (server.announceTLS() && context.getSMTPServer().getCommandHandler().containsCommand("STARTTLS")) {
                response.append("\r\n").append("250-STARTTLS");
            }
            if (context.getSMTPServer().getCommandHandler().containsCommand("AUTH")) {
                response.append(AuthCommand.getEhloString(context.getSession().getMessageHandler()));
            }
            response.append("\r\n");
            response.append("250 Ok");
        } else {
            String remoteHost = args[1];
            response.append("503 ");
            response.append(remoteHost);
            response.append(" Duplicate EHLO");
        }
        context.sendResponse(response.toString());
    }
}

