/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.index;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.torproject.descriptor.index.DirectoryNode;
import org.torproject.descriptor.index.FileNode;
import org.torproject.descriptor.internal.FileType;

@JsonPropertyOrder(value={"created", "revision", "path", "directories", "files"})
public class IndexNode {
    private static final int READ_TIMEOUT = Integer.parseInt(System.getProperty("sun.net.client.defaultReadTimeout", "60000"));
    private static final int CONNECT_TIMEOUT = Integer.parseInt(System.getProperty("sun.net.client.defaultConnectTimeout", "60000"));
    public static final IndexNode emptyNode = new IndexNode("", "", new TreeSet<FileNode>(), new TreeSet<DirectoryNode>());
    private static ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    @JsonProperty(value="index_created")
    public final String created;
    @JsonProperty(value="build_revision")
    public final String revision;
    public final String path;
    public final SortedSet<DirectoryNode> directories;
    public final SortedSet<FileNode> files;

    private IndexNode() {
        this.created = null;
        this.revision = null;
        this.path = null;
        this.files = null;
        this.directories = null;
    }

    public IndexNode(String created, String path, SortedSet<FileNode> files, SortedSet<DirectoryNode> directories) {
        this(created, null, path, files, directories);
    }

    public IndexNode(String created, String revision, String path, SortedSet<FileNode> files, SortedSet<DirectoryNode> directories) {
        this.created = created;
        this.revision = revision;
        this.path = path;
        this.files = files;
        this.directories = directories;
    }

    public static IndexNode fetchIndex(String urlString) throws Exception {
        String ending = urlString.substring(urlString.lastIndexOf(".") + 1).toUpperCase();
        URLConnection connection = new URL(urlString).openConnection();
        connection.setReadTimeout(READ_TIMEOUT);
        connection.setConnectTimeout(CONNECT_TIMEOUT);
        connection.connect();
        try (InputStream is = FileType.valueOf(ending).inputStream(connection.getInputStream());){
            IndexNode indexNode = IndexNode.fetchIndex(is);
            return indexNode;
        }
    }

    public static IndexNode fetchIndex(InputStream is) throws IOException {
        return (IndexNode)objectMapper.readValue(is, IndexNode.class);
    }

    public SortedMap<String, FileNode> retrieveFilesIn(String ... remoteDirs) {
        TreeMap<String, FileNode> map = new TreeMap<String, FileNode>();
        for (String remote : remoteDirs) {
            DirectoryNode dn;
            String[] dirs;
            DirectoryNode currentDir;
            if (null == remote || remote.isEmpty() || null == (currentDir = IndexNode.findPathIn((dirs = remote.replaceAll("/", " ").trim().split(" "))[0], this.directories))) continue;
            StringBuilder currentPath = new StringBuilder(dirs[0] + "/");
            for (int k = 1; k < dirs.length && null != (dn = IndexNode.findPathIn(dirs[k], currentDir.directories)); ++k) {
                currentPath.append(dirs[k]).append("/");
                currentDir = dn;
            }
            if (null == currentDir.files) continue;
            for (FileNode file : currentDir.files) {
                if (file.lastModifiedMillis() <= 0L) continue;
                map.put(currentPath.toString() + file.path, file);
            }
        }
        return map;
    }

    public static DirectoryNode findPathIn(String path, SortedSet<DirectoryNode> dirs) {
        if (null != dirs) {
            for (DirectoryNode dn : dirs) {
                if (!dn.path.equals(path)) continue;
                return dn;
            }
        }
        return null;
    }

    public static void writeIndex(Path outPath, IndexNode indexNode) throws Exception {
        String ending = outPath.toString().substring(outPath.toString().lastIndexOf(".") + 1).toUpperCase();
        try (OutputStream os = FileType.valueOf(ending).outputStream(Files.newOutputStream(outPath, new OpenOption[0]));){
            os.write(IndexNode.makeJsonString(indexNode).getBytes());
        }
    }

    public static String makeJsonString(IndexNode indexNode) throws IOException {
        return objectMapper.writeValueAsString((Object)indexNode);
    }

    public String toString() {
        return "index: " + this.path + ", created " + this.created + ",\nfns: " + this.files + ",\ndirs: " + this.directories;
    }
}

