/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.util.List;
import org.junit.Assert;

public final class StringAssert {
    private StringAssert() {
    }

    public static void assertContains(String msg, String haystack, String needle) {
        Assert.assertNotNull((String)(msg + ": haystack should not be null"), (Object)haystack);
        Assert.assertNotNull((String)(msg + ": needle should not be null"), (Object)needle);
        int idx = haystack.indexOf(needle);
        if (idx == -1) {
            StringBuffer buf = new StringBuffer();
            buf.append(msg).append(": Unable to find \"").append(needle).append("\" in \"");
            buf.append(haystack).append('\"');
            System.err.println(buf);
            throw new AssertionError((Object)buf.toString());
        }
    }

    public static void assertContains(String msg, String haystack, String needle, int offset) {
        Assert.assertNotNull((String)(msg + ": haystack should not be null"), (Object)haystack);
        Assert.assertNotNull((String)(msg + ": needle should not be null"), (Object)needle);
        int idx = haystack.indexOf(needle, offset);
        if (idx == -1) {
            StringBuffer buf = new StringBuffer();
            buf.append(msg).append(": Unable to find \"").append(needle).append("\" in \"");
            buf.append(haystack.substring(offset)).append('\"');
            System.err.println(buf);
            throw new AssertionError((Object)buf.toString());
        }
    }

    public static void assertContainsSame(String msg, List<String> linesExpected, List<String> linesActual) {
        Assert.assertEquals((String)(msg + " line count"), (long)linesExpected.size(), (long)linesActual.size());
        for (String expected : linesExpected) {
            Assert.assertTrue((String)(msg + ": expecting to see line <" + expected + ">"), (boolean)linesActual.contains(expected));
        }
    }

    public static void assertNotContains(String msg, String haystack, String needle) {
        Assert.assertNotNull((String)(msg + ": haystack should not be null"), (Object)haystack);
        Assert.assertNotNull((String)(msg + ": needle should not be null"), (Object)needle);
        int idx = haystack.indexOf(needle);
        if (idx != -1) {
            StringBuffer buf = new StringBuffer();
            buf.append(msg).append(": Should not have found \"").append(needle).append("\" at offset ");
            buf.append(idx).append(" in \"").append(haystack).append('\"');
            System.err.println(buf);
            throw new AssertionError((Object)buf.toString());
        }
    }

    public static void assertNotContains(String msg, String haystack, String needle, int offset) {
        Assert.assertNotNull((String)(msg + ": haystack should not be null"), (Object)haystack);
        Assert.assertNotNull((String)(msg + ": needle should not be null"), (Object)needle);
        int idx = haystack.indexOf(needle, offset);
        if (idx != -1) {
            StringBuffer buf = new StringBuffer();
            buf.append(msg).append(": Should not have found \"").append(needle).append("\" at offset ");
            buf.append(idx).append(" in \"").append(haystack.substring(offset)).append('\"');
            System.err.println(buf);
            throw new AssertionError((Object)buf.toString());
        }
    }

    public static void assertStartsWith(String msg, String haystack, String expected) {
        Assert.assertNotNull((String)(msg + ": haystack should not be null"), (Object)haystack);
        Assert.assertNotNull((String)(msg + ": expected should not be null"), (Object)expected);
        if (!haystack.startsWith(expected)) {
            StringBuffer buf = new StringBuffer();
            buf.append(msg).append(": String \"");
            int len = Math.min(expected.length() + 4, haystack.length());
            buf.append(haystack.substring(0, len));
            buf.append("\" does not start with expected \"").append(expected).append('\"');
            System.err.println(buf);
            throw new AssertionError((Object)buf.toString());
        }
    }
}

