/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.web;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.torproject.metrics.web.Category;
import org.torproject.metrics.web.Countries;
import org.torproject.metrics.web.GraphParameterChecker;
import org.torproject.metrics.web.MetricServlet;
import org.torproject.metrics.web.News;

public class GraphServlet
extends MetricServlet {
    private Map<String, String[][]> defaultParameters = new HashMap<String, String[][]>();

    @Override
    public void init() throws ServletException {
        super.init();
        this.defaultParameters.put("p", new String[][]{{"100", " checked", "100 (maximum)"}, {"99", "", "99"}, {"98", "", "98"}, {"97", "", "97"}, {"95", "", "95"}, {"91", "", "91"}, {"90", "", "90"}, {"80", "", "80"}, {"75", "", "75 (3rd quartile)"}, {"70", "", "70"}, {"60", "", "60"}, {"50", "", "50 (median)"}, {"40", "", "40"}, {"30", "", "30"}, {"25", "", "25 (first quartile)"}, {"20", "", "20"}, {"10", "", "10"}, {"9", "", "9"}, {"5", "", "5"}, {"3", "", "3"}, {"2", "", "2"}, {"1", "", "1"}, {"0", "", "0 (minimum)"}});
        this.defaultParameters.put("n", new String[][]{{"1", " checked"}, {"2", ""}, {"3", ""}, {"5", ""}, {"10", ""}, {"20", ""}, {"30", ""}, {"50", ""}, {"100", ""}, {"200", ""}, {"300", ""}, {"500", ""}, {"1000", ""}, {"2000", ""}, {"3000", ""}, {"5000", ""}});
        this.defaultParameters.put("flag", new String[][]{{"Running", " checked"}, {"Exit", " checked"}, {"Fast", " checked"}, {"Guard", " checked"}, {"Stable", " checked"}, {"HSDir", ""}});
        List<String[]> knownCountries = Countries.getInstance().getCountryList();
        String[][] countries = new String[knownCountries.size() + 1][];
        int index = 0;
        countries[index++] = new String[]{"all", " selected", "All users"};
        for (String[] country : knownCountries) {
            countries[index++] = new String[]{country[0], "", country[1]};
        }
        this.defaultParameters.put("country", countries);
        this.defaultParameters.put("events", new String[][]{{"off", " selected", "Off"}, {"on", "", "On: both points and expected range"}, {"points", "", "On: points only, no expected range"}});
        this.defaultParameters.put("transport", new String[][]{{"!<OR>", " checked", "Any pluggable transport"}, {"obfs2", "", "obfs2"}, {"obfs3", "", "obfs3"}, {"obfs4", "", "obfs4"}, {"websocket", "", "Flash proxy/websocket"}, {"fte", "", "FTE"}, {"meek", "", "meek"}, {"scramblesuit", "", "scramblesuit"}, {"snowflake", "", "snowflake"}, {"<??>", "", "Unknown pluggable transport(s)"}, {"<OR>", "", "Default OR protocol"}});
        this.defaultParameters.put("version", new String[][]{{"v4", " selected", "IPv4"}, {"v6", "", "IPv6"}});
        this.defaultParameters.put("server", new String[][]{{"public", " checked"}, {"onion", ""}});
        this.defaultParameters.put("filesize", new String[][]{{"50kb", " checked", "50 KiB"}, {"1mb", "", "1 MiB"}, {"5mb", "", "5 MiB"}});
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String requestUri = request.getRequestURI();
        if (requestUri == null || !requestUri.endsWith(".html")) {
            response.sendError(400);
            return;
        }
        String requestedId = requestUri.substring(requestUri.contains("/") ? requestUri.lastIndexOf("/") + 1 : 0, requestUri.length() - 5);
        if (!this.idsByType.containsKey("Graph") || !((Set)this.idsByType.get("Graph")).contains(requestedId)) {
            response.sendError(400);
            return;
        }
        request.setAttribute("categories", (Object)this.categories);
        request.setAttribute("id", (Object)requestedId);
        request.setAttribute("title", this.titles.get(requestedId));
        if (this.categoriesById.containsKey(requestedId)) {
            Category category = (Category)this.categoriesById.get(requestedId);
            request.setAttribute("categoryId", (Object)category.getId());
            request.setAttribute("categoryHeader", (Object)category.getHeader());
            request.setAttribute("categoryDescription", (Object)category.getDescription());
            ArrayList<String[]> categoryTabs = new ArrayList<String[]>();
            for (String metricId : category.getMetrics()) {
                categoryTabs.add(new String[]{(String)this.titles.get(metricId), metricId});
            }
            request.setAttribute("categoryTabs", categoryTabs);
        }
        request.setAttribute("description", this.descriptions.get(requestedId));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date defaultEndDate = new Date();
        Date defaultStartDate = new Date(defaultEndDate.getTime() - 7776000000L);
        if (this.parameters.containsKey(requestedId)) {
            Map<String, String[]> checkedParameters = GraphParameterChecker.getInstance().checkParameters(requestedId, request.getParameterMap());
            StringBuilder urlBuilder = new StringBuilder();
            Iterator iterator = ((List)this.parameters.get(requestedId)).iterator();
            block20: while (iterator.hasNext()) {
                String parameter;
                switch (parameter = (String)iterator.next()) {
                    case "start": 
                    case "end": {
                        String[] requestParameter = checkedParameters != null && checkedParameters.containsKey(parameter) ? checkedParameters.get(parameter) : new String[]{dateFormat.format(parameter.equals("start") ? defaultStartDate : defaultEndDate)};
                        urlBuilder.append(String.format("&amp;%s=%s", parameter, requestParameter[0]));
                        request.setAttribute(parameter, (Object)requestParameter);
                        continue block20;
                    }
                }
                String[][] stringArray = this.defaultParameters.get(parameter);
                Object requestParameters = new String[stringArray.length][];
                HashSet<Object> checked = null;
                if (checkedParameters != null && checkedParameters.containsKey(parameter)) {
                    checked = new HashSet<Object>(Arrays.asList((Object[])checkedParameters.get(parameter)));
                }
                String checkedOrSelected = parameter.equals("country") || parameter.equals("events") || parameter.equals("version") ? " selected" : " checked";
                for (int i = 0; i < stringArray.length; ++i) {
                    requestParameters[i] = new String[stringArray[i].length];
                    System.arraycopy(stringArray[i], 0, requestParameters[i], 0, stringArray[i].length);
                    if (checked == null) continue;
                    if (checked.contains(requestParameters[i][0])) {
                        requestParameters[i][1] = checkedOrSelected;
                        urlBuilder.append(String.format("&amp;%s=%s", parameter, requestParameters[i][0]));
                        continue;
                    }
                    requestParameters[i][1] = "";
                }
                request.setAttribute(parameter, requestParameters);
            }
            if (urlBuilder.length() > 5) {
                String url = "?" + urlBuilder.toString().substring(5);
                request.setAttribute("parameters", (Object)url);
            }
            if (this.includeRelatedEvents.contains(requestedId)) {
                request.setAttribute("includeRelatedEvents", (Object)true);
                String startParameter = dateFormat.format(defaultStartDate);
                String endParameter = dateFormat.format(defaultEndDate);
                String countryParameter = "all";
                String eventsParameter = "off";
                if (null != checkedParameters) {
                    for (Map.Entry entry : checkedParameters.entrySet()) {
                        switch ((String)entry.getKey()) {
                            case "start": {
                                startParameter = ((String[])entry.getValue())[0];
                                break;
                            }
                            case "end": {
                                endParameter = ((String[])entry.getValue())[0];
                                break;
                            }
                            case "country": {
                                countryParameter = ((String[])entry.getValue())[0];
                                break;
                            }
                            case "events": {
                                eventsParameter = ((String[])entry.getValue())[0];
                                break;
                            }
                        }
                    }
                }
                if (!"off".equals(eventsParameter)) {
                    request.setAttribute("displayEventsNotice", (Object)true);
                }
                ArrayList<News> relatedEvents = new ArrayList<News>();
                for (News event : this.sortedEvents) {
                    if (null == event.getStart() || event.getStart().compareTo(endParameter) > 0 || null != event.getEnd() && event.getEnd().compareTo(startParameter) < 0 || null == event.getEnd() && event.getStart().compareTo(startParameter) < 0 || !"all".equals(countryParameter) && null != event.getPlaces() && !event.getPlaces().contains(countryParameter)) continue;
                    relatedEvents.add(event);
                }
                request.setAttribute("relatedEvents", relatedEvents);
            }
        }
        request.getRequestDispatcher("WEB-INF/graph.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }
}

