/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.web;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.torproject.metrics.web.RObject;
import org.torproject.metrics.web.RObjectGenerator;

public class GraphImageServlet
extends HttpServlet {
    private static final long serialVersionUID = -7356818641689744288L;
    private RObjectGenerator objectGenerator;

    public void init() {
        this.objectGenerator = (RObjectGenerator)this.getServletContext().getAttribute("RObjectGenerator");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RObject graph;
        String requestedGraph = request.getRequestURI();
        String fileType = null;
        if (requestedGraph.endsWith(".png") || requestedGraph.endsWith(".pdf") || requestedGraph.endsWith(".csv")) {
            fileType = requestedGraph.substring(requestedGraph.length() - 3);
            requestedGraph = requestedGraph.substring(0, requestedGraph.length() - 4);
        }
        if (requestedGraph.contains("/")) {
            requestedGraph = requestedGraph.substring(requestedGraph.lastIndexOf("/") + 1);
        }
        if ((graph = this.objectGenerator.generateGraph(requestedGraph, fileType, request.getParameterMap(), true)) == null || graph.getBytes() == null || fileType == null) {
            response.sendError(500);
            return;
        }
        byte[] headerBytes = ("#\n# The Tor Project\n#\n# URL: https://metrics.torproject.org" + request.getRequestURI() + (null == request.getQueryString() ? "" : "?" + request.getQueryString()) + "\n#\n").getBytes();
        response.setContentType(("csv".equals(fileType) ? "text/" : "image/") + fileType);
        response.setHeader("Content-Length", String.valueOf(("csv".equals(fileType) ? headerBytes.length : 0) + graph.getBytes().length));
        response.setHeader("Content-Disposition", "inline; filename=\"" + graph.getFileName() + "\"");
        BufferedOutputStream output = new BufferedOutputStream((OutputStream)response.getOutputStream(), 1024);
        if ("csv".equals(fileType)) {
            output.write(headerBytes);
        }
        output.write(graph.getBytes(), 0, graph.getBytes().length);
        output.flush();
        output.close();
    }
}

