/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.totalcw;

import java.time.Instant;
import java.time.ZoneId;
import org.torproject.descriptor.NetworkStatusEntry;
import org.torproject.descriptor.RelayNetworkStatusConsensus;
import org.torproject.descriptor.RelayNetworkStatusVote;
import org.torproject.metrics.stats.totalcw.TotalcwRelayNetworkStatus;

class Parser {
    Parser() {
    }

    TotalcwRelayNetworkStatus parseRelayNetworkStatusConsensus(RelayNetworkStatusConsensus consensus) {
        boolean containsBandwidthValues = false;
        long[] measuredSums = new long[4];
        for (NetworkStatusEntry entry : consensus.getStatusEntries().values()) {
            int measuredSumsIndex;
            if (null == entry.getFlags() || !entry.getFlags().contains("Running") || entry.getBandwidth() < 0L) continue;
            containsBandwidthValues = true;
            int n = measuredSumsIndex = (entry.getFlags().contains("Guard") ? 1 : 0) + (entry.getFlags().contains("Exit") && !entry.getFlags().contains("BadExit") ? 2 : 0);
            measuredSums[n] = measuredSums[n] + entry.getBandwidth();
        }
        if (!containsBandwidthValues) {
            return null;
        }
        TotalcwRelayNetworkStatus parsedStatus = new TotalcwRelayNetworkStatus();
        parsedStatus.validAfter = Instant.ofEpochMilli(consensus.getValidAfterMillis()).atZone(ZoneId.of("UTC")).toLocalDateTime();
        parsedStatus.measuredSums = measuredSums;
        return parsedStatus;
    }

    TotalcwRelayNetworkStatus parseRelayNetworkStatusVote(RelayNetworkStatusVote vote) {
        boolean containsMeasuredBandwidths = false;
        long[] measuredSums = new long[4];
        for (NetworkStatusEntry entry : vote.getStatusEntries().values()) {
            int measuredSumsIndex;
            if (null == entry.getFlags() || !entry.getFlags().contains("Running") || entry.getMeasured() < 0L) continue;
            containsMeasuredBandwidths = true;
            int n = measuredSumsIndex = (entry.getFlags().contains("Guard") ? 1 : 0) + (entry.getFlags().contains("Exit") && !entry.getFlags().contains("BadExit") ? 2 : 0);
            measuredSums[n] = measuredSums[n] + entry.getMeasured();
        }
        if (!containsMeasuredBandwidths) {
            return null;
        }
        TotalcwRelayNetworkStatus parsedStatus = new TotalcwRelayNetworkStatus();
        parsedStatus.validAfter = Instant.ofEpochMilli(vote.getValidAfterMillis()).atZone(ZoneId.of("UTC")).toLocalDateTime();
        parsedStatus.identityHex = vote.getIdentity();
        parsedStatus.nickname = vote.getNickname();
        parsedStatus.measuredSums = measuredSums;
        return parsedStatus;
    }
}

