/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.servers;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;

class Writer {
    Writer() {
    }

    void write(Path filePath, Iterable<String[]> outputLines) throws IOException {
        File parentFile = filePath.toFile().getParentFile();
        if (null != parentFile && !parentFile.exists() && !parentFile.mkdirs()) {
            throw new IOException("Unable to create parent directory of output file. Not writing this file.");
        }
        ArrayList<String> formattedOutputLines = new ArrayList<String>();
        for (String[] outputLine : outputLines) {
            StringBuilder formattedOutputLine = new StringBuilder();
            for (String outputLinePart : outputLine) {
                formattedOutputLine.append(',');
                if (null == outputLinePart) continue;
                formattedOutputLine.append(outputLinePart);
            }
            formattedOutputLines.add(formattedOutputLine.substring(1));
        }
        Files.write(filePath, formattedOutputLines, StandardCharsets.UTF_8, new OpenOption[0]);
    }
}

