/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.servers;

import java.time.Instant;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.torproject.descriptor.BridgeNetworkStatus;
import org.torproject.descriptor.NetworkStatusEntry;
import org.torproject.descriptor.RelayNetworkStatusConsensus;
import org.torproject.descriptor.RelayServerDescriptor;
import org.torproject.descriptor.ServerDescriptor;
import org.torproject.metrics.stats.servers.Ipv6NetworkStatus;
import org.torproject.metrics.stats.servers.Ipv6ServerDescriptor;

class Parser {
    private Pattern platformPattern = Pattern.compile("^Tor (.+) on (.+)$");

    Parser() {
    }

    Ipv6ServerDescriptor parseServerDescriptor(ServerDescriptor serverDescriptor) {
        Matcher platformMatcher;
        Ipv6ServerDescriptor parsedDescriptor = new Ipv6ServerDescriptor();
        parsedDescriptor.digest = serverDescriptor.getDigestSha1Hex();
        if (null != serverDescriptor.getPlatform() && (platformMatcher = this.platformPattern.matcher(serverDescriptor.getPlatform())).matches() && platformMatcher.groupCount() == 2) {
            parsedDescriptor.version = platformMatcher.group(1);
            parsedDescriptor.platform = platformMatcher.group(2);
        }
        for (String orAddress : serverDescriptor.getOrAddresses()) {
            if (StringUtils.countMatches((CharSequence)orAddress, (CharSequence)":") < 2) continue;
            parsedDescriptor.announced = true;
            break;
        }
        if (serverDescriptor instanceof RelayServerDescriptor) {
            parsedDescriptor.advertisedBandwidth = Math.min(serverDescriptor.getBandwidthRate(), serverDescriptor.getBandwidthBurst());
            if (serverDescriptor.getBandwidthObserved() >= 0) {
                parsedDescriptor.advertisedBandwidth = Math.min(parsedDescriptor.advertisedBandwidth, serverDescriptor.getBandwidthObserved());
            }
            parsedDescriptor.exiting = null != serverDescriptor.getIpv6DefaultPolicy() && (!"reject".equals(serverDescriptor.getIpv6DefaultPolicy()) || !"1-65535".equals(serverDescriptor.getIpv6PortList()));
        }
        return parsedDescriptor;
    }

    Ipv6NetworkStatus parseRelayNetworkStatusConsensus(RelayNetworkStatusConsensus consensus) {
        Ipv6NetworkStatus parsedStatus = new Ipv6NetworkStatus();
        parsedStatus.isRelay = true;
        parsedStatus.timestamp = Instant.ofEpochMilli(consensus.getValidAfterMillis()).atZone(ZoneId.of("UTC")).toLocalDateTime();
        parsedStatus.recommendedVersions = consensus.getRecommendedServerVersions();
        boolean consensusContainsBandwidthWeights = null != consensus.getBandwidthWeights() && consensus.getBandwidthWeights().keySet().containsAll(Arrays.asList("Wgg", "Wgd", "Wmg", "Wmm", "Wme", "Wmd", "Wee", "Wed"));
        float wgg = 0.0f;
        float wgd = 0.0f;
        float wmg = 0.0f;
        float wmm = 0.0f;
        float wme = 0.0f;
        float wmd = 0.0f;
        float wee = 0.0f;
        float wed = 0.0f;
        if (consensusContainsBandwidthWeights) {
            for (Map.Entry e : consensus.getBandwidthWeights().entrySet()) {
                float weight = ((Integer)e.getValue()).floatValue() / 10000.0f;
                switch ((String)e.getKey()) {
                    case "Wgg": {
                        wgg = weight;
                        break;
                    }
                    case "Wgd": {
                        wgd = weight;
                        break;
                    }
                    case "Wmg": {
                        wmg = weight;
                        break;
                    }
                    case "Wmm": {
                        wmm = weight;
                        break;
                    }
                    case "Wme": {
                        wme = weight;
                        break;
                    }
                    case "Wmd": {
                        wmd = weight;
                        break;
                    }
                    case "Wee": {
                        wee = weight;
                        break;
                    }
                    case "Wed": {
                        wed = weight;
                        break;
                    }
                }
            }
        }
        for (NetworkStatusEntry entry : consensus.getStatusEntries().values()) {
            if (!entry.getFlags().contains("Running")) continue;
            Ipv6NetworkStatus.Entry parsedEntry = new Ipv6NetworkStatus.Entry();
            parsedEntry.digest = entry.getDescriptor().toLowerCase();
            parsedEntry.flags = entry.getFlags();
            parsedEntry.reachable = false;
            for (String orAddress : entry.getOrAddresses()) {
                if (StringUtils.countMatches((CharSequence)orAddress, (CharSequence)":") < 2) continue;
                parsedEntry.reachable = true;
                break;
            }
            ++parsedStatus.running;
            boolean isExit = entry.getFlags().contains("Exit") && !entry.getFlags().contains("BadExit");
            boolean isGuard = entry.getFlags().contains("Guard");
            long consensusWeight = entry.getBandwidth();
            if (consensusWeight >= 0L) {
                Ipv6NetworkStatus ipv6NetworkStatus;
                parsedEntry.consensusWeight = Float.valueOf(consensusWeight);
                if (consensusContainsBandwidthWeights) {
                    if (isGuard && isExit) {
                        parsedEntry.guardWeight = Float.valueOf(parsedEntry.consensusWeight.floatValue() * wgd);
                        parsedEntry.middleWeight = Float.valueOf(parsedEntry.consensusWeight.floatValue() * wmd);
                        parsedEntry.exitWeight = Float.valueOf(parsedEntry.consensusWeight.floatValue() * wed);
                    } else if (isGuard) {
                        parsedEntry.guardWeight = Float.valueOf(parsedEntry.consensusWeight.floatValue() * wgg);
                        parsedEntry.middleWeight = Float.valueOf(parsedEntry.consensusWeight.floatValue() * wmg);
                        parsedEntry.exitWeight = Float.valueOf(0.0f);
                    } else if (isExit) {
                        parsedEntry.guardWeight = Float.valueOf(0.0f);
                        parsedEntry.middleWeight = Float.valueOf(parsedEntry.consensusWeight.floatValue() * wme);
                        parsedEntry.exitWeight = Float.valueOf(parsedEntry.consensusWeight.floatValue() * wee);
                    } else {
                        parsedEntry.guardWeight = Float.valueOf(0.0f);
                        parsedEntry.middleWeight = Float.valueOf(parsedEntry.consensusWeight.floatValue() * wmm);
                        parsedEntry.exitWeight = Float.valueOf(0.0f);
                    }
                    if (null == parsedStatus.totalGuardWeight) {
                        parsedStatus.totalGuardWeight = Float.valueOf(0.0f);
                        parsedStatus.totalMiddleWeight = Float.valueOf(0.0f);
                        parsedStatus.totalExitWeight = Float.valueOf(0.0f);
                    }
                    ipv6NetworkStatus = parsedStatus;
                    Float.valueOf(ipv6NetworkStatus.totalGuardWeight.floatValue() + parsedEntry.guardWeight.floatValue());
                    ipv6NetworkStatus.totalGuardWeight = ipv6NetworkStatus.totalGuardWeight;
                    ipv6NetworkStatus = parsedStatus;
                    Float.valueOf(ipv6NetworkStatus.totalMiddleWeight.floatValue() + parsedEntry.middleWeight.floatValue());
                    ipv6NetworkStatus.totalMiddleWeight = ipv6NetworkStatus.totalMiddleWeight;
                    ipv6NetworkStatus = parsedStatus;
                    Float.valueOf(ipv6NetworkStatus.totalExitWeight.floatValue() + parsedEntry.exitWeight.floatValue());
                    ipv6NetworkStatus.totalExitWeight = ipv6NetworkStatus.totalExitWeight;
                }
                if (null == parsedStatus.totalConsensusWeight) {
                    parsedStatus.totalConsensusWeight = Float.valueOf(0.0f);
                }
                ipv6NetworkStatus = parsedStatus;
                Float.valueOf(ipv6NetworkStatus.totalConsensusWeight.floatValue() + parsedEntry.consensusWeight.floatValue());
                ipv6NetworkStatus.totalConsensusWeight = ipv6NetworkStatus.totalConsensusWeight;
            }
            parsedStatus.entries.add(parsedEntry);
        }
        return parsedStatus;
    }

    Ipv6NetworkStatus parseBridgeNetworkStatus(BridgeNetworkStatus status) {
        Ipv6NetworkStatus parsedStatus = new Ipv6NetworkStatus();
        parsedStatus.isRelay = false;
        parsedStatus.timestamp = Instant.ofEpochMilli(status.getPublishedMillis()).atZone(ZoneId.of("UTC")).toLocalDateTime();
        for (NetworkStatusEntry entry : status.getStatusEntries().values()) {
            if (!entry.getFlags().contains("Running")) continue;
            ++parsedStatus.running;
            Ipv6NetworkStatus.Entry parsedEntry = new Ipv6NetworkStatus.Entry();
            parsedEntry.digest = entry.getDescriptor().toLowerCase();
            parsedEntry.flags = entry.getFlags();
            parsedStatus.entries.add(parsedEntry);
        }
        return parsedStatus;
    }
}

