/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.web;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public class DirectoryListing {
    private IndexNode index;
    private Map<String, List<String[]>> formattedTableEntries = new HashMap<String, List<String[]>>();
    private Map<String, String> formattedPublishedTimes = new HashMap<String, String>();
    private static final int READ_TIMEOUT = Integer.parseInt(System.getProperty("sun.net.client.defaultReadTimeout", "60000"));
    private static final int CONNECT_TIMEOUT = Integer.parseInt(System.getProperty("sun.net.client.defaultConnectTimeout", "60000"));
    private static ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    DirectoryListing(IndexNode index) {
        this.index = index;
        this.extractDirectoryListings();
    }

    public Map<String, List<String[]>> getFormattedTableEntries() {
        return this.formattedTableEntries;
    }

    public Map<String, String> getFormattedPublishedTimes() {
        return this.formattedPublishedTimes;
    }

    public static DirectoryListing ofHostString(String host) throws IOException {
        String urlString = host + "/index/index.json.gz";
        URLConnection connection = new URL(urlString).openConnection();
        connection.setReadTimeout(READ_TIMEOUT);
        connection.setConnectTimeout(CONNECT_TIMEOUT);
        connection.connect();
        try (GzipCompressorInputStream inputStream = new GzipCompressorInputStream(connection.getInputStream());){
            DirectoryListing directoryListing = DirectoryListing.ofInputStream(inputStream);
            return directoryListing;
        }
    }

    public static DirectoryListing ofInputStream(InputStream inputStream) throws IOException {
        IndexNode index = objectMapper.readValue(inputStream, IndexNode.class);
        return new DirectoryListing(index);
    }

    private void extractDirectoryListings() {
        HashMap<IndexNode, String> directoryNodes = new HashMap<IndexNode, String>();
        this.formattedTableEntries.put("/collector/", this.formatTableEntries("", "/", this.index.directories, this.index.files));
        for (IndexNode directory : this.index.directories) {
            directoryNodes.put(directory, "/");
        }
        LocalDate today = LocalDate.now();
        String todayString = today.format(DateTimeFormatter.ISO_DATE).substring(0, 7);
        String lastWeekString = today.minusWeeks(1L).format(DateTimeFormatter.ISO_DATE).substring(0, 7);
        while (!directoryNodes.isEmpty()) {
            IndexNode currentDirectoryNode = (IndexNode)directoryNodes.keySet().iterator().next();
            String parentPath = (String)directoryNodes.remove(currentDirectoryNode);
            if (null != currentDirectoryNode.directories) {
                for (IndexNode subDirectoryNode : currentDirectoryNode.directories) {
                    directoryNodes.put(subDirectoryNode, String.format("%s%s/", parentPath, currentDirectoryNode.path));
                }
            }
            String currentDirectoryPath = String.format("/collector%s%s/", parentPath, currentDirectoryNode.path);
            this.formattedTableEntries.put(currentDirectoryPath, this.formatTableEntries(parentPath, currentDirectoryNode.path + "/", currentDirectoryNode.directories, currentDirectoryNode.files));
            this.formattedPublishedTimes.put(currentDirectoryPath, this.formatPublishedTimes(todayString, lastWeekString, currentDirectoryNode.files));
        }
    }

    private List<String[]> formatTableEntries(String parentPath, String path, SortedSet<IndexNode> directories, SortedSet<IndexNode> files) {
        ArrayList<String[]> tableEntries = new ArrayList<String[]>();
        tableEntries.add(new String[]{"Parent Directory", String.format("/collector%s", parentPath.isEmpty() ? ".html" : parentPath), "", ""});
        if (null != directories) {
            for (IndexNode subDirectoryNode : directories) {
                tableEntries.add(new String[]{subDirectoryNode.path, String.format("/collector%s%s%s/", parentPath, path, subDirectoryNode.path), "", ""});
            }
        }
        if (null != files) {
            for (IndexNode fileNode : new TreeSet<IndexNode>(files).descendingSet()) {
                tableEntries.add(new String[]{fileNode.path, String.format("%s%s%s%s", this.index.path, parentPath, path, fileNode.path), fileNode.lastModified, DirectoryListing.formatBytes(fileNode.size)});
            }
        }
        return tableEntries;
    }

    static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        char pre = "KMGTPE".charAt(exp - 1);
        return String.format("%.1f %siB", (double)bytes / Math.pow(1024.0, exp), Character.valueOf(pre));
    }

    private String formatPublishedTimes(String todayString, String lastWeekString, SortedSet<IndexNode> files) {
        if (null != files) {
            TreeSet<String> publishedYearMonths = new TreeSet<String>();
            for (IndexNode file : files) {
                if (null != file.firstPublished && file.firstPublished.length() > 6) {
                    publishedYearMonths.add(file.firstPublished.substring(0, 7));
                }
                if (null == file.lastPublished || file.lastPublished.length() <= 6) continue;
                publishedYearMonths.add(file.lastPublished.substring(0, 7));
            }
            if (publishedYearMonths.isEmpty()) {
                return "";
            }
            if (((String)publishedYearMonths.last()).equals(todayString) || ((String)publishedYearMonths.last()).equals(lastWeekString)) {
                return String.format("%s to present", publishedYearMonths.first());
            }
            if (publishedYearMonths.size() == 1) {
                return (String)publishedYearMonths.first();
            }
            return String.format("%s to %s", publishedYearMonths.first(), publishedYearMonths.last());
        }
        return "";
    }

    private static class IndexNode
    implements Comparable<IndexNode> {
        String path;
        SortedSet<IndexNode> files;
        SortedSet<IndexNode> directories;
        Long size;
        String lastModified;
        String firstPublished;
        String lastPublished;

        private IndexNode() {
        }

        @Override
        public int compareTo(IndexNode other) {
            return this.path.compareTo(other.path);
        }
    }
}

