/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.web;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.torproject.metrics.web.DirectoryListing;

public class CollectorDirectoryProvider
implements Runnable {
    private String host;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final AtomicReference<DirectoryListing> index = new AtomicReference<Object>(null);

    CollectorDirectoryProvider(String host) {
        this.host = host;
        this.scheduler.scheduleAtFixedRate(this, 0L, 1L, TimeUnit.MINUTES);
    }

    DirectoryListing getIndex() {
        if (null == this.index.get()) {
            long waitingSinceMillis = System.currentTimeMillis();
            do {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (null == this.index.get() && System.currentTimeMillis() < waitingSinceMillis + 10000L);
        }
        return this.index.get();
    }

    @Override
    public void run() {
        try {
            DirectoryListing directoryListing = DirectoryListing.ofHostString(this.host);
            this.index.set(directoryListing);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

