/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.hidserv;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorReader;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.ExtraInfoDescriptor;
import org.torproject.descriptor.NetworkStatusEntry;
import org.torproject.descriptor.RelayNetworkStatusConsensus;
import org.torproject.metrics.stats.hidserv.ComputedNetworkFractions;
import org.torproject.metrics.stats.hidserv.DateTimeHelper;
import org.torproject.metrics.stats.hidserv.DocumentStore;
import org.torproject.metrics.stats.hidserv.ReportedHidServStats;

public class Parser {
    private static final Logger logger = LoggerFactory.getLogger(Parser.class);
    private File parseHistoryFile;
    private DescriptorReader descriptorReader;
    private File[] inDirectories;
    private File reportedHidServStatsFile;
    private DocumentStore<ReportedHidServStats> reportedHidServStatsStore;
    private File reportedV3HidServStatsFile;
    private DocumentStore<ReportedHidServStats> reportedV3HidServStatsStore;
    private File computedNetworkFractionsDirectory;
    private DocumentStore<ComputedNetworkFractions> computedNetworkFractionsStore;
    private Set<ReportedHidServStats> reportedHidServStats = new HashSet<ReportedHidServStats>();
    private Set<ReportedHidServStats> reportedV3HidServStats = new HashSet<ReportedHidServStats>();
    private static final String BIN_SIZE = "bin_size";

    public Parser(File[] inDirectories, File statusDirectory, DocumentStore<ReportedHidServStats> reportedHidServStatsStore, DocumentStore<ReportedHidServStats> reportedV3HidServStatsStore, DocumentStore<ComputedNetworkFractions> computedNetworkFractionsStore) {
        this.descriptorReader = DescriptorSourceFactory.createDescriptorReader();
        this.inDirectories = inDirectories;
        this.descriptorReader.setMaxDescriptorsInQueue(5);
        this.parseHistoryFile = new File(statusDirectory, "parse-history");
        this.reportedHidServStatsFile = new File(statusDirectory, "reported-hidserv-stats");
        this.reportedV3HidServStatsFile = new File(statusDirectory, "reported-v3hidserv-stats");
        this.computedNetworkFractionsDirectory = new File(statusDirectory, "computed-network-fractions");
        this.reportedHidServStatsStore = reportedHidServStatsStore;
        this.reportedV3HidServStatsStore = reportedV3HidServStatsStore;
        this.computedNetworkFractionsStore = computedNetworkFractionsStore;
    }

    public void readParseHistory() {
        if (this.parseHistoryFile.exists() && this.parseHistoryFile.isFile()) {
            TreeMap<String, Long> excludedFiles = new TreeMap<String, Long>();
            try (BufferedReader br = new BufferedReader(new FileReader(this.parseHistoryFile));){
                String line;
                while ((line = br.readLine()) != null) {
                    try {
                        String[] parts = line.split(" ", 2);
                        excludedFiles.put(parts[1], Long.parseLong(parts[0]));
                    }
                    catch (NumberFormatException e) {
                        logger.warn("Illegal line '{}' in parse history. Skipping line.", (Object)line, (Object)e);
                    }
                }
            }
            catch (IOException e) {
                logger.warn("Could not read history file '{}'. Not excluding descriptors in this execution.", (Object)this.parseHistoryFile.getAbsolutePath(), (Object)e);
            }
            this.descriptorReader.setExcludedFiles(excludedFiles);
        }
    }

    public void writeParseHistory() {
        TreeMap<String, Long> excludedAndParsedFiles = new TreeMap<String, Long>();
        excludedAndParsedFiles.putAll(this.descriptorReader.getExcludedFiles());
        excludedAndParsedFiles.putAll(this.descriptorReader.getParsedFiles());
        this.parseHistoryFile.getParentFile().mkdirs();
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.parseHistoryFile));){
            for (Map.Entry e : excludedAndParsedFiles.entrySet()) {
                String absolutePath = (String)e.getKey();
                long lastModifiedMillis = (Long)e.getValue();
                bw.write(lastModifiedMillis + " " + absolutePath + "\n");
            }
        }
        catch (IOException e) {
            logger.warn("Could not write history file '{}'. Not excluding descriptors in next execution.", (Object)this.parseHistoryFile.getAbsolutePath(), (Object)e);
        }
    }

    public void parseDescriptors() {
        for (Descriptor descriptor : this.descriptorReader.readDescriptors(this.inDirectories)) {
            if (descriptor instanceof ExtraInfoDescriptor) {
                this.parseExtraInfoDescriptor((ExtraInfoDescriptor)descriptor);
                continue;
            }
            if (!(descriptor instanceof RelayNetworkStatusConsensus)) continue;
            this.parseRelayNetworkStatusConsensus((RelayNetworkStatusConsensus)descriptor);
        }
        this.reportedHidServStatsStore.store(this.reportedHidServStatsFile, this.reportedHidServStats);
        this.reportedHidServStatsStore.store(this.reportedV3HidServStatsFile, this.reportedV3HidServStats);
    }

    private void parseExtraInfoDescriptor(ExtraInfoDescriptor extraInfoDescriptor) {
        String fingerprint = extraInfoDescriptor.getFingerprint();
        if (extraInfoDescriptor.getHidservStatsEndMillis() >= 0L && extraInfoDescriptor.getHidservStatsIntervalLength() >= 0L && extraInfoDescriptor.getHidservRendRelayedCells() != null && extraInfoDescriptor.getHidservRendRelayedCellsParameters() != null && extraInfoDescriptor.getHidservRendRelayedCellsParameters().containsKey(BIN_SIZE) && extraInfoDescriptor.getHidservDirOnionsSeen() != null && extraInfoDescriptor.getHidservDirOnionsSeenParameters() != null && extraInfoDescriptor.getHidservDirOnionsSeenParameters().containsKey(BIN_SIZE)) {
            ReportedHidServStats reportedStats = new ReportedHidServStats(fingerprint, extraInfoDescriptor.getHidservStatsEndMillis());
            reportedStats.setStatsIntervalSeconds(extraInfoDescriptor.getHidservStatsIntervalLength());
            reportedStats.setRendRelayedCells(this.removeNoise(extraInfoDescriptor.getHidservRendRelayedCells().longValue(), extraInfoDescriptor.getHidservRendRelayedCellsParameters().get(BIN_SIZE).longValue()));
            reportedStats.setDirOnionsSeen(this.removeNoise(extraInfoDescriptor.getHidservDirOnionsSeen().longValue(), extraInfoDescriptor.getHidservDirOnionsSeenParameters().get(BIN_SIZE).longValue()));
            this.reportedHidServStats.add(reportedStats);
        } else if (extraInfoDescriptor.getHidservStatsEndMillis() >= 0L || extraInfoDescriptor.getHidservRendRelayedCells() != null || extraInfoDescriptor.getHidservDirOnionsSeen() != null) {
            logger.warn("Relay {} published incomplete hidserv-stats. Ignoring.", (Object)fingerprint);
        }
        if (extraInfoDescriptor.getHidservV3StatsEndMillis() >= 0L && extraInfoDescriptor.getHidservV3StatsIntervalLength() >= 0L && extraInfoDescriptor.getHidservRendV3RelayedCells() != null && extraInfoDescriptor.getHidservRendV3RelayedCellsParameters() != null && extraInfoDescriptor.getHidservRendV3RelayedCellsParameters().containsKey(BIN_SIZE)) {
            ReportedHidServStats reportedV3HidServStats = new ReportedHidServStats(fingerprint, extraInfoDescriptor.getHidservV3StatsEndMillis());
            reportedV3HidServStats.setStatsIntervalSeconds(extraInfoDescriptor.getHidservV3StatsIntervalLength());
            reportedV3HidServStats.setRendRelayedCells(this.removeNoise(extraInfoDescriptor.getHidservRendV3RelayedCells().longValue(), extraInfoDescriptor.getHidservRendV3RelayedCellsParameters().get(BIN_SIZE).longValue()));
            reportedV3HidServStats.setDirOnionsSeen(this.removeNoise(extraInfoDescriptor.getHidservDirV3OnionsSeen().longValue(), extraInfoDescriptor.getHidservDirV3OnionsSeenParameters().get(BIN_SIZE).longValue()));
            this.reportedV3HidServStats.add(reportedV3HidServStats);
        } else if (extraInfoDescriptor.getHidservV3StatsEndMillis() >= 0L || extraInfoDescriptor.getHidservRendV3RelayedCells() != null || extraInfoDescriptor.getHidservDirV3OnionsSeen() != null) {
            logger.warn("Relay {} published incomplete v3hidserv-stats. Ignoring.", (Object)fingerprint);
        }
    }

    private long removeNoise(long reportedNumber, long binSize) {
        long roundedToNearestRightSideOfTheBin = Math.floorDiv(reportedNumber + binSize / 2L, binSize) * binSize;
        return roundedToNearestRightSideOfTheBin - binSize / 2L;
    }

    public void parseRelayNetworkStatusConsensus(RelayNetworkStatusConsensus consensus) {
        SortedMap<String, Integer> bandwidthWeights = consensus.getBandwidthWeights();
        if (bandwidthWeights == null) {
            logger.warn("Consensus with valid-after time {} doesn't contain any Wxx weights. Skipping.", (Object)DateTimeHelper.format(consensus.getValidAfterMillis()));
            return;
        }
        TreeSet<String> expectedWeightKeys = new TreeSet<String>(Arrays.asList("Wmg,Wmm,Wme,Wmd".split(",")));
        expectedWeightKeys.removeAll(bandwidthWeights.keySet());
        if (!expectedWeightKeys.isEmpty()) {
            logger.warn("Consensus with valid-after time {} doesn't contain expected Wmx weights. Skipping.", (Object)DateTimeHelper.format(consensus.getValidAfterMillis()));
            return;
        }
        double wmg = (double)((Integer)bandwidthWeights.get("Wmg")).intValue() / 10000.0;
        double wmm = (double)((Integer)bandwidthWeights.get("Wmm")).intValue() / 10000.0;
        double wme = (double)((Integer)bandwidthWeights.get("Wme")).intValue() / 10000.0;
        double wmd = (double)((Integer)bandwidthWeights.get("Wmd")).intValue() / 10000.0;
        TreeSet hsDirs = new TreeSet(Collections.reverseOrder());
        double totalWeightsRendezvousPoint = 0.0;
        TreeMap<Object, Double> weightsRendezvousPoint = new TreeMap<Object, Double>();
        for (Map.Entry<String, NetworkStatusEntry> e : consensus.getStatusEntries().entrySet()) {
            String fingerprint = e.getKey();
            NetworkStatusEntry statusEntry = e.getValue();
            SortedSet<String> flags = statusEntry.getFlags();
            if (flags.contains("HSDir")) {
                hsDirs.add(statusEntry.getFingerprint());
            }
            double d = 0.0;
            if (flags.contains("Fast")) {
                double d = statusEntry.getBandwidth();
                d = flags.contains("Guard") && flags.contains("Exit") ? (d *= wmd) : (flags.contains("Guard") ? (d *= wmg) : (flags.contains("Exit") ? (d *= wme) : (d *= wmm)));
            }
            weightsRendezvousPoint.put(fingerprint, d);
            totalWeightsRendezvousPoint += d;
        }
        HashSet<ComputedNetworkFractions> computedNetworkFractions = new HashSet<ComputedNetworkFractions>();
        TreeSet hsDirsCopy = new TreeSet(hsDirs);
        hsDirs.clear();
        for (String fingerprint : hsDirsCopy) {
            hsDirs.add("0" + fingerprint);
            hsDirs.add("1" + fingerprint);
        }
        double ringSize = new BigInteger("10000000000000000000000000000000000000000", 16).doubleValue();
        for (Map.Entry entry : consensus.getStatusEntries().entrySet()) {
            String fingerprint = (String)entry.getKey();
            NetworkStatusEntry statusEntry = (NetworkStatusEntry)entry.getValue();
            double fractionRendRelayedCells = 0.0;
            double fractionDirOnionsSeen = 0.0;
            if (statusEntry != null) {
                String fingerprintPrecededByOne = "1" + fingerprint;
                if (hsDirs.contains(fingerprintPrecededByOne)) {
                    String startResponsible = fingerprint;
                    int positionsToGo = 3;
                    Iterator iterator = hsDirs.tailSet(fingerprintPrecededByOne).iterator();
                    while (iterator.hasNext()) {
                        String hsDirFingerprint;
                        startResponsible = hsDirFingerprint = (String)iterator.next();
                        if (positionsToGo-- > 0) continue;
                        break;
                    }
                    fractionDirOnionsSeen = new BigInteger(fingerprintPrecededByOne, 16).subtract(new BigInteger(startResponsible, 16)).doubleValue() / ringSize;
                    fractionDirOnionsSeen /= 3.0;
                }
                fractionRendRelayedCells = (Double)weightsRendezvousPoint.get(fingerprint) / totalWeightsRendezvousPoint;
            }
            if (!(fractionRendRelayedCells > 0.0) && !(fractionDirOnionsSeen > 0.0)) continue;
            ComputedNetworkFractions fractions = new ComputedNetworkFractions(fingerprint, consensus.getValidAfterMillis());
            fractions.setFractionRendRelayedCells(fractionRendRelayedCells);
            fractions.setFractionDirOnionsSeen(fractionDirOnionsSeen);
            computedNetworkFractions.add(fractions);
        }
        String date = DateTimeHelper.format(consensus.getValidAfterMillis(), "yyyy-MM-dd");
        File file = new File(this.computedNetworkFractionsDirectory, date);
        this.computedNetworkFractionsStore.store(file, computedNetworkFractions);
    }
}

