/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.spi.CyclicBufferTracker;
import junit.framework.Assert;
import org.junit.Test;

public class CyclicBufferTrackerTest {
    CyclicBufferTracker<Object> tracker = new CyclicBufferTracker();
    String key = "a";

    @Test
    public void empty0() {
        long now = 3000L;
        this.tracker.removeStaleComponents(now);
        Assert.assertEquals((int)0, (int)this.tracker.liveKeysAsOrderedList().size());
        Assert.assertEquals((int)0, (int)this.tracker.getComponentCount());
    }

    @Test
    public void empty1() {
        long now = 3000L;
        Assert.assertNotNull((Object)this.tracker.getOrCreate(this.key, now++));
        this.tracker.removeStaleComponents(now += 1801000L);
        Assert.assertEquals((int)0, (int)this.tracker.liveKeysAsOrderedList().size());
        Assert.assertEquals((int)0, (int)this.tracker.getComponentCount());
        Assert.assertNotNull((Object)this.tracker.getOrCreate(this.key, now++));
    }

    @Test
    public void smoke() {
        long now = 3000L;
        CyclicBuffer cb = (CyclicBuffer)this.tracker.getOrCreate(this.key, now);
        Assert.assertEquals((Object)cb, (Object)this.tracker.getOrCreate(this.key, now++));
        this.tracker.removeStaleComponents(now += 1801000L);
        Assert.assertEquals((int)0, (int)this.tracker.liveKeysAsOrderedList().size());
        Assert.assertEquals((int)0, (int)this.tracker.getComponentCount());
    }

    @Test
    public void destroy() {
        long now = 3000L;
        CyclicBuffer cb = (CyclicBuffer)this.tracker.getOrCreate(this.key, now);
        cb.add(new Object());
        Assert.assertEquals((int)1, (int)cb.length());
        this.tracker.endOfLife(this.key);
        this.tracker.removeStaleComponents(now += 10010L);
        Assert.assertEquals((int)0, (int)this.tracker.liveKeysAsOrderedList().size());
        Assert.assertEquals((int)0, (int)this.tracker.getComponentCount());
        Assert.assertEquals((int)0, (int)cb.length());
    }
}

