/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.felix.bundlerepository.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.service.obr.Resource;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public class ObrURLStreamHandlerService
extends AbstractURLStreamHandlerService {
    private final BundleContext m_bundleContext;
    private final RepositoryAdmin m_reRepositoryAdmin;
    private final Logger m_logger;
    private String m_updateStrategy = "newest";
    public static final String OBR_UPDATE_STRATEGY = "obr.update.strategy";

    public ObrURLStreamHandlerService(BundleContext context, RepositoryAdmin admin) {
        this.m_bundleContext = context;
        this.m_reRepositoryAdmin = admin;
        this.m_logger = new Logger(context);
        if (this.m_bundleContext.getProperty(OBR_UPDATE_STRATEGY) != null) {
            this.m_updateStrategy = this.m_bundleContext.getProperty(OBR_UPDATE_STRATEGY);
        }
    }

    public URLConnection openConnection(URL u) throws IOException {
        String url = u.toExternalForm();
        URL remoteURL = null;
        Bundle[] bundles = this.m_bundleContext.getBundles();
        for (int i = 0; remoteURL == null && i < bundles.length; ++i) {
            if (!url.equals(bundles[i].getLocation())) continue;
            remoteURL = this.getRemoteUrlForBundle(bundles[i]);
        }
        if (remoteURL == null) {
            throw new IOException("could not resolve obr url to remote url! " + u);
        }
        return remoteURL.openConnection();
    }

    private URL getRemoteUrlForBundle(Bundle bundle) throws IOException {
        String bundleVersion = (String)bundle.getHeaders().get("Bundle-Version");
        StringBuffer buffer = new StringBuffer();
        buffer.append("(symbolicname=");
        buffer.append(bundle.getSymbolicName());
        buffer.append(")");
        Resource[] discoverResources = this.m_reRepositoryAdmin.discoverResources(buffer.toString());
        ResourceSelectionStrategy strategy = this.getStrategy(this.m_updateStrategy);
        Resource selected = strategy.selectOne(Version.parseVersion((String)bundleVersion), discoverResources);
        return selected.getURL();
    }

    private ResourceSelectionStrategy getStrategy(String strategy) {
        this.m_logger.log(4, "Using ResourceSelectionStrategy: " + strategy);
        if ("same".equals(strategy)) {
            return new SameSelectionStrategy(this.m_logger);
        }
        if ("newest".equals(strategy)) {
            return new NewestSelectionStrategy(this.m_logger);
        }
        throw new RuntimeException("Could not determine obr update strategy : " + strategy);
    }

    static class NewestSelectionStrategy
    extends ResourceSelectionStrategy {
        NewestSelectionStrategy(Logger logger) {
            super(logger);
        }

        Version determineVersion(Version currentVersion, SortedMap sortedResources) {
            return (Version)sortedResources.lastKey();
        }
    }

    static class SameSelectionStrategy
    extends ResourceSelectionStrategy {
        SameSelectionStrategy(Logger logger) {
            super(logger);
        }

        Version determineVersion(Version currentVersion, SortedMap sortedResources) {
            return currentVersion;
        }
    }

    private static abstract class ResourceSelectionStrategy {
        private final Logger m_logger;

        ResourceSelectionStrategy(Logger logger) {
            this.m_logger = logger;
        }

        Logger getLogger() {
            return this.m_logger;
        }

        final Resource selectOne(Version currentVersion, Resource[] resources) {
            TreeMap<Version, Resource> sortedResources = new TreeMap<Version, Resource>();
            for (int i = 0; i < resources.length; ++i) {
                sortedResources.put(resources[i].getVersion(), resources[i]);
            }
            Version versionToUse = this.determineVersion(currentVersion, sortedResources);
            this.m_logger.log(4, "Using Version " + versionToUse + " for bundle " + resources[0].getSymbolicName());
            return (Resource)sortedResources.get(versionToUse);
        }

        abstract Version determineVersion(Version var1, SortedMap var2);
    }
}

