/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.web;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RserveException;
import org.torproject.metrics.web.ContentProvider;
import org.torproject.metrics.web.GraphParameterChecker;
import org.torproject.metrics.web.Metric;
import org.torproject.metrics.web.RObject;
import org.torproject.metrics.web.TableParameterChecker;

public class RObjectGenerator
implements ServletContextListener {
    private String rserveHost;
    private int rservePort;
    private String cachedGraphsDirectory;
    private long maxCacheAge;
    private Map<String, Metric> availableGraphs;
    private Map<String, Metric> availableTables;
    private Map<String, RObjectGeneratorWorker> objectGeneratorThreads = new HashMap<String, RObjectGeneratorWorker>();

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        this.rserveHost = servletContext.getInitParameter("rserveHost");
        this.rservePort = Integer.parseInt(servletContext.getInitParameter("rservePort"));
        this.maxCacheAge = Long.parseLong(servletContext.getInitParameter("maxCacheAge"));
        this.cachedGraphsDirectory = servletContext.getInitParameter("cachedGraphsDir");
        this.availableGraphs = new LinkedHashMap<String, Metric>();
        this.availableTables = new LinkedHashMap<String, Metric>();
        for (Metric metric : ContentProvider.getInstance().getMetricsList()) {
            String type = metric.getType();
            String id = metric.getId();
            switch (type) {
                case "Graph": {
                    this.availableGraphs.put(id, metric);
                    break;
                }
                case "Table": {
                    this.availableTables.put(id, metric);
                    break;
                }
            }
        }
        servletContext.setAttribute("RObjectGenerator", (Object)this);
        new Thread(() -> {
            long lastUpdated = 0L;
            while (true) {
                long sleep;
                if ((sleep = this.maxCacheAge * 1000L / 2L + lastUpdated - System.currentTimeMillis()) > 0L) {
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                for (String tableId : this.availableTables.keySet()) {
                    this.generateTable(tableId, new HashMap<String, String[]>(), false);
                }
                for (String graphId : this.availableGraphs.keySet()) {
                    this.generateGraph(graphId, "png", new HashMap<String, String[]>(), false);
                }
                lastUpdated = System.currentTimeMillis();
            }
        }).start();
    }

    public void contextDestroyed(ServletContextEvent event) {
    }

    public RObject generateGraph(String requestedGraph, String fileType, Map<String, String[]> parameterMap, boolean checkCache) {
        if (!this.availableGraphs.containsKey(requestedGraph) || this.availableGraphs.get(requestedGraph).getFunction() == null) {
            return null;
        }
        Map<String, String[]> checkedParameters = GraphParameterChecker.getInstance().checkParameters(requestedGraph, parameterMap);
        if (checkedParameters == null) {
            return null;
        }
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("robust_call(as.call(list(");
        if ("csv".equalsIgnoreCase(fileType)) {
            queryBuilder.append("write_data, prepare_");
            checkedParameters = parameterMap;
        } else {
            queryBuilder.append("plot_");
        }
        String function = this.availableGraphs.get(requestedGraph).getFunction();
        queryBuilder.append(function).append(", ");
        StringBuilder imageFilenameBuilder = new StringBuilder(requestedGraph);
        for (Map.Entry<String, String[]> parameter : checkedParameters.entrySet()) {
            String[] parameterValues;
            String parameterName = parameter.getKey();
            for (String param : parameterValues = parameter.getValue()) {
                imageFilenameBuilder.append("-").append(param);
            }
            if (parameterValues.length < 2) {
                queryBuilder.append(parameterName).append("_p = '").append(parameterValues[0]).append("', ");
                continue;
            }
            queryBuilder.append(parameterName).append("_p = c(");
            for (int i = 0; i < parameterValues.length - 1; ++i) {
                queryBuilder.append("'").append(parameterValues[i]).append("', ");
            }
            queryBuilder.append("'").append(parameterValues[parameterValues.length - 1]).append("'), ");
        }
        imageFilenameBuilder.append(".").append(fileType);
        String imageFilename = imageFilenameBuilder.toString();
        queryBuilder.append("path_p = '%1$s')), '%1$s')");
        String query = queryBuilder.toString();
        File imageFile = new File(this.cachedGraphsDirectory + "/" + imageFilename);
        return this.generateObject(query, imageFile, imageFilename, checkCache);
    }

    public List<Map<String, String>> generateTable(String requestedTable, Map<String, String[]> parameterMap, boolean checkCache) {
        if (!this.availableTables.containsKey(requestedTable) || this.availableTables.get(requestedTable).getFunction() == null) {
            return null;
        }
        String function = this.availableTables.get(requestedTable).getFunction();
        Map<String, String[]> checkedParameters = TableParameterChecker.getInstance().checkParameters(requestedTable, parameterMap);
        if (checkedParameters == null) {
            return null;
        }
        StringBuilder queryBuilder = new StringBuilder().append(function).append("(");
        StringBuilder tableFilenameBuilder = new StringBuilder(requestedTable);
        for (Map.Entry<String, String[]> parameter : checkedParameters.entrySet()) {
            String[] parameterValues;
            String parameterName = parameter.getKey();
            for (String param : parameterValues = parameter.getValue()) {
                tableFilenameBuilder.append("-").append(param);
            }
            if (parameterValues.length < 2) {
                queryBuilder.append(parameterName).append(" = '").append(parameterValues[0]).append("', ");
                continue;
            }
            queryBuilder.append(parameterName).append(" = c(");
            for (int i = 0; i < parameterValues.length - 1; ++i) {
                queryBuilder.append("'").append(parameterValues[i]).append("', ");
            }
            queryBuilder.append("'").append(parameterValues[parameterValues.length - 1]).append("'), ");
        }
        tableFilenameBuilder.append(".tbl");
        String tableFilename = tableFilenameBuilder.toString();
        queryBuilder.append("path = '%s')");
        String query = queryBuilder.toString();
        return this.generateTable(query, tableFilename, checkCache);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Map<String, String>> generateTable(String query, String tableFilename, boolean checkCache) {
        File tableFile = new File(this.cachedGraphsDirectory + "/" + tableFilename);
        RObject tableObject = this.generateObject(query, tableFile, tableFilename, checkCache);
        if (null == tableObject) {
            return null;
        }
        byte[] tableBytes = tableObject.getBytes();
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(tableBytes), StandardCharsets.UTF_8));){
            String line = br.readLine();
            if (line == null) return result;
            ArrayList<String> headers = new ArrayList<String>(Arrays.asList(line.split(",")));
            while ((line = br.readLine()) != null) {
                String[] parts = line.split(",");
                if (headers.size() != parts.length) {
                    List<Map<String, String>> list = null;
                    return list;
                }
                HashMap<String, String> row = new HashMap<String, String>();
                for (int i = 0; i < headers.size(); ++i) {
                    row.put((String)headers.get(i), parts[i]);
                }
                result.add(row);
            }
            return result;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RObject generateObject(String query, File objectFile, String fileName, boolean checkCache) {
        RObjectGeneratorWorker worker;
        Map<String, RObjectGeneratorWorker> map = this.objectGeneratorThreads;
        synchronized (map) {
            if (this.objectGeneratorThreads.containsKey(query)) {
                worker = this.objectGeneratorThreads.get(query);
            } else {
                worker = new RObjectGeneratorWorker(query, objectFile, fileName, checkCache);
                this.objectGeneratorThreads.put(query, worker);
                worker.start();
            }
        }
        try {
            worker.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        map = this.objectGeneratorThreads;
        synchronized (map) {
            if (this.objectGeneratorThreads.containsKey(query) && this.objectGeneratorThreads.get(query) == worker) {
                this.objectGeneratorThreads.remove(query);
            }
        }
        return worker.getRObject();
    }

    private class RObjectGeneratorWorker
    extends Thread {
        private String query;
        private File objectFile;
        private String fileName;
        private boolean checkCache;
        private RObject result = null;

        public RObjectGeneratorWorker(String query, File objectFile, String fileName, boolean checkCache) {
            this.query = query;
            this.objectFile = objectFile;
            this.fileName = fileName;
            this.checkCache = checkCache;
        }

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            if (!this.checkCache || !this.objectFile.exists() || this.objectFile.lastModified() < now - RObjectGenerator.this.maxCacheAge * 1000L) {
                this.query = String.format(this.query, this.objectFile.getAbsolutePath());
                try {
                    RConnection rc = new RConnection(RObjectGenerator.this.rserveHost, RObjectGenerator.this.rservePort);
                    rc.eval(this.query);
                    rc.close();
                }
                catch (RserveException e) {
                    return;
                }
                if (!this.objectFile.exists() || this.objectFile.lastModified() < now - RObjectGenerator.this.maxCacheAge * 1000L) {
                    return;
                }
            }
            long lastModified = this.objectFile.lastModified();
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.objectFile), 1024);
                 ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int length;
                byte[] buffer = new byte[1024];
                while ((length = bis.read(buffer)) > 0) {
                    baos.write(buffer, 0, length);
                }
                bis.close();
                this.result = new RObject(baos.toByteArray(), this.fileName, lastModified);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public RObject getRObject() {
            return this.result;
        }
    }
}

