/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.totalcw;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.torproject.metrics.stats.totalcw.OutputLine;
import org.torproject.metrics.stats.totalcw.TotalcwRelayNetworkStatus;

class Database
implements AutoCloseable {
    private static final String jdbcString = String.format("jdbc:postgresql://localhost/totalcw?user=%s&password=%s", System.getProperty("metrics.dbuser", "metrics"), System.getProperty("metrics.dbpass", "password"));
    private Connection connection;
    private PreparedStatement psAuthoritySelect;
    private PreparedStatement psAuthorityInsert;
    private PreparedStatement psVoteSelect;
    private PreparedStatement psVoteInsert;

    Database() throws SQLException {
        this.connect();
        this.prepareStatements();
    }

    private void connect() throws SQLException {
        this.connection = DriverManager.getConnection(jdbcString);
        this.connection.setAutoCommit(false);
    }

    private void prepareStatements() throws SQLException {
        this.psAuthoritySelect = this.connection.prepareStatement("SELECT authority_id FROM authority WHERE nickname = ? AND identity_hex = ?");
        this.psAuthorityInsert = this.connection.prepareStatement("INSERT INTO authority (nickname, identity_hex) VALUES (?, ?)", 1);
        this.psVoteSelect = this.connection.prepareStatement("SELECT EXISTS (SELECT 1 FROM status WHERE valid_after = ? AND authority_id = ?)");
        this.psVoteInsert = this.connection.prepareStatement("INSERT INTO status (valid_after, authority_id, have_guard_flag, have_exit_flag, measured_sum) VALUES (?, ?, ?, ?, ?)");
    }

    void insertConsensus(TotalcwRelayNetworkStatus consensus) throws SQLException {
        if (null != consensus) {
            this.insertStatusIfAbsent(consensus.validAfter, null, consensus.measuredSums);
        }
    }

    void insertVote(TotalcwRelayNetworkStatus vote) throws SQLException {
        if (null != vote) {
            int authorityId = this.insertAuthorityIfAbsent(vote.nickname, vote.identityHex);
            this.insertStatusIfAbsent(vote.validAfter, authorityId, vote.measuredSums);
        }
    }

    private int insertAuthorityIfAbsent(String nickname, String identityHex) throws SQLException {
        int authorityId = -1;
        this.psAuthoritySelect.clearParameters();
        this.psAuthoritySelect.setString(1, nickname);
        this.psAuthoritySelect.setString(2, identityHex);
        try (ResultSet rs = this.psAuthoritySelect.executeQuery();){
            if (rs.next()) {
                authorityId = rs.getInt(1);
            }
        }
        if (authorityId < 0) {
            this.psAuthorityInsert.clearParameters();
            this.psAuthorityInsert.setString(1, nickname);
            this.psAuthorityInsert.setString(2, identityHex);
            this.psAuthorityInsert.execute();
            rs = this.psAuthorityInsert.getGeneratedKeys();
            try {
                if (rs.next()) {
                    authorityId = rs.getInt(1);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            if (authorityId < 0) {
                throw new SQLException("Could not retrieve auto-generated key for new authority entry.");
            }
        }
        return authorityId;
    }

    private void insertStatusIfAbsent(LocalDateTime validAfter, Integer authorityId, long[] measuredSums) throws SQLException {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
        this.psVoteSelect.clearParameters();
        this.psVoteSelect.setTimestamp(1, Timestamp.from(ZonedDateTime.of(validAfter, ZoneId.of("UTC")).toInstant()), calendar);
        if (null == authorityId) {
            this.psVoteSelect.setNull(2, 4);
        } else {
            this.psVoteSelect.setInt(2, authorityId);
        }
        try (ResultSet rs = this.psVoteSelect.executeQuery();){
            if (rs.next() && rs.getBoolean(1)) {
                return;
            }
        }
        for (int measuredSumsIndex = 0; measuredSumsIndex < 4; ++measuredSumsIndex) {
            this.psVoteInsert.clearParameters();
            this.psVoteInsert.setTimestamp(1, Timestamp.from(ZonedDateTime.of(validAfter, ZoneId.of("UTC")).toInstant()), calendar);
            if (null == authorityId) {
                this.psVoteInsert.setNull(2, 4);
            } else {
                this.psVoteInsert.setInt(2, authorityId);
            }
            this.psVoteInsert.setBoolean(3, 1 == (measuredSumsIndex & 1));
            this.psVoteInsert.setBoolean(4, 2 == (measuredSumsIndex & 2));
            this.psVoteInsert.setLong(5, measuredSums[measuredSumsIndex]);
            this.psVoteInsert.execute();
        }
    }

    void rollback() throws SQLException {
        this.connection.rollback();
    }

    void commit() throws SQLException {
        this.connection.commit();
    }

    Iterable<OutputLine> queryTotalcw() throws SQLException {
        ArrayList<OutputLine> statistics = new ArrayList<OutputLine>();
        Statement st = this.connection.createStatement();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
        String queryString = "SELECT " + OutputLine.columnHeadersDelimitedBy(", ") + " FROM totalcw";
        try (ResultSet rs = st.executeQuery(queryString);){
            while (rs.next()) {
                OutputLine outputLine = new OutputLine();
                outputLine.validAfterDate = rs.getDate(OutputLine.Column.VALID_AFTER_DATE.name(), calendar).toLocalDate();
                outputLine.nickname = rs.getString(OutputLine.Column.NICKNAME.name());
                outputLine.haveGuardFlag = rs.getBoolean(OutputLine.Column.HAVE_GUARD_FLAG.name());
                outputLine.haveExitFlag = rs.getBoolean(OutputLine.Column.HAVE_EXIT_FLAG.name());
                outputLine.measuredSumAvg = rs.getLong(OutputLine.Column.MEASURED_SUM_AVG.name());
                statistics.add(outputLine);
            }
        }
        return statistics;
    }

    @Override
    public void close() throws SQLException {
        this.connection.close();
    }
}

