/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.main;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private static final String baseDir = System.getProperty("metrics.basedir", "/srv/metrics.torproject.org/metrics");
    public static final File modulesDir = new File(baseDir, "work/modules");
    public static final File descriptorsDir = new File(baseDir, "work/shared/in");
    private static final File statsDir = new File(baseDir, "shared/stats");

    public static void main(String[] args) {
        Class[] modules;
        File[] outputDirs;
        log.info("Starting metrics update run.");
        for (File outputDir : outputDirs = new File[]{modulesDir, statsDir}) {
            if (outputDir.exists()) continue;
            if (outputDir.mkdirs()) {
                log.info("Successfully created module base directory {} and any nonexistent parent directories.", (Object)outputDir.getAbsolutePath());
                continue;
            }
            log.error("Unable to create module base directory {} and any nonexistent parent directories. Exiting.", (Object)outputDir.getAbsolutePath());
            return;
        }
        for (Class module : modules = new Class[]{org.torproject.metrics.stats.collectdescs.Main.class, org.torproject.metrics.stats.connbidirect.Main.class, org.torproject.metrics.stats.onionperf.Main.class, org.torproject.metrics.stats.bwhist.Main.class, org.torproject.metrics.stats.advbwdist.Main.class, org.torproject.metrics.stats.hidserv.Main.class, org.torproject.metrics.stats.clients.Main.class, org.torproject.metrics.stats.servers.Main.class, org.torproject.metrics.stats.webstats.Main.class, org.torproject.metrics.stats.totalcw.Main.class}) {
            try {
                log.info("Starting {} module.", (Object)module.getName());
                module.getDeclaredMethod("main", String[].class).invoke(null, new Object[]{args});
                log.info("Completed {} module.", (Object)module.getName());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Caught an exception when invoking the main method of the {} module. Moving on to the next module, if available.", (Throwable)e);
            }
        }
        log.info("Making module data available.");
        File[] moduleStatsDirs = new File[]{new File(modulesDir, "connbidirect/stats"), new File(modulesDir, "onionperf/stats"), new File(modulesDir, "bwhist/stats"), new File(modulesDir, "advbwdist/stats/advbwdist.csv"), new File(modulesDir, "hidserv/stats"), new File(modulesDir, "clients/stats/clients.csv"), new File(modulesDir, "clients/stats/userstats-combined.csv"), new File(modulesDir, "servers/stats"), new File(modulesDir, "webstats/stats"), new File(modulesDir, "totalcw/stats")};
        ArrayList<String> copiedFiles = new ArrayList<String>();
        for (File moduleStatsDir : moduleStatsDirs) {
            File[] fileArray;
            if (!moduleStatsDir.exists()) {
                log.warn("Skipping nonexistent module stats dir {}.", (Object)moduleStatsDir);
                continue;
            }
            if (moduleStatsDir.isDirectory()) {
                fileArray = moduleStatsDir.listFiles();
            } else {
                File[] fileArray2 = new File[1];
                fileArray = fileArray2;
                fileArray2[0] = moduleStatsDir;
            }
            File[] moduleStatsFiles = fileArray;
            if (null == moduleStatsFiles) {
                log.warn("Skipping nonexistent module stats dir {}.", (Object)moduleStatsDir);
                continue;
            }
            for (File statsFile : moduleStatsFiles) {
                if (!statsFile.isFile() || !statsFile.getName().endsWith(".csv")) continue;
                try {
                    Files.copy(statsFile.toPath(), new File(statsDir, statsFile.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
                    copiedFiles.add(statsFile.getName());
                }
                catch (IOException e) {
                    log.warn("Unable to copy module stats file {} to stats output directory {}. Skipping.", new Object[]{statsFile, statsDir, e});
                }
            }
        }
        if (!copiedFiles.isEmpty()) {
            log.info("Successfully copied {} files to stats output directory: {}", (Object)copiedFiles.size(), copiedFiles);
        }
        log.info("Completed metrics update run.");
    }
}

