/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.hidserv;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.stats.hidserv.Aggregator;
import org.torproject.metrics.stats.hidserv.ComputedNetworkFractions;
import org.torproject.metrics.stats.hidserv.DocumentStore;
import org.torproject.metrics.stats.hidserv.ExtrapolatedHidServStats;
import org.torproject.metrics.stats.hidserv.Extrapolator;
import org.torproject.metrics.stats.hidserv.Parser;
import org.torproject.metrics.stats.hidserv.ReportedHidServStats;

public class Main {
    private static Logger log = LoggerFactory.getLogger(Main.class);
    private static final File baseDir = new File(org.torproject.metrics.stats.main.Main.modulesDir, "hidserv");

    public static void main(String[] args) {
        File[] inDirectories = new File[]{new File(org.torproject.metrics.stats.main.Main.descriptorsDir, "recent/relay-descriptors/consensuses"), new File(org.torproject.metrics.stats.main.Main.descriptorsDir, "recent/relay-descriptors/extra-infos")};
        File statusDirectory = new File(baseDir, "status");
        log.info("Initializing parser and reading parse history...");
        DocumentStore<ReportedHidServStats> reportedHidServStatsStore = new DocumentStore<ReportedHidServStats>(ReportedHidServStats.class);
        DocumentStore<ComputedNetworkFractions> computedNetworkFractionsStore = new DocumentStore<ComputedNetworkFractions>(ComputedNetworkFractions.class);
        Parser parser = new Parser(inDirectories, statusDirectory, reportedHidServStatsStore, computedNetworkFractionsStore);
        parser.readParseHistory();
        log.info("Parsing descriptors...");
        parser.parseDescriptors();
        log.info("Writing parse history...");
        parser.writeParseHistory();
        log.info("Extrapolating statistics...");
        DocumentStore<ExtrapolatedHidServStats> extrapolatedHidServStatsStore = new DocumentStore<ExtrapolatedHidServStats>(ExtrapolatedHidServStats.class);
        Extrapolator extrapolator = new Extrapolator(statusDirectory, reportedHidServStatsStore, computedNetworkFractionsStore, extrapolatedHidServStatsStore);
        if (!extrapolator.extrapolateHidServStats()) {
            log.warn("Could not extrapolate statistics. Terminating.");
            return;
        }
        log.info("Aggregating statistics...");
        File hidservStatsExtrapolatedCsvFile = new File(baseDir, "stats/hidserv.csv");
        Aggregator aggregator = new Aggregator(statusDirectory, extrapolatedHidServStatsStore, hidservStatsExtrapolatedCsvFile);
        aggregator.aggregateHidServStats();
        log.info("Terminating.");
    }
}

