/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.hidserv;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class DateTimeHelper {
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final String ISO_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String ISO_DATE_HOUR_FORMAT = "yyyy-MM-dd HH";
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd";
    public static final String ISO_HOUR_FORMAT = "HH";
    private static ThreadLocal<Map<String, DateFormat>> dateFormats = ThreadLocal.withInitial(HashMap::new);
    public static final long NO_TIME_AVAILABLE = -1L;

    private DateTimeHelper() {
    }

    private static DateFormat getDateFormat(String format) {
        Map<String, DateFormat> threadDateFormats = dateFormats.get();
        if (!threadDateFormats.containsKey(format)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            dateFormat.setLenient(false);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            threadDateFormats.put(format, dateFormat);
        }
        return threadDateFormats.get(format);
    }

    public static String format(long millis, String format) {
        return DateTimeHelper.getDateFormat(format).format(millis);
    }

    public static String format(long millis) {
        return DateTimeHelper.format(millis, ISO_DATETIME_FORMAT);
    }

    public static long parse(String string, String format) {
        if (null == string) {
            return -1L;
        }
        try {
            return DateTimeHelper.getDateFormat(format).parse(string).getTime();
        }
        catch (ParseException e) {
            return -1L;
        }
    }

    public static long parse(String string) {
        return DateTimeHelper.parse(string, ISO_DATETIME_FORMAT);
    }
}

