/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.hidserv;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.stats.hidserv.DateTimeHelper;
import org.torproject.metrics.stats.hidserv.DocumentStore;
import org.torproject.metrics.stats.hidserv.ExtrapolatedHidServStats;

public class Aggregator {
    private static Logger log = LoggerFactory.getLogger(Aggregator.class);
    private File extrapolatedHidServStatsFile;
    private DocumentStore<ExtrapolatedHidServStats> extrapolatedHidServStatsStore;
    private File hidservStatsCsvFile;

    public Aggregator(File statusDirectory, DocumentStore<ExtrapolatedHidServStats> extrapolatedHidServStatsStore, File hidservStatsCsvFile) {
        this.extrapolatedHidServStatsFile = new File(statusDirectory, "extrapolated-hidserv-stats");
        this.extrapolatedHidServStatsStore = extrapolatedHidServStatsStore;
        this.hidservStatsCsvFile = hidservStatsCsvFile;
    }

    public void aggregateHidServStats() {
        Set<ExtrapolatedHidServStats> extrapolatedStats = this.extrapolatedHidServStatsStore.retrieve(this.extrapolatedHidServStatsFile);
        if (extrapolatedStats == null) {
            log.warn("Unable to retrieve extrapolated hidden-service statistics from file {}. Skipping aggregation step.", (Object)this.extrapolatedHidServStatsFile.getAbsolutePath());
            return;
        }
        String yesterday = DateTimeHelper.format(System.currentTimeMillis() - 86400000L, "yyyy-MM-dd");
        TreeMap extrapolatedCells = new TreeMap();
        TreeMap extrapolatedOnions = new TreeMap();
        for (ExtrapolatedHidServStats extrapolated : extrapolatedStats) {
            String date = DateTimeHelper.format(extrapolated.getStatsDateMillis(), "yyyy-MM-dd");
            if (date.compareTo(yesterday) >= 0) continue;
            if (extrapolated.getFractionRendRelayedCells() > 0.0) {
                extrapolatedCells.putIfAbsent(date, new ArrayList());
                ((List)extrapolatedCells.get(date)).add(new double[]{extrapolated.getExtrapolatedRendRelayedCells(), extrapolated.getFractionRendRelayedCells()});
            }
            if (!(extrapolated.getFractionDirOnionsSeen() > 0.0)) continue;
            extrapolatedOnions.putIfAbsent(date, new ArrayList());
            ((List)extrapolatedOnions.get(date)).add(new double[]{extrapolated.getExtrapolatedDirOnionsSeen(), extrapolated.getFractionDirOnionsSeen()});
        }
        StringBuilder sb = new StringBuilder();
        sb.append("date,type,wmean,wmedian,wiqm,frac,stats\n");
        for (int i = 0; i < 2; ++i) {
            String type = i == 0 ? "rend-relayed-cells" : "dir-onions-seen";
            TreeMap extrapolated = i == 0 ? extrapolatedCells : extrapolatedOnions;
            for (Map.Entry e : extrapolated.entrySet()) {
                List weightedValues = (List)e.getValue();
                weightedValues.sort(Comparator.comparingDouble(doubles -> doubles[0]));
                double sumReported = 0.0;
                double sumFraction = 0.0;
                for (double[] d : weightedValues) {
                    sumReported += d[0] * d[1];
                    sumFraction += d[1];
                }
                double weightedMean = sumReported / sumFraction;
                double weightIntervalEnd = 0.0;
                Double weightedMedian = null;
                double sumFractionInterquartile = 0.0;
                double sumReportedInterquartile = 0.0;
                for (double[] d : weightedValues) {
                    double extrapolatedValue = d[0];
                    double computedFraction = d[1];
                    double weightIntervalStart = weightIntervalEnd;
                    weightIntervalEnd += computedFraction;
                    if (weightedMedian == null && weightIntervalEnd > sumFraction * 0.5) {
                        weightedMedian = extrapolatedValue;
                    }
                    if (!(weightIntervalEnd >= sumFraction * 0.25) || !(weightIntervalStart <= sumFraction * 0.75)) continue;
                    double fractionBetweenQuartiles = Math.min(weightIntervalEnd, sumFraction * 0.75) - Math.max(weightIntervalStart, sumFraction * 0.25);
                    sumReportedInterquartile += extrapolatedValue * fractionBetweenQuartiles;
                    sumFractionInterquartile += fractionBetweenQuartiles;
                }
                double weightedInterquartileMean = sumReportedInterquartile / sumFractionInterquartile;
                String date = (String)e.getKey();
                int numStats = weightedValues.size();
                sb.append(String.format(Locale.US, "%s,%s,%.0f,%.0f,%.0f,%.8f,%d%n", date, type, weightedMean, weightedMedian, weightedInterquartileMean, sumFraction, numStats));
            }
        }
        this.hidservStatsCsvFile.getParentFile().mkdirs();
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.hidservStatsCsvFile));){
            bw.write(sb.toString());
        }
        catch (IOException e) {
            log.warn("Unable to write results to {}. Ignoring.", (Object)this.extrapolatedHidServStatsFile.getAbsolutePath());
        }
    }
}

