/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.clients;

import java.io.File;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.BandwidthHistory;
import org.torproject.descriptor.BridgeNetworkStatus;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorReader;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.ExtraInfoDescriptor;
import org.torproject.descriptor.NetworkStatusEntry;
import org.torproject.descriptor.RelayNetworkStatusConsensus;
import org.torproject.metrics.stats.clients.Database;
import org.torproject.metrics.stats.clients.Detector;
import org.torproject.metrics.stats.clients.Writer;

public class Main {
    private static Logger log = LoggerFactory.getLogger(Main.class);
    private static Database database;
    static final File baseDir;
    private static final long ONE_HOUR_MILLIS = 3600000L;
    private static final long ONE_DAY_MILLIS = 86400000L;
    private static final long ONE_WEEK_MILLIS = 604800000L;

    public static void main(String[] args) throws Exception {
        log.info("Starting clients module.");
        log.info("Connecting to database.");
        database = new Database();
        log.info("Reading relay descriptors and importing relevant parts into the database.");
        Main.parseRelayDescriptors();
        log.info("Reading bridge descriptors and importing relevant parts into the database.");
        Main.parseBridgeDescriptors();
        log.info("Processing newly imported data.");
        database.processImported();
        database.commit();
        log.info("Querying aggregated statistics from the database.");
        new Writer().write(new File(baseDir, "stats/userstats.csv").toPath(), database.queryEstimated());
        new Writer().write(new File(baseDir, "stats/userstats-combined.csv").toPath(), database.queryCombined());
        log.info("Disconnecting from database.");
        database.close();
        log.info("Running detector.");
        new Detector().detect();
        log.info("Terminating clients module.");
    }

    private static void parseRelayDescriptors() throws Exception {
        DescriptorReader descriptorReader = DescriptorSourceFactory.createDescriptorReader();
        File historyFile = new File(baseDir, "status/relay-descriptors");
        descriptorReader.setHistoryFile(historyFile);
        for (Descriptor descriptor : descriptorReader.readDescriptors(new File[]{new File(org.torproject.metrics.stats.main.Main.descriptorsDir, "recent/relay-descriptors/consensuses"), new File(org.torproject.metrics.stats.main.Main.descriptorsDir, "recent/relay-descriptors/extra-infos"), new File(org.torproject.metrics.stats.main.Main.descriptorsDir, "archive/relay-descriptors/consensuses"), new File(org.torproject.metrics.stats.main.Main.descriptorsDir, "archive/relay-descriptors/extra-infos")})) {
            if (descriptor instanceof ExtraInfoDescriptor) {
                Main.parseRelayExtraInfoDescriptor((ExtraInfoDescriptor)descriptor);
                continue;
            }
            if (!(descriptor instanceof RelayNetworkStatusConsensus)) continue;
            Main.parseRelayNetworkStatusConsensus((RelayNetworkStatusConsensus)descriptor);
        }
        database.commit();
        descriptorReader.saveHistoryFile(historyFile);
    }

    private static void parseRelayExtraInfoDescriptor(ExtraInfoDescriptor descriptor) throws SQLException {
        long publishedMillis = descriptor.getPublishedMillis();
        String fingerprint = descriptor.getFingerprint().toUpperCase();
        long dirreqStatsEndMillis = descriptor.getDirreqStatsEndMillis();
        long dirreqStatsIntervalLengthMillis = descriptor.getDirreqStatsIntervalLength() * 1000L;
        SortedMap requests = descriptor.getDirreqV3Reqs();
        BandwidthHistory dirreqWriteHistory = descriptor.getDirreqWriteHistory();
        Main.parseRelayDirreqV3Reqs(fingerprint, publishedMillis, dirreqStatsEndMillis, dirreqStatsIntervalLengthMillis, requests);
        Main.parseRelayDirreqWriteHistory(fingerprint, publishedMillis, dirreqWriteHistory);
    }

    private static void parseRelayDirreqV3Reqs(String fingerprint, long publishedMillis, long dirreqStatsEndMillis, long dirreqStatsIntervalLengthMillis, SortedMap<String, Integer> requests) throws SQLException {
        if (requests == null || publishedMillis - dirreqStatsEndMillis > 604800000L || dirreqStatsIntervalLengthMillis != 86400000L) {
            return;
        }
        long statsStartMillis = dirreqStatsEndMillis - dirreqStatsIntervalLengthMillis;
        long utcBreakMillis = dirreqStatsEndMillis / 86400000L * 86400000L;
        for (int i = 0; i < 2; ++i) {
            long toMillis;
            long fromMillis = i == 0 ? statsStartMillis : utcBreakMillis;
            long l = toMillis = i == 0 ? utcBreakMillis : dirreqStatsEndMillis;
            if (fromMillis >= toMillis) continue;
            double intervalFraction = (double)(toMillis - fromMillis) / (double)dirreqStatsIntervalLengthMillis;
            double sum = 0.0;
            for (Map.Entry<String, Integer> e : requests.entrySet()) {
                String country = e.getKey();
                double reqs = (double)e.getValue().intValue() - 4.0;
                sum += reqs;
                database.insertIntoImported(fingerprint, "relay", "responses", country, "", "", fromMillis, toMillis, reqs * intervalFraction);
            }
            database.insertIntoImported(fingerprint, "relay", "responses", "", "", "", fromMillis, toMillis, sum * intervalFraction);
        }
    }

    private static void parseRelayDirreqWriteHistory(String fingerprint, long publishedMillis, BandwidthHistory dirreqWriteHistory) throws SQLException {
        if (dirreqWriteHistory == null || publishedMillis - dirreqWriteHistory.getHistoryEndMillis() > 604800000L) {
            return;
        }
        long intervalLengthMillis = dirreqWriteHistory.getIntervalLength() * 1000L;
        block0: for (Map.Entry e : dirreqWriteHistory.getBandwidthValues().entrySet()) {
            long intervalEndMillis = (Long)e.getKey();
            long intervalStartMillis = intervalEndMillis - intervalLengthMillis;
            for (int i = 0; i < 2; ++i) {
                long fromMillis = intervalStartMillis;
                long toMillis = intervalEndMillis;
                double writtenBytes = ((Long)e.getValue()).longValue();
                if (intervalStartMillis / 86400000L < intervalEndMillis / 86400000L) {
                    long utcBreakMillis = intervalEndMillis / 86400000L * 86400000L;
                    if (i == 0) {
                        toMillis = utcBreakMillis;
                    } else if (i == 1) {
                        fromMillis = utcBreakMillis;
                    }
                    double intervalFraction = (double)(toMillis - fromMillis) / (double)intervalLengthMillis;
                    writtenBytes *= intervalFraction;
                } else if (i == 1) continue block0;
                database.insertIntoImported(fingerprint, "relay", "bytes", "", "", "", fromMillis, toMillis, writtenBytes);
            }
        }
    }

    private static void parseRelayNetworkStatusConsensus(RelayNetworkStatusConsensus consensus) throws SQLException {
        long fromMillis = consensus.getValidAfterMillis();
        long toMillis = consensus.getFreshUntilMillis();
        for (NetworkStatusEntry statusEntry : consensus.getStatusEntries().values()) {
            String fingerprint = statusEntry.getFingerprint().toUpperCase();
            if (!statusEntry.getFlags().contains("Running")) continue;
            database.insertIntoImported(fingerprint, "relay", "status", "", "", "", fromMillis, toMillis, 0.0);
        }
    }

    private static void parseBridgeDescriptors() throws Exception {
        DescriptorReader descriptorReader = DescriptorSourceFactory.createDescriptorReader();
        File historyFile = new File(baseDir, "status/bridge-descriptors");
        descriptorReader.setHistoryFile(historyFile);
        for (Descriptor descriptor : descriptorReader.readDescriptors(new File[]{new File(org.torproject.metrics.stats.main.Main.descriptorsDir, "recent/bridge-descriptors"), new File(org.torproject.metrics.stats.main.Main.descriptorsDir, "archive/bridge-descriptors")})) {
            if (descriptor instanceof ExtraInfoDescriptor) {
                Main.parseBridgeExtraInfoDescriptor((ExtraInfoDescriptor)descriptor);
                continue;
            }
            if (!(descriptor instanceof BridgeNetworkStatus)) continue;
            Main.parseBridgeNetworkStatus((BridgeNetworkStatus)descriptor);
        }
        database.commit();
        descriptorReader.saveHistoryFile(historyFile);
    }

    private static void parseBridgeExtraInfoDescriptor(ExtraInfoDescriptor descriptor) throws SQLException {
        String fingerprint = descriptor.getFingerprint().toUpperCase();
        long publishedMillis = descriptor.getPublishedMillis();
        long dirreqStatsEndMillis = descriptor.getDirreqStatsEndMillis();
        long dirreqStatsIntervalLengthMillis = descriptor.getDirreqStatsIntervalLength() * 1000L;
        Main.parseBridgeDirreqV3Resp(fingerprint, publishedMillis, dirreqStatsEndMillis, dirreqStatsIntervalLengthMillis, descriptor.getDirreqV3Resp(), descriptor.getBridgeIps(), descriptor.getBridgeIpTransports(), descriptor.getBridgeIpVersions());
        Main.parseBridgeDirreqWriteHistory(fingerprint, publishedMillis, descriptor.getDirreqWriteHistory());
    }

    private static void parseBridgeDirreqV3Resp(String fingerprint, long publishedMillis, long dirreqStatsEndMillis, long dirreqStatsIntervalLengthMillis, SortedMap<String, Integer> responses, SortedMap<String, Integer> bridgeIps, SortedMap<String, Integer> bridgeIpTransports, SortedMap<String, Integer> bridgeIpVersions) throws SQLException {
        if (responses == null || publishedMillis - dirreqStatsEndMillis > 604800000L || dirreqStatsIntervalLengthMillis != 86400000L) {
            return;
        }
        long statsStartMillis = dirreqStatsEndMillis - dirreqStatsIntervalLengthMillis;
        long utcBreakMillis = dirreqStatsEndMillis / 86400000L * 86400000L;
        double resp = (double)((Integer)responses.get("ok")).intValue() - 4.0;
        if (resp > 0.0) {
            for (int i = 0; i < 2; ++i) {
                long toMillis;
                long fromMillis = i == 0 ? statsStartMillis : utcBreakMillis;
                long l = toMillis = i == 0 ? utcBreakMillis : dirreqStatsEndMillis;
                if (fromMillis >= toMillis) continue;
                double intervalFraction = (double)(toMillis - fromMillis) / (double)dirreqStatsIntervalLengthMillis;
                database.insertIntoImported(fingerprint, "bridge", "responses", "", "", "", fromMillis, toMillis, resp * intervalFraction);
                Main.parseBridgeRespByCategory(fingerprint, fromMillis, toMillis, resp, dirreqStatsIntervalLengthMillis, "country", bridgeIps);
                Main.parseBridgeRespByCategory(fingerprint, fromMillis, toMillis, resp, dirreqStatsIntervalLengthMillis, "transport", bridgeIpTransports);
                Main.parseBridgeRespByCategory(fingerprint, fromMillis, toMillis, resp, dirreqStatsIntervalLengthMillis, "version", bridgeIpVersions);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void parseBridgeRespByCategory(String fingerprint, long fromMillis, long toMillis, double resp, long dirreqStatsIntervalLengthMillis, String category, SortedMap<String, Integer> frequencies) throws SQLException {
        double total = 0.0;
        TreeMap<String, Double> frequenciesCopy = new TreeMap<String, Double>();
        if (frequencies != null) {
            for (Map.Entry entry : frequencies.entrySet()) {
                if ((double)((Integer)entry.getValue()).intValue() < 4.0) continue;
                double frequency = (double)((Integer)entry.getValue()).intValue() - 4.0;
                frequenciesCopy.put((String)entry.getKey(), frequency);
                total += frequency;
            }
        }
        if (total == 0.0) {
            void var15_16;
            Iterator iterator = category;
            int n = -1;
            switch (((String)((Object)iterator)).hashCode()) {
                case 957831062: {
                    if (!((String)((Object)iterator)).equals("country")) break;
                    boolean bl = false;
                    break;
                }
                case 1052964649: {
                    if (!((String)((Object)iterator)).equals("transport")) break;
                    boolean bl = true;
                    break;
                }
                case 351608024: {
                    if (!((String)((Object)iterator)).equals("version")) break;
                    int n2 = 2;
                }
            }
            switch (var15_16) {
                case 0: {
                    frequenciesCopy.put("??", 4.0);
                    break;
                }
                case 1: {
                    frequenciesCopy.put("<OR>", 4.0);
                    break;
                }
                case 2: {
                    frequenciesCopy.put("v4", 4.0);
                    break;
                }
            }
            total = 4.0;
        }
        for (Map.Entry entry : frequenciesCopy.entrySet()) {
            double intervalFraction = (double)(toMillis - fromMillis) / (double)dirreqStatsIntervalLengthMillis;
            double val = resp * intervalFraction * (Double)entry.getValue() / total;
            switch (category) {
                case "country": {
                    database.insertIntoImported(fingerprint, "bridge", "responses", (String)entry.getKey(), "", "", fromMillis, toMillis, val);
                    break;
                }
                case "transport": {
                    database.insertIntoImported(fingerprint, "bridge", "responses", "", (String)entry.getKey(), "", fromMillis, toMillis, val);
                    break;
                }
                case "version": {
                    database.insertIntoImported(fingerprint, "bridge", "responses", "", "", (String)entry.getKey(), fromMillis, toMillis, val);
                    break;
                }
            }
        }
    }

    private static void parseBridgeDirreqWriteHistory(String fingerprint, long publishedMillis, BandwidthHistory dirreqWriteHistory) throws SQLException {
        if (dirreqWriteHistory == null || publishedMillis - dirreqWriteHistory.getHistoryEndMillis() > 604800000L) {
            return;
        }
        long intervalLengthMillis = dirreqWriteHistory.getIntervalLength() * 1000L;
        block0: for (Map.Entry e : dirreqWriteHistory.getBandwidthValues().entrySet()) {
            long intervalEndMillis = (Long)e.getKey();
            long intervalStartMillis = intervalEndMillis - intervalLengthMillis;
            for (int i = 0; i < 2; ++i) {
                long fromMillis = intervalStartMillis;
                long toMillis = intervalEndMillis;
                double writtenBytes = ((Long)e.getValue()).longValue();
                if (intervalStartMillis / 86400000L < intervalEndMillis / 86400000L) {
                    long utcBreakMillis = intervalEndMillis / 86400000L * 86400000L;
                    if (i == 0) {
                        toMillis = utcBreakMillis;
                    } else if (i == 1) {
                        fromMillis = utcBreakMillis;
                    }
                    double intervalFraction = (double)(toMillis - fromMillis) / (double)intervalLengthMillis;
                    writtenBytes *= intervalFraction;
                } else if (i == 1) continue block0;
                database.insertIntoImported(fingerprint, "bridge", "bytes", "", "", "", fromMillis, toMillis, writtenBytes);
            }
        }
    }

    private static void parseBridgeNetworkStatus(BridgeNetworkStatus status) throws SQLException {
        long publishedMillis = status.getPublishedMillis();
        long fromMillis = publishedMillis / 3600000L * 3600000L;
        long toMillis = fromMillis + 3600000L;
        for (NetworkStatusEntry statusEntry : status.getStatusEntries().values()) {
            String fingerprint = statusEntry.getFingerprint().toUpperCase();
            if (!statusEntry.getFlags().contains("Running")) continue;
            database.insertIntoImported(fingerprint, "bridge", "status", "", "", "", fromMillis, toMillis, 0.0);
        }
    }

    static {
        baseDir = new File(org.torproject.metrics.stats.main.Main.modulesDir, "clients");
    }
}

