/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.clients;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

class Database
implements AutoCloseable {
    private static final String jdbcString = String.format("jdbc:postgresql://localhost/userstats?user=%s&password=%s", System.getProperty("metrics.dbuser", "metrics"), System.getProperty("metrics.dbpass", "password"));
    private Connection connection;
    private PreparedStatement psImportedInsert;

    Database() throws SQLException {
        this.connect();
        this.prepareStatements();
    }

    private void connect() throws SQLException {
        this.connection = DriverManager.getConnection(jdbcString);
        this.connection.setAutoCommit(false);
    }

    private void prepareStatements() throws SQLException {
        this.psImportedInsert = this.connection.prepareStatement("INSERT INTO imported (fingerprint, node, metric, country, transport, version, stats_start, stats_end, val) VALUES (?, CAST(? AS node), CAST(? AS metric), ?, ?, ?, ?, ?, ?)");
    }

    void insertIntoImported(String fingerprint, String node, String metric, String country, String transport, String version, long fromMillis, long toMillis, double val) throws SQLException {
        if (fromMillis > toMillis) {
            return;
        }
        this.psImportedInsert.clearParameters();
        this.psImportedInsert.setString(1, fingerprint);
        this.psImportedInsert.setString(2, node);
        this.psImportedInsert.setString(3, metric);
        this.psImportedInsert.setString(4, country);
        this.psImportedInsert.setString(5, transport);
        this.psImportedInsert.setString(6, version);
        this.psImportedInsert.setTimestamp(7, Timestamp.from(Instant.ofEpochMilli(fromMillis)));
        this.psImportedInsert.setTimestamp(8, Timestamp.from(Instant.ofEpochMilli(toMillis)));
        this.psImportedInsert.setDouble(9, (double)Math.round(val * 10.0) / 10.0);
        this.psImportedInsert.execute();
    }

    void processImported() throws SQLException {
        this.connection.createStatement().execute("SELECT merge()");
        this.connection.createStatement().execute("SELECT aggregate()");
        this.connection.createStatement().execute("SELECT combine()");
        this.connection.createStatement().execute("TRUNCATE imported");
    }

    void commit() throws SQLException {
        this.connection.commit();
    }

    List<String[]> queryEstimated() throws SQLException {
        ArrayList<String[]> statistics = new ArrayList<String[]>();
        String columns = "date, node, country, transport, version, frac, users";
        statistics.add(columns.split(", "));
        Statement st = this.connection.createStatement();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
        String queryString = "SELECT " + columns + " FROM estimated";
        try (ResultSet rs = st.executeQuery(queryString);){
            while (rs.next()) {
                String[] outputLine = new String[]{rs.getDate("date", calendar).toLocalDate().toString(), rs.getString("node"), rs.getString("country"), rs.getString("transport"), rs.getString("version"), Database.getIntFromResultSet(rs, "frac"), Database.getIntFromResultSet(rs, "users")};
                statistics.add(outputLine);
            }
        }
        return statistics;
    }

    List<String[]> queryCombined() throws SQLException {
        ArrayList<String[]> statistics = new ArrayList<String[]>();
        String columns = "date, node, country, transport, version, frac, low, high";
        statistics.add(columns.split(", "));
        Statement st = this.connection.createStatement();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
        String queryString = "SELECT " + columns + " FROM combined";
        try (ResultSet rs = st.executeQuery(queryString);){
            while (rs.next()) {
                String[] outputLine = new String[]{rs.getDate("date", calendar).toLocalDate().toString(), rs.getString("node"), rs.getString("country"), rs.getString("transport"), rs.getString("version"), Database.getIntFromResultSet(rs, "frac"), Database.getIntFromResultSet(rs, "low"), Database.getIntFromResultSet(rs, "high")};
                statistics.add(outputLine);
            }
        }
        return statistics;
    }

    private static String getIntFromResultSet(ResultSet rs, String columnLabel) throws SQLException {
        int result = rs.getInt(columnLabel);
        return rs.wasNull() ? null : String.valueOf(result);
    }

    @Override
    public void close() throws SQLException {
        this.connection.close();
    }
}

