/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.bwhist;

import java.io.File;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorReader;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.ExtraInfoDescriptor;
import org.torproject.descriptor.NetworkStatusEntry;
import org.torproject.descriptor.RelayNetworkStatusConsensus;

public final class RelayDescriptorDatabaseImporter {
    private final long autoCommitCount = 500L;
    private int rhsCount = 0;
    private int rrsCount = 0;
    private Connection conn;
    private PreparedStatement psSs;
    private Set<Long> scheduledUpdates;
    private PreparedStatement psU;
    private PreparedStatement psR;
    private CallableStatement csH;
    private static Logger log = LoggerFactory.getLogger(RelayDescriptorDatabaseImporter.class);
    private SimpleDateFormat dateTimeFormat;
    private long lastCheckedStatusEntries;
    private Set<String> insertedStatusEntries = new HashSet<String>();
    private boolean importIntoDatabase = true;
    private File[] descriptorDirectories;
    private File historyFile;

    public RelayDescriptorDatabaseImporter(File[] descriptorDirectories, File historyFile, String connectionUrl) {
        this.descriptorDirectories = descriptorDirectories;
        this.historyFile = historyFile;
        if (connectionUrl != null) {
            try {
                this.conn = DriverManager.getConnection(connectionUrl);
                this.conn.setAutoCommit(false);
                this.psSs = this.conn.prepareStatement("SELECT fingerprint FROM statusentry WHERE validafter = ?");
                this.psR = this.conn.prepareStatement("INSERT INTO statusentry (validafter, nickname, fingerprint, descriptor, published, address, orport, dirport, isauthority, isbadexit, isbaddirectory, isexit, isfast, isguard, ishsdir, isnamed, isstable, isrunning, isunnamed, isvalid, isv2dir, isv3dir, version, bandwidth, ports, rawdesc) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                this.csH = this.conn.prepareCall("{call insert_bwhist(?, ?, ?, ?, ?, ?)}");
                this.psU = this.conn.prepareStatement("INSERT INTO scheduled_updates (date) VALUES (?)");
                this.scheduledUpdates = new HashSet<Long>();
            }
            catch (SQLException e) {
                log.warn("Could not connect to database or prepare statements.", (Throwable)e);
            }
        }
        this.dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    private void addDateToScheduledUpdates(long timestamp) throws SQLException {
        long dateMillis;
        if (!this.importIntoDatabase) {
            return;
        }
        try {
            dateMillis = this.dateTimeFormat.parse(this.dateTimeFormat.format(timestamp).substring(0, 10) + " 00:00:00").getTime();
        }
        catch (ParseException e) {
            log.warn("Internal parsing error.", (Throwable)e);
            return;
        }
        if (!this.scheduledUpdates.contains(dateMillis)) {
            this.psU.setDate(1, new Date(dateMillis));
            this.psU.execute();
            this.scheduledUpdates.add(dateMillis);
        }
    }

    public void addStatusEntryContents(long validAfter, String nickname, String fingerprint, String descriptor, long published, String address, long orPort, long dirPort, SortedSet<String> flags, String version, long bandwidth, String ports, byte[] rawDescriptor) {
        if (this.importIntoDatabase) {
            try {
                this.addDateToScheduledUpdates(validAfter);
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                Timestamp validAfterTimestamp = new Timestamp(validAfter);
                if (this.lastCheckedStatusEntries != validAfter) {
                    this.insertedStatusEntries.clear();
                    this.psSs.setTimestamp(1, validAfterTimestamp, cal);
                    ResultSet rs = this.psSs.executeQuery();
                    while (rs.next()) {
                        String insertedFingerprint = rs.getString(1);
                        this.insertedStatusEntries.add(insertedFingerprint);
                    }
                    rs.close();
                    this.lastCheckedStatusEntries = validAfter;
                }
                if (!this.insertedStatusEntries.contains(fingerprint)) {
                    this.psR.clearParameters();
                    this.psR.setTimestamp(1, validAfterTimestamp, cal);
                    this.psR.setString(2, nickname);
                    this.psR.setString(3, fingerprint);
                    this.psR.setString(4, descriptor);
                    this.psR.setTimestamp(5, new Timestamp(published), cal);
                    this.psR.setString(6, address);
                    this.psR.setLong(7, orPort);
                    this.psR.setLong(8, dirPort);
                    this.psR.setBoolean(9, flags.contains("Authority"));
                    this.psR.setBoolean(10, flags.contains("BadExit"));
                    this.psR.setBoolean(11, flags.contains("BadDirectory"));
                    this.psR.setBoolean(12, flags.contains("Exit"));
                    this.psR.setBoolean(13, flags.contains("Fast"));
                    this.psR.setBoolean(14, flags.contains("Guard"));
                    this.psR.setBoolean(15, flags.contains("HSDir"));
                    this.psR.setBoolean(16, flags.contains("Named"));
                    this.psR.setBoolean(17, flags.contains("Stable"));
                    this.psR.setBoolean(18, flags.contains("Running"));
                    this.psR.setBoolean(19, flags.contains("Unnamed"));
                    this.psR.setBoolean(20, flags.contains("Valid"));
                    this.psR.setBoolean(21, flags.contains("V2Dir"));
                    this.psR.setBoolean(22, flags.contains("V3Dir"));
                    this.psR.setString(23, version);
                    this.psR.setLong(24, bandwidth);
                    this.psR.setString(25, ports);
                    this.psR.setBytes(26, rawDescriptor);
                    this.psR.executeUpdate();
                    ++this.rrsCount;
                    if ((long)this.rrsCount % 500L == 0L) {
                        this.conn.commit();
                    }
                    this.insertedStatusEntries.add(fingerprint);
                }
            }
            catch (SQLException e) {
                log.warn("Could not add network status consensus entry. We won't make any further SQL requests in this execution.", (Throwable)e);
                this.importIntoDatabase = false;
            }
        }
    }

    public void addExtraInfoDescriptorContents(String fingerprint, long published, List<String> bandwidthHistoryLines) {
        if (!bandwidthHistoryLines.isEmpty()) {
            this.addBandwidthHistory(fingerprint.toLowerCase(), published, bandwidthHistoryLines);
        }
    }

    public void addBandwidthHistory(String fingerprint, long published, List<String> bandwidthHistoryStrings) {
        TreeSet historyLinesByDate = new TreeSet();
        for (String bandwidthHistoryString : bandwidthHistoryStrings) {
            long dateStart;
            long intervalEnd;
            long intervalLength;
            String[] parts = bandwidthHistoryString.split(" ");
            if (parts.length != 6) {
                log.debug("Bandwidth history line does not have expected number of elements. Ignoring this line.");
                continue;
            }
            try {
                intervalLength = Long.parseLong(parts[3].substring(1));
            }
            catch (NumberFormatException e) {
                log.debug("Bandwidth history line does not have valid interval length '{} {}'. Ignoring this line.", (Object)parts[3], (Object)parts[4]);
                continue;
            }
            String[] values = parts[5].split(",");
            if (intervalLength % 900L != 0L) {
                log.debug("Bandwidth history line does not contain multiples of 15-minute intervals. Ignoring this line.");
                continue;
            }
            if (intervalLength != 900L) {
                try {
                    long factor = intervalLength / 900L;
                    String[] newValues = new String[values.length * (int)factor];
                    for (int i = 0; i < newValues.length; ++i) {
                        newValues[i] = String.valueOf(Long.parseLong(values[i / (int)factor]) / factor);
                    }
                    values = newValues;
                    intervalLength = 900L;
                }
                catch (NumberFormatException e) {
                    log.debug("Number format exception while parsing bandwidth history line. Ignoring this line.");
                    continue;
                }
            }
            String type = parts[0];
            String intervalEndTime = parts[1] + " " + parts[2];
            try {
                intervalEnd = this.dateTimeFormat.parse(intervalEndTime).getTime();
                dateStart = this.dateTimeFormat.parse(parts[1] + " 00:00:00").getTime();
            }
            catch (ParseException e) {
                log.debug("Parse exception while parsing timestamp in bandwidth history line. Ignoring this line.");
                continue;
            }
            if (Math.abs(published - intervalEnd) > 604800000L) {
                log.debug("Extra-info descriptor publication time {} and last interval time {} in {} line differ by more than 7 days! Not adding this line!", new Object[]{this.dateTimeFormat.format(published), intervalEndTime, type});
                continue;
            }
            long currentIntervalEnd = intervalEnd;
            StringBuilder sb = new StringBuilder();
            TreeSet<String> newHistoryLines = new TreeSet<String>();
            try {
                for (int i = values.length - 1; i >= -1; --i) {
                    if (i == -1 || currentIntervalEnd < dateStart) {
                        sb.insert(0, intervalEndTime + " " + type + " (" + intervalLength + " s) ");
                        sb.setLength(sb.length() - 1);
                        String historyLine = sb.toString();
                        newHistoryLines.add(historyLine);
                        sb = new StringBuilder();
                        dateStart -= 86400000L;
                        intervalEndTime = this.dateTimeFormat.format(currentIntervalEnd);
                    }
                    if (i != -1) {
                        Long.parseLong(values[i]);
                        sb.insert(0, values[i] + ",");
                        currentIntervalEnd -= intervalLength * 1000L;
                        continue;
                    }
                    break;
                }
            }
            catch (NumberFormatException e) {
                log.debug("Number format exception while parsing bandwidth history line. Ignoring this line.");
                continue;
            }
            historyLinesByDate.addAll(newHistoryLines);
        }
        String lastDate = null;
        historyLinesByDate.add("EOL");
        long[] readArray = null;
        long[] writtenArray = null;
        long[] dirreadArray = null;
        long[] dirwrittenArray = null;
        int readOffset = 0;
        int writtenOffset = 0;
        int dirreadOffset = 0;
        int dirwrittenOffset = 0;
        for (String historyLine : historyLinesByDate) {
            String type;
            long lastIntervalTime;
            String[] parts = historyLine.split(" ");
            String currentDate = parts[0];
            if (lastDate != null && (historyLine.equals("EOL") || !currentDate.equals(lastDate))) {
                BigIntArray readIntArray = new BigIntArray(readArray, readOffset);
                BigIntArray writtenIntArray = new BigIntArray(writtenArray, writtenOffset);
                BigIntArray dirreadIntArray = new BigIntArray(dirreadArray, dirreadOffset);
                BigIntArray dirwrittenIntArray = new BigIntArray(dirwrittenArray, dirwrittenOffset);
                if (this.importIntoDatabase) {
                    try {
                        long dateMillis = this.dateTimeFormat.parse(lastDate + " 00:00:00").getTime();
                        this.addDateToScheduledUpdates(dateMillis);
                        this.csH.setString(1, fingerprint);
                        this.csH.setDate(2, new Date(dateMillis));
                        this.csH.setArray(3, readIntArray);
                        this.csH.setArray(4, writtenIntArray);
                        this.csH.setArray(5, dirreadIntArray);
                        this.csH.setArray(6, dirwrittenIntArray);
                        this.csH.addBatch();
                        ++this.rhsCount;
                        if ((long)this.rhsCount % 500L == 0L) {
                            this.csH.executeBatch();
                        }
                    }
                    catch (SQLException | ParseException e) {
                        log.warn("Could not insert bandwidth history line into database.  We won't make any further SQL requests in this execution.", (Throwable)e);
                        this.importIntoDatabase = false;
                    }
                }
                dirwrittenArray = null;
                dirreadArray = null;
                writtenArray = null;
                readArray = null;
            }
            if (historyLine.equals("EOL")) break;
            try {
                lastIntervalTime = this.dateTimeFormat.parse(parts[0] + " " + parts[1]).getTime() - this.dateTimeFormat.parse(parts[0] + " 00:00:00").getTime();
            }
            catch (ParseException e) {
                continue;
            }
            String[] stringValues = parts[5].split(",");
            long[] longValues = new long[stringValues.length];
            for (int i = 0; i < longValues.length; ++i) {
                longValues[i] = Long.parseLong(stringValues[i]);
            }
            int offset = (int)(lastIntervalTime / 900000L) - longValues.length + 1;
            switch (type = parts[2]) {
                case "read-history": {
                    readArray = longValues;
                    readOffset = offset;
                    break;
                }
                case "write-history": {
                    writtenArray = longValues;
                    writtenOffset = offset;
                    break;
                }
                case "dirreq-read-history": {
                    dirreadArray = longValues;
                    dirreadOffset = offset;
                    break;
                }
                case "dirreq-write-history": {
                    dirwrittenArray = longValues;
                    dirwrittenOffset = offset;
                    break;
                }
            }
            lastDate = currentDate;
        }
    }

    public void importRelayDescriptors() {
        DescriptorReader reader = DescriptorSourceFactory.createDescriptorReader();
        reader.setMaxDescriptorsInQueue(10);
        reader.setHistoryFile(this.historyFile);
        for (Descriptor descriptor : reader.readDescriptors(this.descriptorDirectories)) {
            if (descriptor instanceof RelayNetworkStatusConsensus) {
                this.addRelayNetworkStatusConsensus((RelayNetworkStatusConsensus)descriptor);
                continue;
            }
            if (!(descriptor instanceof ExtraInfoDescriptor)) continue;
            this.addExtraInfoDescriptor((ExtraInfoDescriptor)descriptor);
        }
        this.commit();
        reader.saveHistoryFile(this.historyFile);
    }

    private void addRelayNetworkStatusConsensus(RelayNetworkStatusConsensus consensus) {
        for (NetworkStatusEntry statusEntry : consensus.getStatusEntries().values()) {
            this.addStatusEntryContents(consensus.getValidAfterMillis(), statusEntry.getNickname(), statusEntry.getFingerprint().toLowerCase(), statusEntry.getDescriptor().toLowerCase(), statusEntry.getPublishedMillis(), statusEntry.getAddress(), statusEntry.getOrPort(), statusEntry.getDirPort(), statusEntry.getFlags(), statusEntry.getVersion(), statusEntry.getBandwidth(), statusEntry.getPortList(), statusEntry.getStatusEntryBytes());
        }
    }

    private void addExtraInfoDescriptor(ExtraInfoDescriptor descriptor) {
        ArrayList<String> bandwidthHistoryLines = new ArrayList<String>();
        if (descriptor.getWriteHistory() != null) {
            bandwidthHistoryLines.add(descriptor.getWriteHistory().getLine());
        }
        if (descriptor.getReadHistory() != null) {
            bandwidthHistoryLines.add(descriptor.getReadHistory().getLine());
        }
        if (descriptor.getDirreqWriteHistory() != null) {
            bandwidthHistoryLines.add(descriptor.getDirreqWriteHistory().getLine());
        }
        if (descriptor.getDirreqReadHistory() != null) {
            bandwidthHistoryLines.add(descriptor.getDirreqReadHistory().getLine());
        }
        this.addExtraInfoDescriptorContents(descriptor.getFingerprint().toLowerCase(), descriptor.getPublishedMillis(), bandwidthHistoryLines);
    }

    public void commit() {
        log.info("Finished importing relay descriptors: {} network status entries and {} bandwidth history elements", (Object)this.rrsCount, (Object)this.rhsCount);
        if (this.importIntoDatabase) {
            try {
                for (long dateMillis : this.scheduledUpdates) {
                    this.psU.setDate(1, new Date(dateMillis));
                    this.psU.execute();
                }
            }
            catch (SQLException e) {
                log.warn("Could not add scheduled dates for the next refresh run.", (Throwable)e);
            }
        }
        if (this.conn != null) {
            try {
                this.csH.executeBatch();
                this.conn.commit();
            }
            catch (SQLException e) {
                log.warn("Could not commit final records to database", (Throwable)e);
            }
        }
    }

    void aggregate() throws SQLException {
        Statement st = this.conn.createStatement();
        st.executeQuery("SELECT refresh_all()");
        this.commit();
    }

    List<String[]> queryBandwidth() throws SQLException {
        ArrayList<String[]> statistics = new ArrayList<String[]>();
        String columns = "date, isexit, isguard, bwread, bwwrite, dirread, dirwrite";
        statistics.add(columns.split(", "));
        Statement st = this.conn.createStatement();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
        String queryString = "SELECT " + columns + " FROM stats_bandwidth";
        try (ResultSet rs = st.executeQuery(queryString);){
            while (rs.next()) {
                String[] outputLine = new String[]{rs.getDate("date", calendar).toLocalDate().toString(), RelayDescriptorDatabaseImporter.getBooleanFromResultSet(rs, "isexit"), RelayDescriptorDatabaseImporter.getBooleanFromResultSet(rs, "isguard"), RelayDescriptorDatabaseImporter.getLongFromResultSet(rs, "bwread"), RelayDescriptorDatabaseImporter.getLongFromResultSet(rs, "bwwrite"), RelayDescriptorDatabaseImporter.getLongFromResultSet(rs, "dirread"), RelayDescriptorDatabaseImporter.getLongFromResultSet(rs, "dirwrite")};
                statistics.add(outputLine);
            }
        }
        return statistics;
    }

    private static String getBooleanFromResultSet(ResultSet rs, String columnLabel) throws SQLException {
        boolean result = rs.getBoolean(columnLabel);
        if (rs.wasNull()) {
            return null;
        }
        return result ? "t" : "f";
    }

    private static String getLongFromResultSet(ResultSet rs, String columnLabel) throws SQLException {
        long result = rs.getLong(columnLabel);
        return rs.wasNull() ? null : String.valueOf(result);
    }

    public void closeConnection() {
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            log.warn("Could not close database connection.", (Throwable)e);
        }
    }

    private static class BigIntArray
    implements Array {
        private final String stringValue;

        public BigIntArray(long[] array, int offset) {
            if (array == null) {
                this.stringValue = "[-1:-1]={0}";
            } else {
                StringBuilder sb = new StringBuilder("[" + offset + ":" + (offset + array.length - 1) + "]={");
                for (int i = 0; i < array.length; ++i) {
                    sb.append(i > 0 ? "," : "").append(array[i]);
                }
                sb.append('}');
                this.stringValue = sb.toString();
            }
        }

        public String toString() {
            return this.stringValue;
        }

        @Override
        public String getBaseTypeName() {
            return "int8";
        }

        @Override
        public void free() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getArray(long index, int count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getArray(long index, int count, Map<String, Class<?>> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getArray(Map<String, Class<?>> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getBaseType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ResultSet getResultSet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ResultSet getResultSet(long index, int count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ResultSet getResultSet(Map<String, Class<?>> map) {
            throw new UnsupportedOperationException();
        }
    }
}

