/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.advbwdist;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.commons.math3.stat.descriptive.rank.Median;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorReader;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.NetworkStatusEntry;
import org.torproject.descriptor.RelayNetworkStatusConsensus;
import org.torproject.descriptor.ServerDescriptor;

public class Main {
    private static final File baseDir = new File(org.torproject.metrics.stats.main.Main.modulesDir, "advbwdist");

    public static void main(String[] args) throws IOException {
        HashMap<String, Long> serverDescriptors = new HashMap<String, Long>();
        DescriptorReader descriptorReader = DescriptorSourceFactory.createDescriptorReader();
        for (Descriptor descriptor : descriptorReader.readDescriptors(new File[]{new File(org.torproject.metrics.stats.main.Main.descriptorsDir, "recent/relay-descriptors/server-descriptors")})) {
            if (!(descriptor instanceof ServerDescriptor)) continue;
            ServerDescriptor serverDescriptor = (ServerDescriptor)descriptor;
            String digest = serverDescriptor.getDigestSha1Hex();
            long advertisedBandwidth = Math.min(Math.min(serverDescriptor.getBandwidthRate(), serverDescriptor.getBandwidthBurst()), serverDescriptor.getBandwidthObserved());
            serverDescriptors.put(digest.toUpperCase(), advertisedBandwidth);
        }
        descriptorReader = DescriptorSourceFactory.createDescriptorReader();
        File historyFile = new File(baseDir, "status/parsed-consensuses");
        descriptorReader.setHistoryFile(historyFile);
        File resultsFile = new File(baseDir, "stats/advbwdist-validafter.csv");
        resultsFile.getParentFile().mkdirs();
        boolean writeHeader = !resultsFile.exists();
        BufferedWriter bw = new BufferedWriter(new FileWriter(resultsFile, true));
        if (writeHeader) {
            bw.write("valid_after,isexit,relay,percentile,advbw\n");
        }
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        for (Descriptor descriptor : descriptorReader.readDescriptors(new File[]{new File(org.torproject.metrics.stats.main.Main.descriptorsDir, "recent/relay-descriptors/consensuses")})) {
            int[] fastestRelays;
            if (!(descriptor instanceof RelayNetworkStatusConsensus)) continue;
            RelayNetworkStatusConsensus consensus = (RelayNetworkStatusConsensus)descriptor;
            String validAfter = dateTimeFormat.format(consensus.getValidAfterMillis());
            ArrayList<Long> advertisedBandwidthsAllRelays = new ArrayList<Long>();
            ArrayList<Long> advertisedBandwidthsExitsOnly = new ArrayList<Long>();
            for (NetworkStatusEntry networkStatusEntry : consensus.getStatusEntries().values()) {
                String serverDescriptorDigest;
                if (!networkStatusEntry.getFlags().contains("Running") || !serverDescriptors.containsKey(serverDescriptorDigest = networkStatusEntry.getDescriptor().toUpperCase())) continue;
                long advertisedBandwidth = (Long)serverDescriptors.get(serverDescriptorDigest);
                advertisedBandwidthsAllRelays.add(advertisedBandwidth);
                if (!networkStatusEntry.getFlags().contains("Exit") || networkStatusEntry.getFlags().contains("BadExit")) continue;
                advertisedBandwidthsExitsOnly.add(advertisedBandwidth);
            }
            advertisedBandwidthsAllRelays.sort(Collections.reverseOrder());
            advertisedBandwidthsExitsOnly.sort(Collections.reverseOrder());
            for (int fastestRelay : fastestRelays = new int[]{1, 2, 3, 5, 10, 20, 30, 50, 100, 200, 300, 500, 1000, 2000, 3000, 5000}) {
                if (advertisedBandwidthsAllRelays.size() < fastestRelay) continue;
                bw.write(String.format("%s,,%d,,%d%n", validAfter, fastestRelay, advertisedBandwidthsAllRelays.get(fastestRelay - 1)));
            }
            for (int fastestRelay : fastestRelays) {
                if (advertisedBandwidthsExitsOnly.size() < fastestRelay) continue;
                bw.write(String.format("%s,TRUE,%d,,%d%n", validAfter, fastestRelay, advertisedBandwidthsExitsOnly.get(fastestRelay - 1)));
            }
            int[] nArray = new int[]{0, 1, 2, 3, 5, 9, 10, 20, 25, 30, 40, 50, 60, 70, 75, 80, 90, 91, 95, 97, 98, 99, 100};
            if (!advertisedBandwidthsAllRelays.isEmpty()) {
                for (Map.Entry<Integer, Long> e : Main.computePercentiles(advertisedBandwidthsAllRelays, nArray).entrySet()) {
                    bw.write(String.format("%s,,,%d,%d%n", validAfter, e.getKey(), e.getValue()));
                }
            }
            if (advertisedBandwidthsExitsOnly.isEmpty()) continue;
            for (Map.Entry<Integer, Long> e : Main.computePercentiles(advertisedBandwidthsExitsOnly, nArray).entrySet()) {
                bw.write(String.format("%s,TRUE,,%d,%d%n", validAfter, e.getKey(), e.getValue()));
            }
        }
        descriptorReader.saveHistoryFile(historyFile);
        bw.close();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String today = dateFormat.format(new Date());
        TreeMap preAggregatedValues = new TreeMap();
        try (BufferedReader br = new BufferedReader(new FileReader(resultsFile));){
            String line;
            br.readLine();
            while (null != (line = br.readLine())) {
                String[] parts = line.split(",");
                String date = parts[0].substring(0, 10);
                if (date.compareTo(today) >= 0) continue;
                String string = parts[1].equals("TRUE") ? "t" : "";
                String keyWithoutTime = String.format("%s,%s,%s,%s", date, string, parts[2], parts[3]);
                long value = Long.parseLong(parts[4]);
                preAggregatedValues.putIfAbsent(keyWithoutTime, new ArrayList());
                ((List)preAggregatedValues.get(keyWithoutTime)).add(value);
            }
        }
        File aggregateResultsFile = new File(baseDir, "stats/advbwdist.csv");
        aggregateResultsFile.getParentFile().mkdirs();
        try (BufferedWriter bw2 = new BufferedWriter(new FileWriter(aggregateResultsFile));){
            bw2.write("date,isexit,relay,percentile,advbw\n");
            for (Map.Entry e : preAggregatedValues.entrySet()) {
                bw2.write(String.format("%s,%.0f%n", e.getKey(), Main.computeMedian((List)e.getValue())));
            }
        }
    }

    static SortedMap<Integer, Long> computePercentiles(List<Long> valueList, int ... percentiles) {
        TreeMap<Integer, Long> computedPercentiles = new TreeMap<Integer, Long>();
        double[] valueArray = new double[valueList.size()];
        long minValue = Long.MAX_VALUE;
        for (int i = 0; i < valueList.size(); ++i) {
            valueArray[i] = valueList.get(i).doubleValue();
            minValue = Math.min(minValue, valueList.get(i));
        }
        if (valueList.isEmpty()) {
            minValue = 0L;
        }
        Percentile percentile = new Percentile().withEstimationType(Percentile.EstimationType.R_7);
        percentile.setData(valueArray);
        for (int p : percentiles) {
            if (0 == p) {
                computedPercentiles.put(p, minValue);
                continue;
            }
            computedPercentiles.put(p, (long)Math.floor(percentile.evaluate((double)p)));
        }
        return computedPercentiles;
    }

    static double computeMedian(List<Long> valueList) {
        Median median = new Median().withEstimationType(Percentile.EstimationType.R_7);
        median.setData(valueList.stream().mapToDouble(Long::doubleValue).toArray());
        return Math.floor(median.evaluate());
    }
}

