/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument.pass1;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.cobertura.CoverageIgnore;
import net.sourceforge.cobertura.instrument.ContextMethodAwareMethodAdapter;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class DetectIgnoredCodeMethodVisitor
extends ContextMethodAwareMethodAdapter {
    final String superName;
    final Set<Integer> ignoredLineIds;
    final Set<String> ignoredMethodNamesAndSignatures;
    final Set<String> ignoreMethodAnnotations;
    final boolean ignoreTrivial;
    public IgnoredStatus ignoredStatus;

    public DetectIgnoredCodeMethodVisitor(MethodVisitor mv, Set<Integer> ignoredLineIds, Set<String> ignoredMethodNamesAndSignatures, boolean ignoreTrivial, Set<String> ignoreMethodAnnotations, String className, String superName, String methodName, String description, AtomicInteger lineIdGenerator) {
        super(mv, className, methodName, description, lineIdGenerator);
        this.superName = superName;
        this.ignoredLineIds = ignoredLineIds;
        this.ignoredMethodNamesAndSignatures = ignoredMethodNamesAndSignatures;
        this.ignoreTrivial = ignoreTrivial;
        this.ignoredStatus = DetectIgnoredCodeMethodVisitor.checkForTrivialSignature(methodName, description);
        this.ignoreMethodAnnotations = ignoreMethodAnnotations;
    }

    private static IgnoredStatus checkForTrivialSignature(String name, String desc) {
        Type[] args = Type.getArgumentTypes((String)desc);
        Type ret = Type.getReturnType((String)desc);
        if (name.equals("<init>")) {
            return IgnoredStatus.POSSIBLE_TRIVIAL_INIT;
        }
        if (name.startsWith("set") && args.length == 1 && ret.equals((Object)Type.VOID_TYPE)) {
            return IgnoredStatus.POSSIBLE_TRIVIAL_SETTER;
        }
        if ((name.startsWith("get") || name.startsWith("is") || name.startsWith("has")) && args.length == 0 && !ret.equals((Object)Type.VOID_TYPE)) {
            return IgnoredStatus.POSSIBLE_TRIVIAL_GETTER;
        }
        return IgnoredStatus.NOT_IGNORED;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        String clazz = Type.getObjectType((String)desc.substring(1).replace(';', ' ').trim()).getClassName();
        if (this.ignoreMethodAnnotations.contains(clazz) || desc.equals(Type.getDescriptor(CoverageIgnore.class))) {
            this.ignoredStatus = IgnoredStatus.IGNORED_BY_ANNOTATION;
        }
        return super.visitAnnotation(desc, visible);
    }

    public void visitJumpInsn(int arg0, Label arg1) {
        this.markNotTrivial();
        super.visitJumpInsn(arg0, arg1);
    }

    public void visitFieldInsn(int opcode, String string, String string1, String string2) {
        super.visitFieldInsn(opcode, string, string1, string2);
        if (this.ignoredStatus.isTrivial() && (this.ignoredStatus == IgnoredStatus.POSSIBLE_TRIVIAL_GETTER && opcode != 180 || this.ignoredStatus == IgnoredStatus.POSSIBLE_TRIVIAL_SETTER && opcode != 181 || this.ignoredStatus == IgnoredStatus.POSSIBLE_TRIVIAL_INIT && opcode != 181)) {
            this.markNotTrivial();
        }
    }

    public void visitVarInsn(int opcode, int i1) {
        super.visitVarInsn(opcode, i1);
        if (this.ignoredStatus.isTrivial() && opcode != 21 && opcode != 22 && opcode != 23 && opcode != 24 && opcode != 25) {
            this.markNotTrivial();
        }
    }

    public void visitTypeInsn(int arg0, String arg1) {
        super.visitTypeInsn(arg0, arg1);
        this.markNotTrivial();
    }

    public void visitLookupSwitchInsn(Label arg0, int[] arg1, Label[] arg2) {
        super.visitLookupSwitchInsn(arg0, arg1, arg2);
        this.markNotTrivial();
    }

    public void visitTableSwitchInsn(int arg0, int arg1, Label arg2, Label[] arg3) {
        super.visitTableSwitchInsn(arg0, arg1, arg2, arg3);
        this.markNotTrivial();
    }

    public void visitMultiANewArrayInsn(String arg0, int arg1) {
        super.visitMultiANewArrayInsn(arg0, arg1);
        this.markNotTrivial();
    }

    public void visitIincInsn(int arg0, int arg1) {
        super.visitIincInsn(arg0, arg1);
        this.markNotTrivial();
    }

    public void visitLdcInsn(Object arg0) {
        super.visitLdcInsn(arg0);
        this.markNotTrivial();
    }

    public void visitIntInsn(int arg0, int arg1) {
        super.visitIntInsn(arg0, arg1);
        this.markNotTrivial();
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (!(!this.ignoredStatus.isTrivial() || this.ignoredStatus == IgnoredStatus.POSSIBLE_TRIVIAL_INIT && name.equals("<init>") && owner.equals(this.superName) && opcode == 183)) {
            this.markNotTrivial();
        }
        super.visitMethodInsn(opcode, owner, name, desc);
    }

    public void visitEnd() {
        super.visitEnd();
        if (this.ignoredStatus == IgnoredStatus.IGNORED_BY_ANNOTATION || this.ignoreTrivial && this.ignoredStatus.isTrivial()) {
            this.ignoredMethodNamesAndSignatures.add(this.methodName + this.methodSignature);
        }
    }

    public void markNotTrivial() {
        if (this.ignoredStatus.isTrivial()) {
            this.ignoredStatus = IgnoredStatus.NOT_IGNORED;
        }
    }

    static enum IgnoredStatus {
        POSSIBLE_TRIVIAL_GETTER,
        POSSIBLE_TRIVIAL_SETTER,
        POSSIBLE_TRIVIAL_INIT,
        IGNORED_BY_ANNOTATION,
        NOT_IGNORED;


        boolean isTrivial() {
            return this == POSSIBLE_TRIVIAL_GETTER || this == POSSIBLE_TRIVIAL_SETTER || this == POSSIBLE_TRIVIAL_INIT;
        }
    }
}

