/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.web;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.torproject.metrics.web.Category;
import org.torproject.metrics.web.Metric;
import org.torproject.metrics.web.News;

public class ContentProvider {
    private static ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    private static ContentProvider instance = new ContentProvider();
    private List<Metric> metricsList;
    private List<Category> categoriesList;
    private List<News> newsList;

    public static ContentProvider getInstance() {
        return instance;
    }

    private ContentProvider() {
        try {
            this.metricsList = Arrays.asList(objectMapper.readValue((Reader)new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("WEB-INF/json/metrics.json")), Metric[].class));
            this.categoriesList = Arrays.asList(objectMapper.readValue((Reader)new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("WEB-INF/json/categories.json")), Category[].class));
            this.newsList = Arrays.asList(objectMapper.readValue((Reader)new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("WEB-INF/json/news.json")), News[].class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Metric> getMetricsList() {
        return new ArrayList<Metric>(this.metricsList);
    }

    public List<Category> getCategoriesList() {
        return new ArrayList<Category>(this.categoriesList);
    }

    public List<News> getNewsList() {
        return new ArrayList<News>(this.newsList);
    }
}

